################################################################################

proc GraphWin {{w .graph}} {
   global clicktype1 viewtop drag_id
   global hostfile prefs
   global ntcol ntrow
   global nahf
   global helptext env nundo aff_fromw entry1 nclick colors

   set clicktype1 0
   set viewtop 0
   set addtype none
   set nclick 0

   set helptext \
"Move file from host to host:  Drag file rectangle with mouse-1 to host circle
Edit file: Double-click mouse-1 on file rectangle
Scroll Canvas: Use scrollbar or ctrl-mouse-1
Click on host circle or file rectangle for more information"

   catch {destroy $w}
   toplevel $w
   wm title $w "PADE Graph"
   wm iconname $w "Graph"
   wm minsize $w 1 1
   wm maxsize $w 1280 1024
   wm geometry $w +170+218
   wm iconbitmap $w @$env(PADE_ROOT)/pade/pade_icon.xbm
   $w config -cursor {arrow red white}

   frame $w.f1 -bd 1 -relief raised
   frame $w.f2 -bd 1 -relief raised
   frame $w.f3 -bd 1 -relief raised
   frame $w.f4 -bd 1 -relief raised
   
#-------------------------------------------------------------------------------
#  HOSTS

   menubutton $w.f1.hosts -text "Hosts" -menu $w.f1.hosts.menu
   menu $w.f1.hosts.menu

#-------------------------------------------------------------------------------
#  ADD HOST

   $w.f1.hosts.menu add command -label "Add..." -acc "Ctrl-h" -command {
      TextWrite .graph.f2.text ""
      AddHost "" "" "ADD" "" .graph
   }

#-------------------------------------------------------------------------------
#  ADD HOSTS FROM HOSTFILE

   $w.f1.hosts.menu add command -label "Add from Hostfile..." -command {
      TextWrite .graph.f2.text ""
      IncrUndo
      AddHostFile .graph
      if {$nahf > 0} {
         GraphUpdate
         TextWrite .graph.f2.text \
	    "$nahf hosts added from [file tail $hostfile]"
	 HostListboxWrite
	 HostListboxScroll1
      }
   }

#-------------------------------------------------------------------------------
#  COPY HOST

   $w.f1.hosts.menu add command -label "Copy" -command {
      set addtype none
      set clicktype1 -2
      TextWrite .graph.f2.text "Click on Host (circle) to be Copied"
   }

#-------------------------------------------------------------------------------
#  MODIFY HOST

   $w.f1.hosts.menu add command -label "Modify" -command {
      set addtype none
      set clicktype1 -3
      TextWrite .graph.f2.text "Click on Host (circle) to be Modified"
   }

#-------------------------------------------------------------------------------
#  DELETE HOST

   $w.f1.hosts.menu add command -label "Delete" -command {
      set addtype none
      set clicktype1 -1
      TextWrite .graph.f2.text "Click on Host (circle) to be Deleted"
   }

#-------------------------------------------------------------------------------
#  FILES

   menubutton $w.f1.files -text "Files" -menu $w.f1.files.menu
   menu $w.f1.files.menu

#-------------------------------------------------------------------------------
#  ADD FILE

   $w.f1.files.menu add command -label "Add..." -command {
      set addtype file
      set clicktype1 1
      set entry1 ""
      AddFile "" "" "ADD" "" ".graph"
   }

#-------------------------------------------------------------------------------
#  COPY FILES FROM HOST

   $w.f1.files.menu add command -label "Copy From Host" -command {
      set addtype none
      set clicktype1 -4
      set nclick 0
      TextWrite .graph.f2.text "Click on Host (circle) for Files to be Copied FROM"
   }

#-------------------------------------------------------------------------------
#  COPY FILE

   $w.f1.files.menu add command -label "Copy" -command {
      set addtype none
      set clicktype1 -12
      TextWrite .graph.f2.text "Click on File (rectangle) to be Copied"
   }

#-------------------------------------------------------------------------------
#  MODIFY FILE

   $w.f1.files.menu add command -label "Modify" -command {
      set addtype none
      set clicktype1 -13
      TextWrite .graph.f2.text "Click on File (rectangle) to be Modified"
   }

#-------------------------------------------------------------------------------
#  GLOBAL REPLACE FILE

   $w.f1.files.menu add command -label "Global Replace" -command {
      set addtype none
      set clicktype1 -5
      ReplaceString
      TextWrite .graph.f2.text "Click on Host (circle) for Files for Global Replace"
   }

#-------------------------------------------------------------------------------
#  DELETE FILE

   $w.f1.files.menu add command -label "Delete" -command {
      set addtype none
      set clicktype1 -11
      TextWrite .graph.f2.text "Click on File (rectangle) to be Deleted"
   }

#-------------------------------------------------------------------------------
#  UNDO

   button $w.f1.undo -text "Undo" -relief flat -command {
      TextWrite .graph.f2.text ""
      if {$nundo > 0} {
         DecrUndo
         GraphUpdate
	 HostListboxWrite
	 FilesListboxWrite
	 UpdateButtons
      }
   }

#-------------------------------------------------------------------------------
#  SORT ALL

   button $w.f1.sort -text "Sort" -relief flat -command {SortAll .graph}

#-------------------------------------------------------------------------------
#  COLUMNS

   menubutton $w.f1.columns -text "Columns" -menu $w.f1.columns.menu
   menu $w.f1.columns.menu -tearoff 0
   set colval {2 4 6 8 10 15 20 25 30}
   foreach item $colval { 
      $w.f1.columns.menu add radiobutton -label $item -variable ntcol \
         -value $item -command {
        GraphRedraw
      }
   }
   
#-------------------------------------------------------------------------------
#  ROWS

   menubutton $w.f1.rows -text "Rows" -menu $w.f1.rows.menu
   menu $w.f1.rows.menu -tearoff 0
   set rowval {12 16 20 24 32 40 48}
   foreach item $rowval { 
      $w.f1.rows.menu add radiobutton -label $item -variable ntrow \
         -value $item -command {
         GraphRedraw
      }
   }
   
#-------------------------------------------------------------------------------
#  HELP

   button $w.f1.help -text "Help" -relief flat -command {
      TextWrite .graph.f2.text $helptext
   }
   
#-------------------------------------------------------------------------------
#  CLOSE

   button $w.f4.close -text "Close" -command {
      if {[winfo exists .addfil] && ($aff_fromw==".graph")} {destroy .addfil}
      destroy .graph
   }
 
   pack $w.f1.hosts $w.f1.files -side left -padx 0.25m
   pack $w.f1.undo $w.f1.sort -side left -ipadx 0.1m -padx 0.1m
   pack $w.f1.columns $w.f1.rows -side left -padx 0.25m
   pack $w.f1.help -side right

   pack $w.f4.close -side left -expand 1 -pady 4m -ipadx 2m -ipady 1m

#-------------------------------------------------------------------------------

   text	$w.f2.text -height 4 -width 1 -fg $colors(TEXT) -state disabled \
      -relief flat
   pack $w.f2.text -fill x -expand 1

#-------------------------------------------------------------------------------
#  {left top right bottom}
   set c $w.f3.c
   canvas $c -yscrollcommand "$w.f3.yscroll set" \
      -relief sunken -height 10c -width 21c
   scrollbar $w.f3.yscroll -relief sunken -command "$c yview"
   pack $w.f3.yscroll -side right -fill y
   pack $c -expand 1 -fill both

   pack  $w.f1 $w.f2 $w.f3 $w.f4 -side top -fill x
   
   ConfigColorText $w
   $w.f1 configure -background grey85

   update idletasks
   wm minsize .graph [winfo width .graph] [winfo height .graph] 

   GraphDraw $c
   TextWrite .graph.f2.text $helptext
   set drag_id 0
   tkwait window $w
}
