proc GraphPlace {c x y} {
   global xpos ypos drag_id oldxpos oldypos cirdia recyspc
   global pd fr_host fr_lfile fr_rfile fr_color moveitem

   set dist $cirdia
   set place_id {}
   set notplaced 1

   if {$drag_id} {
      set id $drag_id

#  where the file is placed
      $c addtag place_here overlapping \
         [expr [$c canvasx $x]-$dist] [expr [$c canvasy $y]-$dist] \
         [expr [$c canvasx $x]+$dist] [expr [$c canvasy $y]+$dist]
      set place_id [$c find withtag place_here]
      set notplaced 1

#  where the object is to be placed
      set host_tags [lsort -integer [$c find withtag tag_host]]
      foreach item $place_id {
         set to_host [lsearch $host_tags $item]

#  found host to add file to
         if {$to_host >= 0 && $to_host != $fr_host} {
            IncrUndo

#  add file to to_host
            set gr(files) [lindex $pd(files) $to_host]
            set gr(fslct) [lindex $pd(fslct) $to_host]
            lappend gr(files) [lindex [lindex $pd(files) $fr_host] $fr_lfile]
            lappend gr(files) [lindex [lindex $pd(files) $fr_host] $fr_rfile]
            set fr_file [lindex [lindex $pd(files) $fr_host] $fr_lfile]
            lappend gr(fslct) [lindex [lindex $pd(fslct) $fr_host] $fr_lfile]
            lappend gr(fslct) [lindex [lindex $pd(fslct) $fr_host] $fr_rfile]
	    set pd(files) [lreplace $pd(files) $to_host $to_host $gr(files)]
	    set pd(fslct) [lreplace $pd(fslct) $to_host $to_host $gr(fslct)]

#  delete file from fr_host
            set gr(files) [lindex $pd(files) $fr_host]
            set gr(fslct) [lindex $pd(fslct) $fr_host]
	    FileDelete $gr(files) $gr(fslct) $fr_host $fr_lfile $fr_rfile

            TextWrite .graph.f2.text \
"Moved file: $fr_file
From host: [lindex $pd(hosts) $fr_host]
To host: [lindex $pd(hosts) $to_host]"
            GraphUpdate
            FilesListboxWrite
            UpdateButtons
            PadeButtons
            set notplaced 0
         }
      }

#  file not moved
      if {$notplaced} {
#	 TextWrite .graph.f2.text \
#"File not moved.
#When dragging a file to a new host, the cursor must be placed in the circle of the new host."

#  put it back
	 set movex [expr $oldxpos-$xpos]
	 set movey [expr $oldypos-$ypos]
	 set i 0
	 foreach item $moveitem {
	    incr i
	    if {$i == 1} {$c itemconfigure $item -fill $fr_color}
	    $c move $item $movex $movey
	 }
      }

#  untag
      $c dtag $place_id place_here
      set drag_id 0
   }
}
