proc GraphDraw {c} {
   global viewtop ntcol ntrow cirdia recyspc hostfile pd
   global nundo cc clicktype1 nclick drag

   set cc $c
   
   set cy {}
   set cx {}
   set ytop -2
   set xleft 0.25
   set txscale [expr 3./$ntcol]
   set tyscale [expr 16./$ntrow]
   set deltax [expr 6.8*$txscale]
   DoLoop i 1 $ntcol {
      lappend cy $ytop
      lappend cx $xleft
      set xleft [expr $xleft+$deltax]
   }
    
   set y [MinList $cy]
   set ymax $y
   set row 0

   set colhst(1) "red"
   set colhst(2) "green4"
   set colhst(3) "blue"
   set colfil(1) "yellow"
   set colfil(2) "cyan"
   set colfil(3) "violet"
   set colout "black"
   set ncolor 0

   if {[winfo screenwidth .] >= 1280} {
      set ptszlarge {15}
      set ptszsmall {10}
   } else {
      set ptszlarge {14}
      set ptszsmall {10}
   }
   if {$ntcol < 10} {
      set ptsz $ptszlarge
      set nfchar 18
   } else {
      set ptsz $ptszsmall
      set nfchar 27
   }
   if {$ntrow > 30 && $ptsz == $ptszlarge} {
      set ptsz $ptszsmall
      set nfchar 27
   }
   if {[winfo screenwidth .] < 1280} {
      if {$nfchar==27} {set nfchar 25}
      if {$nfchar==18} {set nfchar 19}
   }

   set linwid 2
   set ffont -*-fixed-medium-r-normal--$ptsz-*-*-*-*-*
      
   set cirdia [expr 1.25*$txscale]
   set recwid [expr 4.4*$txscale]
   set recxspc [expr 0.3*$txscale]

   set recyspc [expr 0.64*$tyscale]
   set rechgt [expr $recyspc*0.75]
   
   .graph config -cursor {watch red white}

#  y is the y position of the item to be added to the tree
#  hosts are placed at x position -10c.  Files are at -7c and dependencies
#  are at -4c.
#  This includes text, arrows, and shapes. 

   DoLoop i 0 [expr [llength $pd(hosts)]-1] {
      set row [MinList $cy]
      set y [lindex $cy $row]
      set x [lindex $cx $row]
      if {$y != $ytop} {
         set yinc [expr 3.*$recyspc]
         if {$yinc < $cirdia} {set yinc [expr $cirdia*1.5]}
         set y [expr $y+$yinc]
      } else {
         set y [expr $y+2.75]
      }
      incr ncolor
      if {$ncolor > 3} {set ncolor 1}

#  draw host circle
      set y1 [expr $y+$cirdia]
      $c create oval ${x}c ${y}c [expr $x+$cirdia]c ${y1}c \
         -outline $colout -fill $colhst($ncolor) -tags tag_host -width $linwid
      if {$y1 > $ymax} {set ymax $y1}

#  put hostname near the circle
      set hoststr [lindex $pd(hosts) $i]
      set nchar [expr int($nfchar*$txscale*1.5)]
      set strlen [string length $hoststr]
      if {$strlen > $nchar} {
         set hoststr "[string range $hoststr 0 [expr $nchar-2]]>" 
      }
      $c create text [expr $x]c [expr $y-(0.35*$tyscale)]c \
	 -anchor w -text $hoststr -font $ffont -fill $colhst($ncolor)

#  draw line off right side of circle
      set y2 [expr $cirdia/2. + $y]
      set x2 [expr $x+$cirdia]
      $c create line ${x2}c ${y2}c [expr $x2+$recxspc]c ${y2}c -width $linwid

      set grdfiles [lindex $pd(files) $i]

#  draw files
      DoLoop j 0 [expr ([llength $grdfiles]/2)-1] {

#  don't increment y for the first file
         if {$j} {set y [expr $y+$recyspc]}  

#  draw file rectangle
         set y3 [expr $y+$recyspc]
         set x3 [expr $x+$cirdia+($recxspc*2.)]
         $c create rect ${x3}c [expr ${y3}-$rechgt]c [expr $x3+$recwid]c \
            ${y3}c -outline $colout -fill $colfil($ncolor) -width $linwid \
            -tags tag_file
	 if {$y3 > $ymax} {set ymax $y3}

#  get filename
         set y4 [expr $y3-($rechgt/2.)]
         set filestr [file tail [lindex $grdfiles [expr $j*2]]] 

#  append > if filename too long, length depends on font and width of rectangle
         set nchar [expr int($nfchar*$txscale)]
         set strlen [string length $filestr]
         if {$strlen > $nchar} {
            set filestr "[string range $filestr 0 [expr $nchar-2]]>" 
         }

#  draw filename in the rectangle
         $c create text [expr $x3+.03]c [expr $y4-.04]c \
            -anchor w -text $filestr -font $ffont

#  draw lines and an arrow between the file and its host
         set x4 [expr $x2+$recxspc]
         $c create line ${x4}c ${y4}c ${x3}c ${y4}c -width $linwid
         $c create line ${x4}c ${y2}c ${x4}c ${y4}c -width $linwid

      } 
      set cy [lreplace $cy $row $row $y]
#      update idletasks
   }

#  resize the scroll region so the scrollbar is the right size
   set sclreg {0c 0c 21c}
   lappend sclreg [expr $ymax+$cirdia]c
   $c configure -scrollregion $sclreg 

   GraphButtons

   .graph config -cursor {arrow red white}
   update idletasks

#  set the view to the top of the canvas
   if {$viewtop == 0} {$c yview moveto 0}
   incr viewtop

#  double-1 : edit file
   $c bind all <Double-1> {
      set addtype none
      GraphClick $cc %x %y -14
   }

#  single-1
   bind $c <1> {
      GraphClick $cc %x %y $clicktype1
      if {$clicktype1 != -4 || $nclick != 1} {set clicktype1 0}
   }

#  drag file
   bind $c <B1-Motion> "$c scan mark %x %y
	        	GraphDrag $c %x %y"

#  place file
   bind $c <ButtonRelease-1> "GraphPlace $c %x %y"

   bind $c <Control-Button-1> "$c scan mark %x %y"
   bind $c <Control-B1-Motion> "$c scan dragto 0 %y"
}

################################################################################

proc GraphButtons {} {
   global pd nundo
   if {[winfo exists .graph]} {
      if {$pd(hosts) == ""} {
	 .graph.f1.hosts.menu entryconfigure 3 -state disabled
	 .graph.f1.hosts.menu entryconfigure 4 -state disabled
	 .graph.f1.hosts.menu entryconfigure 5 -state disabled
	 .graph.f1.files configure -state disabled
	 .graph.f1.sort configure -state disabled
	 if {[winfo exists .addfil]} {destroy .addfil}
	 if {[winfo exists .addfiles]} {destroy .addfiles}
      } else {
	 .graph.f1.hosts.menu entryconfigure 3 -state normal
	 .graph.f1.hosts.menu entryconfigure 4 -state normal
	 .graph.f1.hosts.menu entryconfigure 5 -state normal
	 .graph.f1.files configure -state normal
	 .graph.f1.sort configure -state normal
	 if {[lindex $pd(files) 0] != ""} {
	    .graph.f1.files.menu entryconfigure 3 -state normal
	    .graph.f1.files.menu entryconfigure 4 -state normal
	    .graph.f1.files.menu entryconfigure 5 -state normal
	    .graph.f1.files.menu entryconfigure 6 -state normal
	 } else {   
	    .graph.f1.files.menu entryconfigure 3 -state disabled
	    .graph.f1.files.menu entryconfigure 4 -state disabled
	    .graph.f1.files.menu entryconfigure 5 -state disabled
	    .graph.f1.files.menu entryconfigure 6 -state disabled
	 }
      }
      if {$nundo > 1} {
	 .graph.f1.undo configure -state normal
      } else {
	 .graph.f1.undo configure -state disabled
      }
   }
}

################################################################################

proc GraphRedraw {} {
   global ntcol ntrow

   TextWrite .graph.f2.text "Redrawing with $ntcol columns and $ntrow rows"
   update idletasks
   .graph.f3.c delete all
   GraphDraw .graph.f3.c
}

################################################################################

proc GraphUpdate { } {
   global pd pdsave nundo
   if {[winfo exists .graph]} {
      set update 0
      if {$nundo >= 0} {
	 foreach item {hosts files} {
	    if {$update == 0} {
               if {[string compare $pdsave($item,$nundo) $pd($item)] != 0 || \
                  ($pdsave($item,$nundo) == "" && $pd($item) == "")} {
                  set update 1
               }
	    }
	 }
      } else {
         set update 1
      }
      if {$update} {
	 .graph.f3.c delete all
	 GraphDraw .graph.f3.c
      }
   }
}
