proc GraphDrag {c x y} {
   global xpos ypos drag_id oldxpos oldypos moveitem 
   global pd fr_host fr_lfile fr_rfile fr_color

#  move only a file
   if {$drag_id == 0} {
      set curr_tag [$c find withtag current]
      set file_tags [lsort -integer [$c find withtag tag_file]]
      set gr_file [lsearch $file_tags $curr_tag]
      set gr_filetext [lsearch $file_tags [expr $curr_tag-1]]

#  a file is selected, moveitem is the file rectangle and text
      if {[llength $curr_tag] && ($gr_file >= 0 || $gr_filetext >=0)} {
	 set drag_id $curr_tag
	 set moveitem ""
	 if {$gr_file < 0} {
            lappend moveitem [expr $curr_tag-1]
            lappend moveitem $curr_tag
	 } elseif {$gr_filetext < 0} {
            lappend moveitem $curr_tag
            lappend moveitem [expr $curr_tag+1]
	 }

#  move file, make rectangle white and raise
	 set x [$c canvasx $x]
	 set y [$c canvasy $y]
	 set i 0
	 foreach item $moveitem {
            incr i
            $c move $item [expr $x-$xpos] [expr $y-$ypos]
            if {$i == 1} {
               set fr_color [lindex [lindex [$c itemconfigure $item] 0] 4]
               $c itemconfigure $item -fill white
            }
            $c raise $item
	 }
	 set xpos $x
	 set ypos $y

#  compute indices of from host and file
	 set nfile -1
	 set lnfile -1
	 if {$gr_file == -1 && $gr_filetext >= 0} {set gr_file $gr_filetext}
	 set fr_host_notset 1
	 DoLoop i 0 [expr [llength $pd(hosts)]-1] {
            set nfile [expr ([llength [lindex $pd(files) $i]]/2)+$nfile]
            if {$gr_file <= $nfile && $fr_host_notset} {
               set fr_host $i
               set fr_host_notset 0
               set fr_fileind [expr $gr_file-$lnfile-1]
            }
            set lnfile $nfile
	 }
	 set fr_lfile [expr $fr_fileind*2]
	 set fr_rfile [expr $fr_lfile+1]
      }

#  file is already selected, just update the position
   } elseif {$drag_id > 0} {
      set x [$c canvasx $x]
      set y [$c canvasy $y]
      foreach item $moveitem {
         $c move $item [expr $x-$xpos] [expr $y-$ypos]
      }
      set xpos $x
      set ypos $y
   }   
}
