proc GraphClick {c x y clicktype} {
   global xpos ypos drag_id oldxpos oldypos addtype entry1 entry2 prefs
   global pd pdname cc clicktype1 nclick
   global cffh host_from

   set cc $c
   set drag_id 0
   set xpos [$c canvasx $x]
   set ypos [$c canvasy $y]
   set oldxpos $xpos
   set oldypos $ypos
   set delhost ""
   set delfile ""
   if {!$clicktype} {set addtype none}

   TextWrite .graph.f2.text ""

   set curr_tag  [$c find withtag current]
   set host_tags [lsort -integer [$c find withtag tag_host]]
   set file_tags [lsort -integer [$c find withtag tag_file]]
   set gr_host [lsearch $host_tags $curr_tag]
   set gr_file [lsearch $file_tags $curr_tag]
   set gr_filetext [lsearch $file_tags [expr $curr_tag-1]]
   if {$gr_file == -1 && $gr_filetext >= 0} {set gr_file $gr_filetext}

#-------------------------------------------------------------------------------
#  if a file is to be added or the clicktype is for a host and
#  a host has been clicked on

   if {(($addtype == "file") || ($clicktype <= 0 && $clicktype >= -10)) && \
      $gr_host >= 0} {
      set redraw 0

#-------------------------------------------------------------------------------
#  ADD FILE TO HOST

      if {$clicktype > 0} {
         IncrUndo
         set gr(files) [lindex $pd(files) $gr_host]
         set gr(fslct) [lindex $pd(fslct) $gr_host]
	 FileAdd $gr(files) $gr(fslct) $gr_host

#  print some messages
         TextWrite .graph.f2.text \
"Added file to host: [lindex $pd(hosts) $gr_host]
LOCAL FILE: $entry1
REMOTE FILE: $entry2"

         FilesListboxWrite
         UpdateButtons
         set redraw 1            
      }

#-------------------------------------------------------------------------------
#  HOST INFORMATION
      if {$clicktype == 0} {
         TextWrite .graph.f2.text \
"HOST: [lindex $pd(hosts) $gr_host]
HOST COMMANDS: [lindex $pd(cmnds) $gr_host]"
      }

#-------------------------------------------------------------------------------
#  DELETE HOST
      if {$clicktype == -1} {
	 set pick 0
         if {$prefs(CONFIRM)=="On"} {set pick [Dialog .d {PADE Question} \
            {Delete the host and all its commands and files?} \
            questhead 0 {Yes} {No}]}
         if {$pick==0} {
            IncrUndo
            set host_del [lindex $pd(hosts) $gr_host]
            foreach item $pdname {
               set pd($item) [lreplace $pd($item) $gr_host $gr_host]
            }
            TextWrite .graph.f2.text \
               "Deleted host and its commands and files: $host_del"
            HostListboxWrite
            FilesListboxWrite
            UpdateButtons
            set redraw 1
         }
      }

#-------------------------------------------------------------------------------
#  COPY HOST
      if {$clicktype == -2} {
         IncrUndo
         foreach item $pdname {
            lappend pd($item) [lindex $pd($item) $gr_host]
         }
         TextWrite .graph.f2.text \
            "Copied host and its files: [lindex $pd(hosts) $gr_host]"
         HostListboxWrite
         UpdateButtons            
         set redraw 1            
      }

#-------------------------------------------------------------------------------
#  MODIFY HOST
      if {$clicktype == -3} {
         AddHost [lindex $pd(hosts) $gr_host] \
            [lindex $pd(cmnds) $gr_host] "MOD" $gr_host .graph
      }

#-------------------------------------------------------------------------------
#  COPY FROM HOST
      if {$clicktype == -4} {
         incr nclick
         if {$nclick==1} {
            set host_from [lindex $pd(hosts) $gr_host]
 	    set cffh(files) [lindex $pd(files) $gr_host]
            set cffh(fslct) [lindex $pd(fslct) $gr_host]
            TextWrite .graph.f2.text \
               "Click on Host (circle) for Files to be Copied TO"
         } elseif {$nclick==2} {
            set gr(files) [lindex $pd(files) $gr_host]
            set gr(fslct) [lindex $pd(fslct) $gr_host]
            FileCopyFromHost $gr(files) $gr(fslct) $gr_host
	    TextWrite .graph.f2.text \
	       "[expr [llength $cffh(files)]/2] files copied from $host_from to $cffh(host)"
            set redraw 1
            FilesListboxWrite
         }
      }

#-------------------------------------------------------------------------------
#  GLOBAL REPLACE
      if {$clicktype == -5} {
	 if {$entry1!=""} {
            set gr(files) [FileReplace [lindex $pd(files) $gr_host]]
            set pd(files) [lreplace $pd(files) $gr_host $gr_host $gr(files)] 
            set redraw 1
	    FilesListboxWrite
	 }
      }

#-------------------------------------------------------------------------------
#  REDRAW 
      if {$redraw} {GraphUpdate}

#  missed adding file on host
   } elseif {$clicktype==1 && $gr_host < 0} {
      TextWrite .graph.f2.text \
"File not added to host.
To add a file to a host; after picking Apply, click on the host circle."

#  missed copying, modifying or deleting host
   } elseif {$clicktype <= -1 && $clicktype >= -4 && $gr_host < 0} {
      incr nclick
      TextWrite .graph.f2.text \
"No action taken.
To Copy, Modify or Delete a host; pick the menu item, then click on a host circle."
   }


#-------------------------------------------------------------------------------
#  if a file has been clicked on, figure out which host it came from
#  and get the lists for that host

   if {$gr_file >= 0 && ($clicktype <= -10 || $clicktype == 0)} {
      set redraw 0
      set nfile -1
      set lnfile -1
      set gr_host_notset 1
      DoLoop i 0 [expr [llength $pd(hosts)]-1] {
         set nfile [expr ([llength [lindex $pd(files) $i]]/2)+$nfile]
         if {$gr_file <= $nfile && $gr_host_notset} {
            set gr_host $i
            set gr_host_notset 0
            set gr_fileind [expr $gr_file-$lnfile-1]
         }
         set lnfile $nfile
      }
      set gr_lfile [expr $gr_fileind*2]
      set gr_rfile [expr $gr_lfile+1]
      set gr(files) [lindex $pd(files) $gr_host]
      set gr(fslct) [lindex $pd(fslct) $gr_host]

#-------------------------------------------------------------------------------
#  FILE INFORMATION
      if {$clicktype == 0} {
         TextWrite .graph.f2.text \
"HOST: [lindex $pd(hosts) $gr_host]
LOCAL FILE: [lindex $gr(files) $gr_lfile]
REMOTE FILE: [lindex $gr(files) $gr_rfile]"
      }

#-------------------------------------------------------------------------------
#  DELETE FILE
      if {$clicktype == -11} {
         IncrUndo
	 FileDelete $gr(files) $gr(fslct) $gr_host $gr_lfile $gr_rfile
         TextWrite .graph.f2.text "Deleted file: [lindex $gr(files) $gr_lfile]"
         set redraw 1         
      }

#-------------------------------------------------------------------------------
#  COPY FILE
      if {$clicktype == -12} {
         FileCopy $gr(files) $gr(fslct) $gr_host $gr_lfile $gr_rfile
         TextWrite .graph.f2.text "On Host: [lindex $pd(hosts) $gr_host]
Copied file: [lindex $gr(files) $gr_lfile]"
         set redraw 1            
      }

#-------------------------------------------------------------------------------
#  MODIFY FILE
      if {$clicktype == -13} {
         TextWrite .graph.f2.text \
            "Modifying file on Host: [lindex $pd(hosts) $gr_host]"
	 set lfile [lindex $gr(files) $gr_lfile]
	 set rfile [lindex $gr(files) $gr_rfile]
         AddFile $lfile $rfile "MOD" "" ".graph"
         if {$entry1 != ""} {
            IncrUndo
            set gr(files) [lreplace $gr(files) $gr_lfile $gr_rfile $entry1 $entry2]
	    set pd(files) [lreplace $pd(files) $gr_host $gr_host $gr(files)]
            TextWrite .graph.f2.text \
"Modified file on Host: [lindex $pd(hosts) $gr_host]
LOCAL FILE: $entry1\nREMOTE FILE: $entry2"
            set redraw 1            
         }
      }

#-------------------------------------------------------------------------------
#  EDIT FILE
      if {$clicktype == -14} {
         EditFile [lindex $gr(files) $gr_lfile]
         TextWrite .graph.f2.text \
            "Edited file: [lindex $gr(files) $gr_lfile]"
      }

#-------------------------------------------------------------------------------
#  REDRAW
      if {$redraw} {
	 FilesListboxWrite
	 UpdateButtons
	 GraphUpdate
      }

#  missed copying, modifying or deleting host
   } elseif {$clicktype <= -11 && $clicktype >= -13 && \
      [lsearch $file_tags $curr_tag] < 0} {
         TextWrite .graph.f2.text \
"No action taken.
To Copy, Modify or Delete a file; pick the menu item, then click on a file rectangle."
   }
}
