################################################################################

proc OpenPadeFile {open_mode} {
   global padefile ntcol ntrow prefs fkeys
   global pd pdopen pdname
   
   TextWrite .f5.text ""
   if {[PdChanged]} {
      set pick [Dialog .d {PADE Question} \
         {Save current work before Opening a new file?} \
         questhead 0 {Yes} {No} {Cancel}]
      if {$pick==0} {
         SavePadeFile 0
      } elseif {$pick==2} {
         return
      }
   }
   set init 1

   if {$open_mode} {set padefile [fileselect "Open PADE file" $prefs(FILE_PATH)/]}

   if {[file isdirectory $padefile] || ![file exists $padefile]} {
      if {$padefile!=""} {TextWrite .f5.text "$padefile  IS NOT A FILE"} 
      set padefile ""
   }

   if {$padefile!=""} {
      . config -cursor {watch red white}
      update idletasks
      set f_pade   [open "$padefile" r]
      set notdone [gets $f_pade line]
      while {$notdone >= 0} {

#  add a host to the list
         if {[string first $fkeys(host) $line] == 0} {
            if {$init} {
	       foreach item $pdname {
		  set pd($item) ""
	       }
               set init 0
            }
            
#  get host string, check if select flag is set            
            set htemp [string trim [string trimleft $line $fkeys(host)] " "]
            lappend pd(hosts) [lindex $htemp 0]
            if {[llength $htemp] > 1} {
               lappend pd(hslct) [lindex $htemp 1]
            } else {
               lappend pd(hslct) 1
            }
            set notdone [gets $f_pade line]

#  add compile command to the list
            lappend pd(cmnds) [string trim [string trimleft $line $fkeys(cmnd)] " "]
            set notdone [gets $f_pade line]

            set tpd(files) {}
            set tpd(fslct) {}
            while {[string first $fkeys(lfile) $line] == 0} {

#  add a file to the list of files for the current host
               set lfile [string trimleft $line $fkeys(lfile)]
               if {$lfile==""} {set lfile "{}"}
               lappend tpd(files) [lindex $lfile 0]
               if {[llength $lfile] > 1} {
                  lappend tpd(fslct) [lindex $lfile 1]
               } else {
                  lappend tpd(fslct) 1
               }

#  add the remote file name
               gets $f_pade line
               set rfile [string trim [string trimleft $line $fkeys(rfile)] " "]
               if {$rfile==""} {set rfile "{}"}
               lappend tpd(files) $rfile
               lappend tpd(fslct) 0
               set notdone [gets $f_pade line]
            }

#  add the files to the list
            lappend pd(files) $tpd(files)
            lappend pd(fslct) $tpd(fslct)

          } else {
            set notdone [gets $f_pade line]
         }
      }
      . config -cursor {arrow red white}
   }

   if {$padefile!=""} {
      if {$init} {
         TextWrite .f5.text "$padefile  IS NOT A VALID PADE FILE"
      } else {
         set colval {30 25 20 15 10 8 6 4 2}
         set ntcol [lindex $colval 0]
	 foreach item $colval {
	    if {[llength $pd(hosts)] <= $item} {set ntcol $item}  
	 }
	 if {$ntcol <= 8} {
	    set ntrow 16
	 } else {
	    set ntrow 24
	 }
	 TextWrite .f5.text "Opened: [file tail $padefile]"
	 foreach item $pdname {
	    set pdopen($item) $pd($item)
	 }
      }
   }
}

################################################################################

proc SavePadeFile {save_mode} {
   global padefile fkeys
   global pdopen version pd prefs pdname
   
   if {([PdChanged] || $save_mode) && $pd(hosts) != ""} {
      TextWrite .f5.text ""
      set fstr  "$fkeys(lfile)"
      set rfstr "$fkeys(rfile)"

      if {$save_mode || (!$save_mode && $padefile=="")} {
	 set padefile [fileselect "Save PADE file" $prefs(FILE_PATH)/ 0]
	 if {[file isdirectory $padefile]} {
	    TextWrite .f5.text "$padefile  IS NOT A FILE" 
            set padefile ""
	 }
      }

      if {$padefile!=""} {
         if {$save_mode} { 
            if {[file exists $padefile]} {
               set pick [Dialog .d {PADE Question} \
        	  "Overwrite  $padefile  ?" questhead 0 {Overwrite} {Cancel}]
               if {$pick==1} return
            }
         }
         . config -cursor {watch red white}
         update idletasks

#  PADE file
         set f_pade [open "$padefile" w]
         set indhost 0
         foreach shost $pd(hosts) {

#  write host and commands
            puts $f_pade "$fkeys(host) $shost [lindex $pd(hslct) $indhost]"
            puts $f_pade "$fkeys(cmnd) [lindex $pd(cmnds) $indhost]"
            set writehost $shost

#  write files
            set indfile 0
            foreach sfile [lindex $pd(files) $indhost] {
               if {[expr $indfile%2] == 0} {
                  puts $f_pade "$fkeys(lfile) $sfile\
                     [lindex [lindex $pd(fslct) $indhost] $indfile]"
               } else {
                  puts $f_pade "$fkeys(rfile) $sfile"
               }
               incr indfile
            }
            incr indhost
         }
         close $f_pade

         . config -cursor {arrow red white}
         update idletasks

	 TextWrite .f5.text "Saved: [file tail $padefile]" 

	 foreach item $pdname {
	    set pdopen($item) $pd($item)
	 }
      }
   }
}

################################################################################

proc SavePvmmakeFile {infile} {
   global pvmmakefile prefs
   global version pd dp
   
   set pvmmakefile $infile
   
   if {$pd(hosts)!=""} {
      TextWrite .f5.text ""

      if {$infile == ""} {
	 set pvmmakefile [fileselect "Save PVMmake config file" $prefs(FILE_PATH)/ 0]
	 if {[file isdirectory $pvmmakefile]} {
	    TextWrite .f5.text "$pvmmakefile  IS NOT A FILE" 
            set pvmmakefile ""
	 }
      }

      if {$pvmmakefile != ""} {
         set pick 0
         if {[file exists $pvmmakefile] && $infile == ""} {
            set pick [Dialog .d {PADE Question} \
               "Overwrite  $pvmmakefile  ?" questhead 0 {Overwrite} {Cancel}]
            if {$pick==1} return
         }
         . config -cursor {watch red white}
         update idletasks

#  convert pd to dp data
         Pd2Dp

#  write pvmmake config file
         set f_pvmmake [open "$pvmmakefile" w]
         set date [exec date]
         puts $f_pvmmake "#  PVMmake configuration file"
         puts $f_pvmmake "#  Written by PADE ($version) on $date"

         DoLoop i 0 [expr [llength $dp(lfiles)]-1] {
            set lfile [lindex $dp(lfiles) $i]
            set hrfile [lindex $dp(hrfile) $i]
            set hrslct [lindex $dp(hrslct) $i]
            set lfslct 0
            DoLoop j 0 [expr [llength $hrslct]-1] {
               if {$j%2 == 0} {set lfslct [expr $lfslct + [lindex $hrslct $j]]}
            }
            if {$lfslct > 0} {
               puts $f_pvmmake \
        	  "\n#--------------------\n#  broadcast FILE $lfile\n"
               puts $f_pvmmake $lfile

               set hrfile [lindex $dp(hrfile) $i]
               set hrslct [lindex $dp(hrslct) $i]
               DoLoop j 0 [expr [llength $hrfile]-1] {
        	  if {$j%2 == 0} {
                     if {[lindex $hrslct $j] == 1} {set line [lindex $hrfile $j]}
        	  } else {
                     if {[lindex $hrslct [expr $j-1]] == 1} {
                	lappend line [lindex $hrfile $j]
                	puts $f_pvmmake $line
                     } 
        	  } 
               }
            }
         }

         DoLoop i 0 [expr [llength $pd(hosts)-1]] {
            if {[lindex $pd(cmnds) $i] != ""  && [lindex $pd(hslct) $i] == 1} {
               puts $f_pvmmake "\n#--------------------\n#  broadcast COMMANDS to [lindex $pd(hosts) $i]\n"
               puts $f_pvmmake \
        	  "@ [lindex $pd(hosts) $i] [lindex $pd(cmnds) $i] +errors"
            }
         }
            
         close $f_pvmmake

         . config -cursor {arrow red white}
         update idletasks

	 TextWrite .f5.text \
            "Saved: [file tail $pvmmakefile]" 
      }
   }
}


################################################################################

proc Pd2Dp { } {
   global pd dp

#  reorder from host-file (variable pd) to file-host (variable dp)

   set dp(lfiles) {}
   set dp(hrfile) {}
   set dp(hrslct) {}
   
   set indhost 0
   foreach shost $pd(hosts) {

      set ro(files) [lindex $pd(files) $indhost]
      set indfile 0
      foreach sfile $ro(files) {

#  local file
	 if {[expr $indfile%2] == 0} {
	    TextWrite .f5.text \
	       "Checking for unique local files on host: $shost [file tail $sfile]"
	    update idletasks
            set newfile 1
            set i 0
            DoLoop i 0 [expr [llength $dp(lfiles)]-1] {
               if {$newfile} {
        	  if {[string match $sfile [lindex $dp(lfiles) $i]]} {
        	     set newfile 0
        	     set indlfile $i
        	  }
               }
            }
            if {$newfile} {
               lappend dp(lfiles) $sfile
               set indlfile [expr [llength $dp(lfiles)]-1]
               lappend dp(hrfile) {}
               lappend dp(hrslct) {}
            }

#  remote file
	 } else {
            set ro(hrfile) [lindex $dp(hrfile) $indlfile]
            lappend ro(hrfile) $shost $sfile
            set dp(hrfile) [lreplace $dp(hrfile) $indlfile $indlfile $ro(hrfile)]

            set ro(hrslct) [lindex $dp(hrslct) $indlfile]
            lappend ro(hrslct) [lindex [lindex $pd(fslct) $indhost] [expr $indfile-1]] 0
            set dp(hrslct) [lreplace $dp(hrslct) $indlfile $indlfile $ro(hrslct)]
	 }
         incr indfile
      }
      incr indhost
   }
}

################################################################################

proc SavePrefs { } {
   global penv prefs napp apps
   
   if {$penv(HOME)!=""} {
      set preffile $penv(HOME)/.paderc
   } else {
      set preffile [fileselect "Open .paderc file in home dir" ".paderc"]
   }
   set f_pref [open "$preffile" w]
   foreach item [lsort [array names prefs]] {
      if {[string range $item 0 2] != "APP"} {
         puts $f_pref "$item $prefs($item)"
      }
   }
   DoLoop i 1 $napp {
      puts $f_pref "APP$i [lindex $apps [expr $i-1]]"
   }
   close $f_pref
}

################################################################################

proc SelSavePvmmakeFile {{w .selsav}} {
   global env pd dp prefs since fonts colors ssfslct
   
   catch {destroy $w}
   toplevel $w
   wm title $w "PADE Set Files and Commands to Save"
   wm iconname $w "Set"
   wm minsize $w 1 1
   wm maxsize $w 1280 1024
   wm geometry $w +170+218
   
   wm iconbitmap $w @$env(PADE_ROOT)/pade/pade_icon.xbm
   $w config -cursor {arrow red white}
   
#  since is the time since the last PVMmake
   set since 0
   if {$prefs(LAST_PVMMAKE) > 0} {
      set since [expr ([TimeStamp] - $prefs(LAST_PVMMAKE))/3600]
   }

#  initialize sshslct and ssfslct
   set i 0
   foreach item $pd(hosts) {
      set sshslct($i) [lindex $pd(hslct) $i]
      set j 0
      foreach jtem [lindex $pd(files) $i] {
         set ssfslct($i,$j) [lindex [lindex $pd(fslct) $i] $j]
         incr j
      }
      incr i
   }

   frame $w.f2 -bd 1 -relief raised 
   frame $w.f2.1
   frame $w.f2.2
   frame $w.f2.3
   frame $w.f2.4
   frame $w.f3 -bd 1 -relief raised
   frame $w.f3.1
   frame $w.f3.2
   frame $w.f3.3
   frame $w.f3.4
   frame $w.f4 -bd 1 -relief raised

#------------------------------------------------------------------------------

#  LEFT SIDE

#  label at top
   label $w.f2.1.msg -text "Remote Hosts"
   pack  $w.f2.1.msg -expand 1 -fill both -pady 3m

#  canvas to hold buttons
   canvas $w.f2.2.c -scrollregion {0c 0c 10.5c 10.5c} \
      -yscrollcommand [list $w.f2.2.yscroll set] \
      -relief sunken -bd 2 -height 10.5c -width 10.5c
   scrollbar $w.f2.2.yscroll -relief sunken -command [list $w.f2.2.c yview]
   pack $w.f2.2.yscroll -side right -fill y
   pack $w.f2.2.c -expand 1 -fill both

#  labels in canvas
   set ly 1.
   $w.f2.2.c create text 0.5c [expr $ly-0.25]c -anchor w \
      -text "Send\nCmds" -font $fonts(FONT_NORM)
   $w.f2.2.c create text 2.0c [expr $ly-0.25]c -anchor w \
      -text "Set Files\nTo Send" -font $fonts(FONT_NORM)

#  radiobuttons to send files to all hosts
   set allfilesel -1
   label $w.f2.4.msg -text "Send Files (All Hosts):"

   radiobutton $w.f2.4.a -text "All" -variable allfilesel \
      -value 1 -relief flat -command {
      set i 0
      foreach item $pd(hosts) {
	 set j 0
	 foreach jtem [lindex $pd(files) $i] {
            set ssfslct($i,$j) $allfilesel
            incr j
	 }
	 incr i
      }
   }
   $w.f2.4.a deselect

   radiobutton $w.f2.4.b -text "None" -variable allfilesel \
      -value 0 -relief flat -command {
      set i 0
      foreach item $pd(hosts) {
	 set j 0
	 foreach jtem [lindex $pd(files) $i] {
            set ssfslct($i,$j) $allfilesel
            incr j
	 }
	 incr i
      }
   }
   $w.f2.4.b deselect
   
   set lastpvmmake1 [expr ([TimeStamp] - $prefs(LAST_PVMMAKE))/3600]
   radiobutton $w.f2.4.c \
      -text "Files modified since last PVMmake ($lastpvmmake1 hrs)" \
      -variable allfilesel -value 3 -relief flat -command {
      .selsav config -cursor {watch red white}
      update idletasks
      set i 0
      foreach item $pd(hosts) {
         set ss(files) [lindex $pd(files) $i]
	 DoLoop k 0 [expr [llength $ss(files)]-1] {
            if {[expr $k%2 == 0]} {
               if {[file exists [lindex $ss(files) $k]]} {
        	  if {[file mtime [lindex $ss(files) $k]] > \
        	     $prefs(LAST_PVMMAKE)} {
        	     set ssfslct($i,$k) 1
        	  } else { 
        	     set ssfslct($i,$k) 0
        	  }
               }
            }
	 }
	 incr i
      }
      .selsav config -cursor {arrow red white}
   }
   $w.f2.4.c deselect

   pack  $w.f2.4.c -side bottom -pady 1m -ipadx 2m
   pack  $w.f2.4.msg $w.f2.4.a $w.f2.4.b -side left -pady 1m -ipadx 2m

   if {$pd(files) != "{}"} { 
      $w.f2.4.a configure -state normal
      $w.f2.4.b configure -state normal
      $w.f2.4.c configure -state normal
   } else {
      $w.f2.4.a configure -state disabled
      $w.f2.4.b configure -state disabled
      $w.f2.4.c configure -state disabled
   }

#  radiobuttons to send commands
   set cmndsel 0
   label $w.f2.3.msg -text "Send Cmds:"

   radiobutton $w.f2.3.a -text "All" -variable cmndsel \
      -value 1 -relief flat -command {
      DoLoop k 0 [expr [llength $pd(hosts)]-1] {set sshslct($k) 1}
   }
   $w.f2.3.a deselect

   radiobutton $w.f2.3.b -text "None" -variable cmndsel \
      -value 2 -relief flat -command {
      DoLoop k 0 [expr [llength $pd(hosts)]-1] {set sshslct($k) 0}
   }
   $w.f2.3.b deselect

   pack $w.f2.3.msg $w.f2.3.a $w.f2.3.b -side left -pady 3m -ipadx 2m

#------------------------------------------------------------------------------

#  RIGHT SIDE

#  label at top
   label $w.f3.1.msg -textvariable f31msg -text "Local files for Host:"
   pack  $w.f3.1.msg -expand 1 -fill both -pady 3m
   label $w.f3.3.msg -text "Send Files (This Host):"
   pack  $w.f3.3.msg -expand 1 -fill both -pady 3m

#  canvas to hold buttons
   canvas $w.f3.2.c -scrollregion {0c 0c 10.5c 10c} \
      -yscrollcommand [list $w.f3.2.yscroll set] \
      -relief sunken -bd 2 -height 10.5c -width 10.5c
   scrollbar $w.f3.2.yscroll -relief sunken -command [list $w.f3.2.c yview]
   pack $w.f3.2.yscroll -side right -fill y
   pack $w.f3.2.c -expand 1 -fill both
   
#  radiobuttons to send files
   set filesel 0

   radiobutton $w.f3.3.a -text "All" -variable filesel \
      -value 1 -relief flat -command {
      DoLoop k 0 [expr [llength $ss(files)]-1] {set ssfslct($lind,$k) 1}
   }
   $w.f3.3.a deselect

   radiobutton $w.f3.3.b -text "None" -variable filesel \
      -value 2 -relief flat -command {
      DoLoop k 0 [expr [llength $ss(files)]-1] {set ssfslct($lind,$k) 0}
   }
   $w.f3.3.b deselect

   set lastpvmmake1 [expr ([TimeStamp] - $prefs(LAST_PVMMAKE))/3600]
   radiobutton $w.f3.4.a \
      -text "Files modified since last PVMmake ($lastpvmmake1 hrs)" \
      -variable filesel -value 3 -relief flat -command {
      .selsav config -cursor {watch red white}
      update idletasks
      DoLoop k 0 [expr [llength $ss(files)]-1] {
         if {[expr $k%2 == 0]} {
            if {[file exists [lindex $ss(files) $k]]} {
               if {[file mtime [lindex $ss(files) $k]] > \
        	  $prefs(LAST_PVMMAKE)} {
        	  set ssfslct($lind,$k) 1
               } else { 
        	  set ssfslct($lind,$k) 0
               }
            }
         }
      }
      .selsav config -cursor {arrow red white}
   }
   $w.f3.4.a deselect

   pack $w.f3.3.msg $w.f3.3.a $w.f3.3.b -side left -pady 1m -ipadx 2m
   pack $w.f3.4.a -side left -pady 1m -ipadx 2m

   $w.f3.3.a configure -state disabled
   $w.f3.3.b configure -state disabled
   $w.f3.4.a configure -state disabled

#------------------------------------------------------------------------------

#  loop on hosts
   set i 0
   foreach item $pd(hosts) {
      set ly [expr $ly+0.57]

#  host name
      $w.f2.2.c create text 4.0c [expr $ly]c -anchor w -text $item \
         -font $fonts(FONT_NORM)

#  checkbutton to send command
      checkbutton $w.f2.2.c.y$i -variable sshslct($i) -relief flat \
         -font $fonts(FONT_NORM)
      $w.f2.2.c create window 1.2c [expr $ly]c -window $w.f2.2.c.y$i
      if {$sshslct($i)} {$w.f2.2.c.y$i select}

#  radiobutton controls files displayed in right canvas
      radiobutton $w.f2.2.c.f$i -variable lind -value $i -relief flat \
         -font $fonts(FONT_NORM) -command {

         .selsav config -cursor {watch red white}
         .selsav.f3.3.a deselect
         .selsav.f3.3.b deselect
         .selsav.f3.4.a deselect

         set f31msg "Local Files for Host:  [lindex $pd(hosts) $lind]"

         set ry 1.
         .selsav.f3.2.c delete all
         update idletasks

#  label for right canvas
	 .selsav.f3.2.c create text 0.5c [expr $ry-0.25]c -anchor w \
            -text "Send\nFile" -font $fonts(FONT_NORM)
	 .selsav.f3.2.c create text 8.5c [expr $ry-0.25]c -anchor w \
            -text "File Age\n(Hours)" -font $fonts(FONT_NORM)

#  loop on local files for selected host
         set ss(files) [lindex $pd(files) $lind]
         set j 0
         foreach jtem $ss(files) {
            if {[expr $j%2] == 0} {
               set ry [expr $ry+0.57]

#  file name
               .selsav.f3.2.c create text 2.0c [expr $ry]c -anchor w \
                  -text [file tail $jtem] -font $fonts(FONT_NORM)
#  file age
               if {[file exists $jtem]} {
        	  .selsav.f3.2.c create text 9.0c [expr $ry]c -anchor w \
                     -text [expr ([TimeStamp] - [file mtime $jtem])/3600] \
                     -font $fonts(FONT_NORM)
               }

#  checkbutton to send file
               set cbutton .selsav.f3.2.c.y$j
               if {[winfo exists $cbutton]} {destroy $cbutton} 
               checkbutton $cbutton -variable ssfslct($lind,$j) -relief flat \
        	  -font $fonts(FONT_NORM) -bg grey90
               .selsav.f3.2.c create window 1.2c [expr $ry]c -window $cbutton
            }
            incr j
         }

	 set sclreg {0c 0c 10.5c}
	 lappend sclreg [expr $ry+1.0]c
	 .selsav.f3.2.c configure -scrollregion $sclreg
	 if {$ss(files) != ""} { 
	    .selsav.f3.3.a configure -state normal
	    .selsav.f3.3.b configure -state normal
	    .selsav.f3.4.a configure -state normal
	 } else {
	    .selsav.f3.3.a configure -state disabled
	    .selsav.f3.3.b configure -state disabled
	    .selsav.f3.4.a configure -state disabled
         }
         .selsav config -cursor {arrow red white}
      }
      $w.f2.2.c.f$i deselect
      $w.f2.2.c create window 3.0c [expr $ly]c -window $w.f2.2.c.f$i
      incr i
   }

   set sclreg {0c 0c 10.5c}
   lappend sclreg [expr $ly+1.0]c
   $w.f2.2.c configure -scrollregion $sclreg 

   pack $w.f2.1 $w.f2.2 $w.f2.4 $w.f2.3 -side top -expand 1
   pack $w.f3.1 $w.f3.2 $w.f3.3 $w.f3.4 -side top -expand 1

#------------------------------------------------------------------------------

   button $w.f4.apply -text "Apply" -command {

   #  copy sshslct and ssfslct back to pd
      set i 0
      foreach item $pd(hosts) {
	 set pd(hslct) [lreplace $pd(hslct) $i $i $sshslct($i)]
	 set j 0
	 set pdfslct [lindex $pd(fslct) $i]
	 foreach jtem [lindex $pd(files) $i] {
            set pdfslct [lreplace $pdfslct $j $j $ssfslct($i,$j)]
            incr j
	 }
	 set pd(fslct) [lreplace $pd(fslct) $i $i $pdfslct]
	 incr i
      }
   }      
   button $w.f4.close -text "Close" -command {
      destroy .selsav
   }      
   pack $w.f4.apply $w.f4.close \
      -side left -expand 1 -padx 3m -pady 4m -ipadx 2m -ipady 1m
   ConfigColorText $w

#------------------------------------------------------------------------------

   pack  $w.f4 -side bottom -fill x
   pack  $w.f2 $w.f3 -side left -fill x -anchor n
   
   update idletasks
   wm minsize .selsav [winfo width .selsav] [winfo height .selsav]
   tkwait window $w
}
   
