################################################################################

proc FilesListboxWrite { } {
   global af_index pd af_oldhost af
   if {[winfo exists .addfiles]} {
      set af_host [.f4.l.listbox get $af_index]
      if {$af_host==$af_oldhost} {
	 set af_tmp(files) [lindex $pd(files) $af_index]      
	 .addfiles.f3.listbox delete 0 end
	 DoLoop i 0 [expr [llength $af_tmp(files)]-1] {
	    if {[expr $i%2] == 0} {
	       .addfiles.f3.listbox insert end [concat \
	          [lindex $af_tmp(files) $i] "-->" \
        	  [lindex $af_tmp(files) [expr $i+1]]]
	    }
	 }
	 .addfiles.f2.msg configure \
            -text "File list for host:   $af_host   (local --> remote)"
      } else {
         destroy .addfiles
         if {[winfo exists .addfil]} {destroy .addfil}
         update idletasks
      }
   }
}

################################################################################

proc FilesButtons { } {
   global af nundo
   if {[winfo exists .addfiles]} {
      if {$af(files)==""} {
	 .addfiles.f1.delete configure -state disabled
	 .addfiles.f1.modify configure -state disabled
	 .addfiles.f1.copy1 configure -state disabled
	 .addfiles.f1.edit configure -state disabled
	 .addfiles.f1.replace configure -state disabled
      } else {
	 .addfiles.f1.delete configure -state normal
	 .addfiles.f1.modify configure -state normal
	 .addfiles.f1.copy1 configure -state normal
	 .addfiles.f1.edit configure -state normal
	 .addfiles.f1.replace configure -state normal
      }
      if {$nundo > 1} {
	 .addfiles.f1.undo configure -state normal
      } else {
	 .addfiles.f1.undo configure -state disabled
      }
   }
}

################################################################################

proc FileCopy {fc_files fc_fslct fc_host fc_lfile fc_rfile} {
   global pd af af_index
   
   if {[winfo exists .selsav]} {destroy .selsav}
   IncrUndo
   set lfile [lindex $fc_files $fc_lfile]
   set rfile [lindex $fc_files $fc_rfile]
   lappend fc_files $lfile $rfile
   set pd(files) [lreplace $pd(files) $fc_host $fc_host $fc_files] 

   set lslct [lindex $fc_fslct $fc_lfile]
   lappend fc_fslct $lslct 0
   set pd(fslct) [lreplace $pd(fslct) $fc_host $fc_host $fc_fslct] 

   foreach item {files fslct} {
      if {$af_index != ""} {set af($item) [lindex $pd($item) $af_index]}
   }      
}

################################################################################

proc FileCopyFromHost {fcfh_files fcfh_fslct fcfh_host} {
   global pd af af_index cffh
   
   if {[winfo exists .selsav]} {destroy .selsav}
   IncrUndo
   set cffh(host) [lindex $pd(hosts) $fcfh_host]
   foreach item $cffh(files) {
      lappend fcfh_files $item
   }
   set pd(files) [lreplace $pd(files) $fcfh_host $fcfh_host $fcfh_files] 

   foreach item $cffh(fslct) {
      lappend fcfh_fslct $item
   }
   set pd(fslct) [lreplace $pd(fslct) $fcfh_host $fcfh_host $fcfh_fslct] 

   foreach item {files fslct} {
      if {$af_index != ""} {set af($item) [lindex $pd($item) $af_index]}
   }      
}

################################################################################

proc FileDelete {fd_files fd_fslct fd_host fd_lfile fd_rfile} {
   global pd af af_index
   
   if {[winfo exists .selsav]} {destroy .selsav}

   set fd_files [lreplace $fd_files $fd_lfile $fd_rfile]
   set pd(files) [lreplace $pd(files) $fd_host $fd_host $fd_files] 

   set fd_fslct [lreplace $fd_fslct $fd_lfile $fd_rfile]
   set pd(fslct) [lreplace $pd(fslct) $fd_host $fd_host $fd_fslct] 

   foreach item {files fslct} {
      if {$af_index != ""} {set af($item) [lindex $pd($item) $af_index]}
   }      
}

################################################################################

proc FileAdd {fa_files fa_fslct fa_host} {
   global pd af af_index entry1 entry2
   
   if {[winfo exists .selsav]} {destroy .selsav}

#  multiple files (i.e. a file with a wildcard *)
   if {[string match *\\** $entry1]} {
      if {[file dirname $entry1] != "."} {
         set dir1 [file dirname $entry1]/
      } else {
         set dir1 ""
      }
      if {[file dirname $entry2] != "."} {
         set dir2 [file dirname $entry2]/
      } else {
         set dir2 ""
      }
      foreach item [lsort [glob $entry1]] {
	 lappend fa_files $dir1[file tail $item] $dir2[file tail $item]
	 lappend fa_fslct 1 0
      }

#  a single file
   } else {
      lappend fa_files $entry1 $entry2
      lappend fa_fslct 1 0
   }
   set pd(files) [lreplace $pd(files) $fa_host $fa_host $fa_files]
   set pd(fslct) [lreplace $pd(fslct) $fa_host $fa_host $fa_fslct]
   foreach item {files fslct} {
      if {$af_index != ""} {set af($item) [lindex $pd($item) $af_index]}
   }      
}
