proc AddFiles {tmpindex {w .addfiles}} {
   global entry1 entry2 cffh colors
   global af_index af_host af af_oldhost
   global pd prefs env nitem

   set af_index $tmpindex
   set af_host [.f4.l.listbox get $af_index]
   set af_oldhost $af_host
   set af(files) [lindex $pd(files) $af_index]
   set af(fslct) [lindex $pd(fslct) $af_index]

   catch {destroy $w}
   toplevel $w
   wm title $w "PADE Files"
   wm iconname $w "Files"
   wm geometry $w +170+218
   wm iconbitmap $w @$env(PADE_ROOT)/pade/pade_icon.xbm
   $w config -cursor {arrow red white}

   frame   $w.f1 -bd 1 -relief raised
   frame   $w.f2 -bd 1 -relief raised
   frame   $w.f3 -bd 1 -relief raised
   frame   $w.f5 -bd 1 -relief raised
   frame   $w.f4 -bd 1 -relief raised

   label   $w.f2.msg -text "File list for host:   $af_host   (local --> remote)"
   pack    $w.f2.msg -expand 1 -pady 3m

   listbox $w.f3.listbox -yscroll [list $w.f3.yscroll set] \
      -xscroll [list $w.f3.xscroll set] -relief sunken
   scrollbar $w.f3.xscroll -relief sunken -command [list $w.f3.listbox xview] \
      -orient horiz
   scrollbar $w.f3.yscroll -relief sunken -command [list $w.f3.listbox yview]
   pack $w.f3.xscroll -side bottom -fill x
   pack $w.f3.yscroll -side left -fill y
   pack $w.f3.listbox -expand 1 -fill both -ipady 12m

   text    $w.f4.text -height 2 -width 1 -fg $colors(TEXT) -state disabled \
      -relief flat
   pack    $w.f4.text -fill x -expand 1

#-------------------------------------------------------------------------------
#  ADD BUTTON

   button $w.f1.add -text "Add" -relief flat -command {
      TextWrite .addfiles.f4.text ""
      .addfiles.f3.listbox selection clear 0 end
      AddFile "" "" "ADD" "" ".addfiles"
   }

#-------------------------------------------------------------------------------
#  MODIFY BUTTON 

   button $w.f1.modify -text "Modify" -relief flat -command {
      set index5 ""
      set index5 [.addfiles.f3.listbox curselection]
      if {$index5 != ""} {
	 TextWrite .addfiles.f4.text ""
	 set lfile [lindex $af(files) [expr $index5*2]]
	 set rfile [lindex $af(files) [expr $index5*2+1]]
         AddFile $lfile $rfile "MOD" $index5 ".addfiles"
      } else {
	 TextWrite .addfiles.f4.text \
	    "You must first select an entry from the File list" 
      }
   }

#-------------------------------------------------------------------------------
#  COPY BUTTON

   button $w.f1.copy1 -text "Copy" -relief flat -command {
      set index6 ""
      set index6 [.addfiles.f3.listbox curselection]
      if {$index6 != ""} {
         FileCopy $af(files) $af(fslct) $af_index [expr $index6*2] [expr $index6*2+1]
         FilesListboxWrite
        .addfiles.f3.listbox see end
         set pos [expr [llength $af(files)]/2-1]
         .addfiles.f3.listbox selection set $pos $pos
	 TextWrite .addfiles.f4.text "Copied file: [lindex $af(files) [expr $index6*2]]"
	 GraphUpdate 
      } else {
	 TextWrite .addfiles.f4.text \
	    "You must first select an entry from the File list" 
      }
      UpdateButtons
   }

#-------------------------------------------------------------------------------
#  COPY FROM HOST BUTTON

   button $w.f1.copy2 -text "Copy From Host" -relief flat -command {
      TextWrite .addfiles.f4.text ""
      .addfiles.f3.listbox selection clear 0 end
      set cffh(files) ""
      set cffh(mode) "LR"
      CopyFilesFromHost
      if {$cffh(files) != "CANCEL" && $cffh(files) != ""} {
         set host_from $cffh(host)
         FileCopyFromHost $af(files) $af(fslct) $af_index
         FilesListboxWrite
         .addfiles.f3.listbox see end
	 .addfiles.f3.listbox selection clear 0 end
	 TextWrite .addfiles.f4.text \
	    "[expr [llength $cffh(files)]/2] files copied from $host_from to $cffh(host)"
	 GraphUpdate
      }
      UpdateButtons
   }

#-------------------------------------------------------------------------------
#  GLOBAL REPLACE BUTTON

   button $w.f1.replace -text "Global Replace" -relief flat -command {
      TextWrite .addfiles.f4.text ""
      .addfiles.f3.listbox selection clear 0 end
      ReplaceString
      if {$entry1 != ""} {
         set af(files) [FileReplace $af(files)]
         set pd(files) [lreplace $pd(files) $af_index $af_index $af(files)] 
	 FilesListboxWrite
	 GraphUpdate
      }
      UpdateButtons
   }
   
#-------------------------------------------------------------------------------
#  DELETE BUTTON

   button $w.f1.delete -text "Delete" -relief flat -command {
      set index4 ""
      set index4 [.addfiles.f3.listbox curselection]

      if {$index4 != ""} {
	 TextWrite .addfiles.f4.text ""
	 IncrUndo
	 FileDelete $af(files) $af(fslct) $af_index [expr $index4*2] [expr $index4*2+1]
	 FilesListboxWrite
         GraphUpdate
      } else {
	 TextWrite .addfiles.f4.text \
	    "You must first select an entry from the File list" 
      }
      UpdateButtons
   }

#-------------------------------------------------------------------------------
#  EDIT FILE BUTTON

   button $w.f1.edit -text "Edit File" -relief flat -command {
      set index7 ""
      set index7 [.addfiles.f3.listbox curselection]

#  send just the filename (not the --> and the remote filename)
      if {$index7 != ""} {
	 TextWrite .addfiles.f4.text ""
         EditFile [lindex $af(files) [expr $index7*2]]
         .addfiles.f3.listbox selection set $index7 $index7
      } else {
	 TextWrite .addfiles.f4.text \
	    "You must first select an entry from the File list" 
      }
   }

#-------------------------------------------------------------------------------
#  UNDO BUTTON

   button $w.f1.undo -text "Undo" -relief flat -command {
      .addfiles.f3.listbox selection clear 0 end
      TextWrite .addfiles.f4.text ""
      if {$nundo > 0} {
         DecrUndo
         set af(files) [lindex $pd(files) $af_index]
         set af(fslct) [lindex $pd(fslct) $af_index]
	 FilesListboxWrite
         .addfiles.f3.listbox selection clear 0 end
         HostListboxWrite
         UpdateButtons
         if {[winfo exists .graph]} {GraphUpdate}
         if {$af(files) == ""} {
            destroy .addfiles
            if {[winfo exists .addfil]} {destroy .addfil}
         }
      }
   }

#-------------------------------------------------------------------------------
#  CLOSE BUTTON

   button $w.f5.close -text "Close" -command {
      if {[winfo exists .addfil] && ($aff_fromw == ".addfiles")} {destroy .addfil}
      destroy .addfiles
   }

#-------------------------------------------------------------------------------

   pack $w.f1.add $w.f1.copy2 $w.f1.copy1 $w.f1.modify \
      $w.f1.replace $w.f1.delete $w.f1.undo $w.f1.edit \
      -side left -ipadx 2m

   pack $w.f5.close -side left -expand 1 -pady 4m -ipadx 2m
   pack $w.f1 $w.f2 $w.f3 $w.f4 $w.f5 -side top -fill x   
   ConfigColorText $w
   
   update idletasks
   wm minsize .addfiles [winfo width .addfiles] [winfo height .addfiles] 

   FilesButtons
   FilesListboxWrite

   tkwait window $w
}

################################################################################

proc AddFile {localfile remotefile tmpmode tmpindex tmpfrom {w .addfil}} {
   global pd af_index af_host localpath remotepath env
   global aff_mode aff_index aff_fromw entry1 entry2 
   global clicktype1 addtype fromw oldmode prefs colors
   
   set aff_mode $tmpmode
   set aff_index $tmpindex
   set aff_fromw $tmpfrom

#  CHECK IF THE WINDOW EXISTS, IF NOT CREATE IT
   if {![winfo exists .addfil] || ($aff_mode != $oldmode)} {
   
   set oldmode $aff_mode
   catch {destroy $w}
   toplevel $w
   if {$aff_mode == "ADD"} {
      wm title $w "PADE Add File"
      wm iconname $w "Add File"
   } elseif {$aff_mode == "MOD"} {
      wm title $w "PADE Modify File"
      wm iconname $w "Modify File"
   }
   wm geometry $w +230+575
   wm iconbitmap $w @$env(PADE_ROOT)/pade/pade_icon.xbm
   $w config -cursor {arrow red white}

   tkwait visibility $w

   frame   $w.f1 -bd 2 -relief raised
   frame   $w.f1.top
   frame   $w.f1.bot
   frame   $w.f2 -bd 2 -relief raised
   frame   $w.f2.top
   frame   $w.f2.bot
   frame   $w.f3 -bd 2 -relief raised
   frame   $w.f4 -bd 2 -relief raised

#-------------------------------------------------------------------------------
#  LOCAL FILE ENTRY

   label   $w.f1.top.msg -text "Local file:"
   entry   $w.f1.top.entry -textvariable localname -relief sunken -width 55
   pack    $w.f1.top.msg -side left -padx 3m -anchor w
   pack    $w.f1.top.entry -side right -padx 3m -anchor e
   $w.f1.top.entry delete 0 end
   $w.f1.top.entry insert 0 $localfile

#-------------------------------------------------------------------------------
#  CLEAR, FILL WITH LAST PATH, FILE BROWSER BUTTONS

   button  $w.f1.bot.clear -text "Clear" -command {
      TextWrite .addfil.f3.text ""
      .addfil.f1.top.entry delete 0 end
      focus .addfil.f1.top.entry
   }
   button  $w.f1.bot.fill \
      -text "Fill with last path" -command {
      TextWrite .addfil.f3.text ""
      if {$localpath != ""} {
	 .addfil.f1.top.entry delete 0 end
	 .addfil.f1.top.entry insert 0 $localpath
         focus .addfil.f1.top.entry
      }
   }
   button  $w.f1.bot.filefind \
      -text "File Browser" -command {
      TextWrite .addfil.f3.text ""
      set ffile [fileselect "Pick existing file" $prefs(FILE_PATH)/]
      if {$ffile != ""} {set localname $ffile}
      focus .addfil.f1.top.entry
   }
   pack    $w.f1.bot.clear $w.f1.bot.fill $w.f1.bot.filefind \
      -side left -expand 1 -padx 3m -ipadx 2m -ipady 1m
   pack    $w.f1.top $w.f1.bot -fill x -pady 4m

#-------------------------------------------------------------------------------
#  REMOTE FILE ENTRY

   label   $w.f2.top.msg -text "Remote file:"
   entry   $w.f2.top.entry -textvariable remotename -relief sunken -width 55
   $w.f2.top.entry delete 0 end
   $w.f2.top.entry insert 0 $remotefile
   pack    $w.f2.top.msg -side left -padx 3m -pady 4m -anchor w
   pack    $w.f2.top.entry -side right -padx 3m -pady 4m -anchor e

#-------------------------------------------------------------------------------
#  CLEAR, FILL WITH LAST PATH BUTTONS

   button  $w.f2.bot.clear -text "Clear" -command {
      TextWrite .addfil.f3.text ""
      .addfil.f2.top.entry delete 0 end
      focus .addfil.f2.top.entry
   }
   button  $w.f2.bot.fill \
      -text "Fill with last path" -command {
      TextWrite .addfil.f3.text ""
      if {$remotepath != ""} {
	 .addfil.f2.top.entry delete 0 end
	 .addfil.f2.top.entry insert 0 $remotepath
         focus .addfil.f2.top.entry
      }
   }

   pack    $w.f2.bot.clear $w.f2.bot.fill \
      -side left -expand 1 -padx 3m -pady 4m -ipadx 2m -ipady 1m
   pack    $w.f2.top $w.f2.bot -fill x

#-------------------------------------------------------------------------------

   text	   $w.f3.text -height 1 \
     -fg $colors(TEXT) -width 1 -state disabled -relief flat
   pack    $w.f3.text -fill x -expand 1

#-------------------------------------------------------------------------------
#  APPLY BUTTON

   button $w.f4.apply -text "Apply" -command {
      TextWrite .addfil.f3.text ""
      set localname [string trim $localname]
      set remotename [string trim $remotename]
      
#  check for missing local or remote file name
      if {$aff_mode == "ADD"} {
         if {($localname == "" && $remotename != "") || \
            ($localname != "" && $remotename == "") } {
            TextWrite .addfil.f3.text "No local or remote file name entered"
            return
         }
      } else {
         if {($localname == "" || $remotename == "")} {
            TextWrite .addfil.f3.text "No local or remote file name entered"
            return
         }
      }

#  check for a blank character in the local or remote file name
      set iblank 0
      if {[string first " " $localname] != -1} {set iblank 1}
      if {[string first " " $remotename] != -1} {set iblank 1}
      if {$iblank} {
         TextWrite .addfil.f3.text \
            "The local or remote file name has a blank in it"
         return
      }

#  check if the local or remote file name ends in a / (i.e. a directory)
      set islash 0
      if {[string index $localname \
	 [expr [string length $localname]-1]] == "/"} {set islash 1}
      if {[string index $remotename \
	 [expr [string length $remotename]-1]] == "/"} {set islash 1}
      if {$islash} {
         TextWrite .addfil.f3.text \
            "The local or remote file name is a directory"
         return
      }
      
      set entry1 $localname
      set entry2 $remotename

#  get the directory name of the local and remote files
      if {$localname != ""} {
         set localpath ""
         set dirname [file dirname $localname]
         if {$dirname != "."} {set localpath $dirname/}
	 if {$localpath == ""} {
	    .addfil.f1.bot.fill configure -state disabled
	 } else {
	    .addfil.f1.bot.fill configure -state normal
	 }
      }
      if {$remotename != ""} {
         set remotepath ""
         set dirname [file dirname $remotename]
         if {$dirname != "."} {set remotepath $dirname/}
	 if {$remotepath == ""} {
	    .addfil.f2.bot.fill configure -state disabled
	 } else {
	    .addfil.f2.bot.fill configure -state normal
	 }
      }

#  window opened from addfiles, do lots of stuff
#  if opened from graph, this stuff is done elsewhere
      if {$aff_fromw == ".addfiles"} {
	 IncrUndo

#  add the file
	 if {$aff_mode == "ADD"} {
	    FileAdd $af(files) $af(fslct) $af_index

#  modify the file
	 } elseif {$aff_mode == "MOD"} {
            set af(files) [lreplace $af(files) [expr $aff_index*2] \
               [expr $aff_index*2+1] $entry1 $entry2]
	    set pd(files) [lreplace $pd(files) $af_index $af_index $af(files)]
	 }

#  update files in listbox
	 FilesListboxWrite
         .addfiles.f3.listbox see end

#  print some messages
	 if {$aff_mode == "ADD"} {
	    set pos [expr [llength $af(files)]-1] 
            .addfiles.f3.listbox selection set $pos $pos
            if {[winfo exists .graph]} {
               TextWrite .graph.f2.text \
   "Added file to host: $af_host\nLOCAL FILE: $entry1\nREMOTE FILE: $entry2"
            }
            focus .addfil.f1.top.entry
	 } elseif {$aff_mode == "MOD"} {
            .addfiles.f3.listbox selection set $aff_index $aff_index
            if {[winfo exists .graph]} {
               TextWrite .graph.f2.text \
   "Modified file on host: $af_host\nLOCAL FILE: $entry1\nREMOTE FILE: $entry2"
            }
	 }
	 GraphUpdate

#  window opened from graph
      } elseif {$aff_fromw == ".graph"} {
         if {$aff_mode == "ADD"} {
            set addtype file
            set clicktype1 1
            TextWrite .graph.f2.text "Click on Host (circle) to Add file to"
	 } elseif {$aff_mode == "MOD"} {
	    set addtype none
	    set clicktype1 -3
	 }
      }

      UpdateButtons

#  destroy window if modifying file
      if {$aff_mode == "MOD"} {
         set oldmode ""
         set aff_fromw ""
         destroy .addfil
      }
   }

#------------------------------------------------------------------------------
#  CLOSE BUTTON

   button $w.f4.close -text "Close" -command {
      set entry1 ""
      set oldmode ""
      set aff_fromw ""
      destroy .addfil
      if {[winfo exists .graph]} {TextWrite .graph.f2.text ""}
   }

   pack $w.f4.apply $w.f4.close \
      -side left -expand 1 -padx 3m -pady 4m -ipadx 2m -ipady 1m
   pack $w.f1 $w.f2 $w.f3 $w.f4 -fill x
   ConfigColorText $w

#  set focus to local file entry
   focus $w.f1.top.entry

#  return and tab move to next file entry
   bind $w.f1.top.entry <Return> {
      focus .addfil.f2.top.entry
   }
   bind $w.f1.top.entry <Tab> {
      focus .addfil.f2.top.entry
   }
   bind $w.f2.top.entry <Return> { }
   bind $w.f2.top.entry <Tab> {
      focus .addfil.f1.top.entry
   }

#  button-2 inserts text from selection
   bind $w.f1.top.entry <Button-2> {
      .addfil.f1.top.entry insert insert [selection get]
   }
   bind $w.f2.top.entry <Button-2> {
      .addfil.f2.top.entry insert insert [selection get]
   }

#  configure fill with last path buttons
   if {$localpath == ""} {
      $w.f1.bot.fill configure -state disabled
   } else {
      $w.f1.bot.fill configure -state normal
   }
   if {$remotepath == ""} {
      $w.f2.bot.fill configure -state disabled
   } else {
      $w.f2.bot.fill configure -state normal
   }

   tkwait window $w
   
#------------------------------------------------------------------------------
#  The window is already opened, so just update with the variables that were
#  passed in.

   } else {
      $w.f1.top.entry delete 0 end
      $w.f1.top.entry insert 0 $localfile
      $w.f2.top.entry delete 0 end
      $w.f2.top.entry insert 0 $remotefile
      focus $w.f1.top.entry
      if {$aff_mode == "ADD"} {
	 wm title $w "PADE Add File"
	 wm iconname $w "Add File"
      } elseif {$aff_mode == "MOD"} {
	 wm title $w "PADE Modify File"
	 wm iconname $w "Modify File"
      }
   }
}

################################################################################

#  PADE copy the files from one host to another

proc CopyFilesFromHost {{w .cphst}} {
   global entry1 cffh env pd prefs
   catch {destroy $w}
   toplevel $w
   wm title $w "PADE Copy"
   wm iconname $w "Copy"
   wm geometry $w +230+525
   wm iconbitmap $w @$env(PADE_ROOT)/pade/pade_icon.xbm
   $w config -cursor {arrow red white}

   frame   $w.f1 -bd 1 -relief raised
   label   $w.f1.msg -text "Pick a Host"
   pack    $w.f1.msg -expand 1 -pady 3m

   frame   $w.f2 -bd 1 -relief raised
   frame   $w.f3 -bd 1 -relief raised
   frame   $w.f4 -bd 1 -relief raised
   pack    $w.f1 $w.f2 $w.f3 $w.f4 -side top -fill x

#-------------------------------------------------------------------------------
#  scroll box
   scrollbar $w.f2.scroll -relief sunken -command [list $w.f2.listbox yview]
   listbox $w.f2.listbox -yscroll [list $w.f2.scroll set] -relief sunken
     
   pack $w.f2.scroll -side left -fill y
   pack $w.f2.listbox -expand 1 -fill both

   foreach item $pd(hosts) {.cphst.f2.listbox insert end $item}

#-------------------------------------------------------------------------------

   label $w.f3.msg -text "Copy which files:"
   radiobutton $w.f3.lr -text "Local and remote" \
      -variable cffh(mode) -value "LR" -relief flat
   radiobutton $w.f3.lo -text "Local only" \
      -variable cffh(mode) -value "LO" -relief flat
   pack $w.f3.msg $w.f3.lr $w.f3.lo \
      -side left -pady 3m -ipadx 2m -ipady 1m
   
#-------------------------------------------------------------------------------

#  send back the new list of files in cffh(files) and exit
   button $w.f4.ok -text "Apply" -command {
      set index9 [.cphst.f2.listbox curselection]
      if {$index9 != ""} {
	 set cffh(host) [lindex $pd(hosts) $index9]
	 set cffh(files) [lindex $pd(files) $index9]
         set cffh(fslct) [lindex $pd(fslct) $index9]
         destroy .cphst
      }
   }
   
   button $w.f4.cancel -text "Cancel" -command {
      set cffh(files) "CANCEL"
      destroy .cphst
   }

   pack $w.f4.ok $w.f4.cancel \
      -side left -expand 1 -padx 3m -pady 4m -ipadx 2m -ipady 1m
   ConfigColorText $w

#  double-1 on a host name is the same as apply
   bind $w.f2.listbox <Double-1> {
      set index9 [.cphst.f2.listbox curselection]
      set cffh(host) [lindex $pd(hosts) $index9]
      set cffh(files) [lindex $pd(files) $index9]
      set cffh(fslct) [lindex $pd(fslct) $index9]
      destroy .cphst
      break
   }

   tkwait window $w
}

################################################################################

#  PADE global string replacement for file names

proc ReplaceString {{w .rep}} {
   global entry1 entry2 env colors lastrep
   catch {destroy $w}
   toplevel $w
   wm title $w "PADE Global Replace"
   wm iconname $w "Replace"
   wm geometry $w +230+625
   wm iconbitmap $w @$env(PADE_ROOT)/pade/pade_icon.xbm
   $w config -cursor {arrow red white}

   frame   $w.f1 -bd 1 -relief raised
   label   $w.f1.msg -text "Global replace from:"
   entry   $w.f1.entry -textvariable string1 -relief sunken -width 55
   pack    $w.f1.msg -side left -expand 1 -padx 2m -pady 5m -anchor w
   pack    $w.f1.entry -side right -expand 1 -padx 2m -pady 5m -anchor e
   $w.f1.entry delete 0 end

   frame   $w.f2 -bd 1 -relief raised
   label   $w.f2.msg -text "Global replace to:"
   entry   $w.f2.entry -textvariable string2 -relief sunken -width 55
   pack    $w.f2.msg -side left -expand 1 -padx 2m -pady 5m -anchor w
   pack    $w.f2.entry -side right -expand 1 -padx 2m -pady 5m -anchor e
   $w.f2.entry delete 0 end

   frame   $w.f3 -bd 1 -relief raised
   text	   $w.f3.text -height 1 -fg $colors(TEXT) -width 1 -state disabled \
      -relief flat
   pack    $w.f3.text -fill x -expand 1

   frame   $w.f4 -bd 1 -relief raised
   button  $w.f4.lastrep -text "Last Replace" -command {
      .rep.f1.entry delete 0 end
      .rep.f1.entry insert 0 [lindex $lastrep 0]
      .rep.f2.entry delete 0 end
      .rep.f2.entry insert 0 [lindex $lastrep 1]
   }
   button  $w.f4.save -text "Apply" -command {
      set ok 1
      set string1 [string trim $string1]
      set string2 [string trim $string2]
      if {$string1 == ""} {
         TextWrite .rep.f3.text "The 'Global replace from:' string is blank"
         set ok 0
      }      
      set blank1 [string first " " $string1]
      set blank2 [string first " " $string2]
      if {$blank1 != -1 || $blank2 != -1} { 
         TextWrite .rep.f3.text \
            "One of the 'Global replace' strings has a blank in it"
         set ok 0
      }
      if {$ok} {     
	 set entry1 $string1
	 set entry2 $string2
	 set lastrep "$entry1 $entry2"
	 destroy .rep
      }
   }
   button  $w.f4.cancel -text "Cancel" -command {
      TextWrite .rep.f3.text ""
      set entry1 "CANCEL"
      destroy .rep
   }
   pack $w.f4.lastrep $w.f4.save $w.f4.cancel \
     -side left -expand 1 -padx 3m -pady 4m -ipadx 2m -ipady 1m
    

   pack  $w.f1 $w.f2 $w.f3 -anchor w -fill x
   pack  $w.f4 -fill x
   
   if {$lastrep != ""} {
      $w.f4.lastrep configure -state normal
   } else {
      $w.f4.lastrep configure -state disabled
   }

   ConfigColorText $w

   focus $w.f1.entry

   bind $w.f1.entry <Return> {
      focus .rep.f2.entry
   }
   bind $w.f1.entry <Tab> {
      focus .rep.f2.entry
   }

   bind $w.f2.entry <Return> {
   }
   bind $w.f2.entry <Tab> {
      focus .rep.f1.entry
   }

   tkwait window $w
}

################################################################################

#  PADE global string replacement for file names

proc FileReplace {filelist} {
   global entry1 entry2
   
   if {[winfo exists .selsav]} {destroy .selsav}
   IncrUndo
   set i 1
   set naf(files) ""
   set len [string length $entry1]
   foreach name $filelist {
      regsub -all $entry1 $name $entry2 newname
      set name $newname
      set naf(files) [linsert $naf(files) [llength $naf(files)] $name]
      incr i
   }
   set filelist $naf(files)
   return $filelist
}
