#ifndef _tam_P_
#define _tam_P_

#include "tam.h"

void tam_initfn() {
}

/************************************************************/
/************************************************************/
/************************************************************/

tam_ACC1::tam_ACC1 (tam_ACC_MSG *data) {
     msg = new tam_ACC_MSG ;
     msg->nodes = data->nodes;
}

void
tam_ACC1::Accumulate (tam_ACC_MSG *data) {

     msg->nodes += data->nodes;

}

void
tam_ACC1::Combine (tam_ACC_MSG *y) {
     
     msg->nodes += y->nodes;

}

/************************************************************/
/************************************************************/
/************************************************************/

tam_MONO1::tam_MONO1 (tam_MONO_MSG *data) {
     msg = new tam_MONO_MSG ;
     msg->least = INFINITY;
}

	
int
tam_MONO1::Update (tam_MONO_MSG *y) {

     if (msg->least > y->least) {

	  msg->least = y->least;
	  return(1);

     }

     return(0);	

}

/************************************************************/
/************************************************************/
/************************************************************/

tam_start::tam_start(INIT_MSG *imsg) {

     tam_INIT_MSG *msg1, *msg2, *msg3;
     
     iteration = imsg->iteration;
     retEP = imsg->retEP;
     retID = imsg->retID;
     count = 0;
     
     
     msg1 = new tam_INIT_MSG ;
     msg1->dummy = 1;
     msg2 = new tam_INIT_MSG ;
     msg2->dummy = 2;
     msg3 = new tam_INIT_MSG ;
     msg3->dummy = 3;
     newchare (&NULL_HANDLE, 1) next (msg1) ;
     newchare (&NULL_HANDLE, 2) next (msg2) ;
     newchare (&NULL_HANDLE, 3) next (msg3) ;
     chareid = thishandle;
     CStartQuiescence(&(tam_start::Quiescence), chareid);
     delete imsg ;
}

void
tam_start::Quiescence (QuiescenceMessage *dmsg) {

     IT_MSG *imsg;

     CPrintf("TAM:Value of first bound is %d\n", 
	     ((tam_MONO_MSG *) MonoValue(monoid[0]))->least);
     CPrintf("TAM:Value of second bound is %d\n", 
	     ((tam_MONO_MSG *) MonoValue(monoid[1]))->least);
     CPrintf("TAM:Value of third bound is %d\n", 
	     ((tam_MONO_MSG *) MonoValue(monoid[2]))->least);
     CPrintf("TAM:Quiescence Detected. \n");
     CPrintf("TAM:\n\n");
     CPrintf("TAM:-----------------------------------------------------------------------------\n");
     imsg = new IT_MSG ;
     imsg->iteration = iteration;

     retID=>retEP(imsg);
//     SendMsg(retEP, imsg, &retID);
     delete dmsg ;
}

void
tam_start::AccEntry (tam_ACC_MSG *msg) {

     CPrintf("TAM:main@AccEntry::  msg->nodes = %d\n", msg->nodes);
     delete msg ;

}

void
tam_start::INFO (tam_INFO_MSG *msg) {

     monoid[count] = msg->monoid;
     count++;
     delete msg ;

}

/************************************************************/
/************************************************************/
/************************************************************/

next::next (tam_INIT_MSG *msg) {

     tam_ACC_MSG *acc_msg;
     tam_MONO_MSG *mono_msg;
     
     acc_recd = mono_recd = 0;
     chareid = thishandle;
     acc_msg = new tam_ACC_MSG ;
     mono_msg = new tam_MONO_MSG ;
     acc_msg->nodes = 0;
     mono_msg->least = INFINITY;
     id = msg->dummy;
     newaccumulator (&(next::AccEntry), &chareid) tam_ACC1(acc_msg) ;
     newmonotonic (&(next::MonoEntry), &chareid) tam_MONO1(mono_msg) ;
     delete msg ;
}

void
next::AccEntry (tam_INIT_MSG *msg) {

     tam_VAGUE_MSG *tmsg;

     accid = msg->dummy;
     if (mono_recd) {

	  tmsg = new tam_VAGUE_MSG ;
	  tmsg->count = 0;
	  tmsg->accid = accid;
	  tmsg->monoid = monoid;
	  tmsg->id = id;
	  newchare next(tmsg);
//	  CreateChare(next, next@BEGIN, tmsg); 
     }
     else
	  acc_recd = TRUE;

     delete msg ;
}

void
next::MonoEntry (tam_INIT_MSG *msg) {

     tam_VAGUE_MSG *tmsg;

     monoid = msg->dummy;

     if (acc_recd) {

	  tmsg = new tam_VAGUE_MSG ;
	  tmsg->count = 0;
	  tmsg->accid = accid;
	  tmsg->monoid = monoid;
	  tmsg->id = id;
	  newchare next(tmsg);
//	  CreateChare(next, next@BEGIN, tmsg); 
     }

     else
	  mono_recd = TRUE;

     delete msg ;
}


void
next::BEGIN (tam_VAGUE_MSG *msg) {

     tam_ACC_MSG *tmsg1;
     tam_MONO_MSG *tmsg2;
     tam_INFO_MSG *tmsg3;
     
     if (msg->count < MAX_COUNT)
     {
	  msg->count += 1;
	  
	  tmsg1 = new tam_ACC_MSG ;
	  tmsg1->nodes = msg->id;
	  tam_ACC1 handle h = msg->accid;
	  h->Accumulate(tmsg1);
//	  Accumulate(msg->accid, addfn(tmsg1));
	  
	  tmsg2 = new tam_MONO_MSG ;
	  tmsg2->least  = MAX_COUNT * msg->id - msg->count; 

	  tam_MONO1 handle hprime = msg->monoid;
	  hprime->Update(tmsg2);
//	  NewValue(msg->monoid, updatefn(tmsg2));
	  
	  newchare next(msg);
//	  CreateChare(next, next@BEGIN, msg);
	  ChareExit();
     }
     else
     {
	  tmsg3 = new tam_INFO_MSG ;
	  tmsg3->monoid = msg->monoid;
	  main_chareid = mainhandle;
	  main_chareid=>INFO(tmsg3);
//	  SendMsg(start@INFO, tmsg3, &main_chareid);
	  tam_ACC1 handle h = msg->accid;
	  h->CollectValue(&(tam_start::AccEntry), main_chareid);
//	  CollectValue(msg->accid, start@AccEntry, &main_chareid);
     }

     delete msg ;

}

#endif
