/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: sfb.p,v $
 *	$Author: jyelon $	$Locker:  $		$State: Exp $
 *	$Revision: 2.1 $	$Date: 1995/11/15 21:04:20 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: sfb.p,v $
 * Revision 2.1  1995/11/15 21:04:20  jyelon
 * changed 'MyChareID' to 'ThisChareID'
 *
 * Revision 2.0  1995/07/05  20:13:28  brunner
 * Separated out multi stuff, and including in charm_pgms tree
 *
 * Revision 1.2  1995/06/20  20:09:09  jyelon
 * *** empty log message ***
 *
 * Revision 1.1  1995/02/25  01:27:08  jyelon
 * Initial revision
 *
 ***************************************************************************/

/* Charm program to find the nth Fibonacci number */
/* Suggested input : n = 10, grainsize = 3        */

#include "testpgm.interface"
#include "sfb.interface"

module sfb {

int Fib() ;

readonly int grainSize, topFib;

message { 
        int n;
        ChareIDType parentID;
    	int iteration;
    	EntryPointType retEP;
   	ChareIDType retID;
} ProblemMsg;

message {
        int fib;
} SolutionMsg;

void initfn()
{
	topFib = 10;
	grainSize = 5;
        ReadInit(grainSize); 
        ReadInit(topFib);
}

chare start {
        int k;
entry begin:(message main_test::INIT_MSG *imsg)
{  
        ProblemMsg * pMsg ;

        pMsg = (ProblemMsg *) CkAllocMsg( ProblemMsg);
        pMsg->n = topFib;
     	pMsg->iteration = imsg->iteration;
     	pMsg->retEP = imsg->retEP;
     	pMsg->retID = imsg->retID;

        pMsg->parentID = ThisChareID;
        CreateChare(fib, fib@Compute, pMsg);  
	CkFreeMsg(imsg);
	}

}


chare fib 
{
        ChareIDType parent;
        int total, count;
        int n ;

	int iteration;
    	EntryPointType retEP;
	ChareIDType retID;
    

private sendResponse(value)
int value;
{ 
	main_test::IT_MSG *imsg;

        if ( n == topFib ) {
                CkPrintf("SFB:The answer is: %d at %f seconds.\n",value,
                                                                   CmiTimer());
	imsg = (main_test::IT_MSG *) CkAllocMsg (main_test::IT_MSG);
	imsg->iteration = iteration;

	SendMsg(retEP, imsg, &retID);
	
        }
        else {  /* NOTE: This else clause is REQUIRED. See CkExit in manual */
                SolutionMsg * resp;
                resp = (SolutionMsg *) CkAllocMsg( SolutionMsg);
                resp->fib = value;
                SendMsg(fib@Response, resp, &parent);
        }
}


entry Compute: (message ProblemMsg *msg)
{
        int result ;
        ProblemMsg *pMsg ;


        parent = msg->parentID ;
     	iteration = msg->iteration;
     	retEP = msg->retEP;
     	retID = msg->retID;


        n = msg->n ;
        if ( n <= ReadValue(grainSize) ) {
                result = Fib(n) ;
                PrivateCall(sendResponse(result)) ;
        }
        else {
                total = 0 ;
                count = 2 ;

                pMsg = (ProblemMsg *) CkAllocMsg( ProblemMsg);
                pMsg->n = n - 1 ;
                pMsg->parentID = ThisChareID;
                CreateChare(fib, fib@Compute, pMsg);  
        
                pMsg = (ProblemMsg *) CkAllocMsg( ProblemMsg);
                pMsg->n = n - 2 ;
                pMsg->parentID = ThisChareID;
                CreateChare(fib, fib@Compute, pMsg);  
        }
        CkFreeMsg(msg) ;
}


entry Response: (message SolutionMsg * msg)
{ 
        total += msg->fib;
        if (--count == 0) 
                PrivateCall(sendResponse(total));
        CkFreeMsg(msg) ;
}

}


Fib(n)
int n;
{ 
        if (n<2)
                return(n);
        else
                return(Fib(n-1)+Fib(n-2));
}

}



