// Hey emacs, this is -*- C++ -*-
#ifndef _tpk_h_
#define _tpk_h_

#define MAX 30 

#include "megatest++.h"
#include "messages.h"
#include "generic_class.h"

message class tpk_MSG1 {
public:     ChareIDType chareid;
     int size;
     int count;
};

message class tpk_MSG2 {
public:
     int *x;
     int size;
     int count;
     ChareIDType chareid;
     
     void *pack(int *length) {

	  int i;
	  int *temp;
	  tpk_MSG1 *out;
	  
//	  *length = sizeof(tpk_MSG1) + sizeof(int) * in->size;

	  out = (tpk_MSG1 *) new_packbuffer((void *)this,
					    sizeof(tpk_MSG1) + sizeof(int) * size);

	  temp = (int *) (out + 1);
	  for (i=0; i<size; i++)
	       temp[i] = x[i];
	  out->size = size;
	  out->count = count;
	  out->chareid = chareid;

	  *length = sizeof (tpk_MSG1) + size * sizeof(int);

	  delete x;

	  return ((void *)out);
     }

     void unpack (void *in) {
	  // Unpack the buffer inside "in" and put it in this->x

	  int i;
	  int *temp;

	  x = new int[((tpk_MSG1 *)in)->size];
	  temp = (int *) (((tpk_MSG1 *)in) + 1); 
	  for (i=0; i<((tpk_MSG1 *)in)->size; i++) {
	       x[i] = temp[i];
	  }
	  size = ((tpk_MSG1 *)in)->size;
	  count = ((tpk_MSG1 *)in)->count;
	  chareid = ((tpk_MSG1 *)in)->chareid;
     }

};

/************************************************************/

chare class tpk_start : public generic_class {

  private:
     ChareIDType chareid;
     int iteration;
     EntryPointType retEP;
     ChareIDType retID;

  entry:
     tpk_start (INIT_MSG *imsg);

     void Quiescence (QuiescenceMessage *dmsg);

};

/************************************************************/

chare class tpk_fib : public generic_class {

  private:
     int top;
     ChareIDType chareid;

  entry:
     tpk_fib (tpk_MSG2 *msg);

     void RESPONSE (tpk_MSG2 *msg);

  private:
     void SendResponseBack(tpk_MSG2 *msg);

};

extern void tpk_initfn();

#endif
