// Hey emacs, this is -*- C++ -*-
#ifndef _sfb_h_
#define _sfb_h_

/* Charm program to find the nth Fibonacci number */
/* Suggested input : n = 10, grainsize = 3        */

#include "messages.h"
#include "megatest++.h"
#include "generic_class.h"
#include "fib.h"

/* In sfb.P
readonly int sfb_grainSize, sfb_topFib;
*/

/************************************************************/

extern void sfb_initfn();

/************************************************************/

message class sfb_ProblemMsg { 
public:     int n;
     ChareIDType parentID;
     int iteration;
     EntryPointType retEP;
     ChareIDType retID;
};

message class sfb_SolutionMsg {
public:     int fib;
};

/************************************************************/

chare class sfb_start : public generic_class {

  public:
     int k;

  entry:
     sfb_start (INIT_MSG *imsg);

};

/************************************************************/

chare class sfb_fib : public generic_class {

  private:
     sfb_fib handle parent;
     int total, count;
     int n ;
     
     int iteration;
     EntryPointType retEP;
     generic_class handle retID;

     void sendResponse(int value);

  entry:
     sfb_fib (sfb_ProblemMsg *msg);

     void Response (sfb_SolutionMsg * msg);

};

/************************************************************/

#endif
