#ifndef _sfb_P_
#define _sfb_P_

#include "sfb.h"
readonly int sfb_grainSize, sfb_topFib;

void sfb_initfn() {

     sfb_topFib = 10;
     sfb_grainSize = 5;

}

/************************************************************/
/************************************************************/
/************************************************************/

sfb_start::sfb_start (INIT_MSG *imsg) {

     sfb_ProblemMsg * pMsg ;
     
     pMsg = new  sfb_ProblemMsg ;
     pMsg->n = sfb_topFib;
     pMsg->iteration = imsg->iteration;
     pMsg->retEP = imsg->retEP;
     pMsg->retID = imsg->retID;
     
     pMsg->parentID = thishandle;
     newchare sfb_fib(pMsg);
     delete imsg ;
}


/************************************************************/
/************************************************************/
/************************************************************/

void
sfb_fib::sendResponse(int value) {

     IT_MSG *imsg;
     
     if ( n == sfb_topFib ) {
	  CPrintf("SFB:The answer is: %d at %d milli-seconds.\n",value,
		  CTimer());
	  imsg = new IT_MSG ;
	  imsg->iteration = iteration;
	  
	  retID=>retEP(imsg);
	  
     }
     else { /*NOTE: This else clause is REQUIRED. See CharmExit in manual*/
	  sfb_SolutionMsg * resp;
	  resp = new  sfb_SolutionMsg ;
	  resp->fib = value;
	  parent=>Response(resp);

//	  SendMsg(fib@Response, resp, &parent);
     }
}

sfb_fib::sfb_fib (sfb_ProblemMsg *msg) {

     int result ;
     sfb_ProblemMsg *pMsg ;
     
     parent = msg->parentID ;
     iteration = msg->iteration;
     retEP = msg->retEP;
     retID = msg->retID;
     
     n = msg->n ;
     if ( n <= sfb_grainSize ) {
	  result = Fib(n) ;
	  sendResponse(result) ;
     }
     else {
	  total = 0 ;
	  count = 2 ;
	  
	  pMsg = new  sfb_ProblemMsg ;
	  pMsg->n = n - 1 ;
	  pMsg->parentID = thishandle;
	  newchare sfb_fib(pMsg);
//	  CreateChare(fib, fib@Compute, pMsg);  
	  
	  pMsg = new  sfb_ProblemMsg ;
	  pMsg->n = n - 2 ;
	  pMsg->parentID = thishandle;
	  newchare sfb_fib(pMsg);
//	  CreateChare(fib, fib@Compute, pMsg);  

     }
     delete msg  ;

}

void
sfb_fib::Response (sfb_SolutionMsg *msg) {

     total += msg->fib;
     if (--count == 0) 
	  sendResponse(total);
     delete msg  ;
}


#endif
