#ifndef _main_P_
#define _main_P_

#include "main.h"

void
main::end_testing (INIT_MSG * initmsg) {

     CPrintf("All tests completed to satisfaction\n");
     delete initmsg ;
     CharmExit(); 
}


main::main() {

     int i;
     IT_MSG * it;
     
     CPrintf("Initializing...\n");
     if(CMaxPeNum() < 1) {
	  CPrintf("This test program should be run on 4 or more PEs.\n");
	  CharmExit(); 
     }

     else {
	  
	  // Initialize the various tests
	  for(i=0;i<last;i++) {
	       switch(i) {
		 case 0: 
		    null_initfn(); break;
		 case 1: 
		    acc_initfn(); break;
		 case 2: 
		    fam_initfn(); break;
		 case 3: 
		    fboc_initfn(); break;
		 case 4: 
		    ftab_initfn(); break;
		 case 5: 
		    hello_initfn(); break;
#if 0
		 case 6: 
		    pgl_initfn(); break;
		 case 7: 
		    rdl_initfn(); break;
#endif
		 case 8: 
		    sfb_initfn(); break;
		 case 9: 
		    tam_initfn(); break;
		 case 10: 
		    tex_initfn(); break;
		 case 11: 
		    tpk_initfn(); break;
		 case 12: 
		    ttab_initfn(); break;
		 case 13: 
		    tvid_initfn(); break;
		 default:
		    break;
	       }
	  }

	  it = new IT_MSG ;
	  it->iteration = 0;

	  CPrintf("Starting Tests...\n");
	  newchare do_all_tests(it);
     }
}


/* Each test module must have an entry point which takes in a message of type
   INIT_MSG, and sends back a reply of type REPLY_MSG 
*/


#endif
