#ifndef _ftab_P_
#define _ftab_P_

#include "ftab.h"
readonly int ftab_grainSize, ftab_topFib;
table fibtbl;

void ftab_initfn()
{
	ftab_topFib = 10;
	ftab_grainSize = 5;
}

ftab_start::ftab_start (INIT_MSG *imsg) {

     ProblemMsg * pMsg ;

     store = imsg;
     
     pMsg = new ProblemMsg ;
     pMsg->n = ftab_topFib;
     pMsg->sendToEp = &(ftab_start::Solution);
     pMsg->parentID = thishandle;
     newchare ftab_fib(pMsg);
}

void
ftab_start::Solution (SolutionMsg * msg) {

     IT_MSG *imsg;
     
     imsg = new IT_MSG ;
     imsg->iteration = store->iteration;
     
     CPrintf("FTAB:The answer is: %d at %d milli-seconds.\n", msg->fib,
	     CTimer());
     generic_class handle h = store->retID;
     EntryPointType ep = store->retEP;
     h=>ep(imsg);

     delete msg ;
     delete store ;
}

/************************************************************/

ftab_fib::ftab_fib (ProblemMsg *msg) {

     ChareIDType myID;

     parent = msg->parentID;     /* struct copy. */
     parentEP = msg->sendToEp;
     n = msg->n; 
     store = 1;
     key = n ;
     myID = thishandle;
     fibtbl.Find(key,&(ftab_fib::TblChecked), myID, TBL_WAIT_AFTER_FIRST);

     delete msg ;
}

void
ftab_fib::TblChecked (TableMessage *msg) {

     ProblemMsg *msg1, *msg2;
     int temp;

     if (msg->data != NULL) {
	  temp = *((int *) msg->data);
	  store = 0;
	  sendResponse(temp);
     }
     else {

	  if (n  < ftab_grainSize) 
	       sendResponse( Fib(n)) ;
	  else {      /* Otherwise, start parallel subcomputations. */

	       total = 0; 
	       count = 2;
	       msg1 =  new  ProblemMsg  ;
	       msg2 =  new  ProblemMsg  ;
	       msg1->n = n-1;      
	       msg1->sendToEp = &(ftab_fib::Response);
	       msg1->parentID = thishandle;
	       newchare ftab_fib(msg1);
               /* fib(n-1,k-1) */
	       msg2->n = n-2; 
	       msg2->parentID = thishandle;
	       msg2->sendToEp = &(ftab_fib::Response);
	       newchare ftab_fib(msg2);
               /* fib(n-k,k) */
	  }
     }

     delete msg ;

}

void
ftab_fib::Response (SolutionMsg * msg) {

     total += msg->fib;
     delete msg ;
     if (--count == 0)
	  sendResponse(total);
}

void
ftab_fib::sendResponse (int value) {

     SolutionMsg * resp;
     resp = new  SolutionMsg ;
     resp->fib = value;
     parent=>parentEP(resp);
//     SendMsg(parentEP, resp, &parent);
     if (store)
	  fibtbl.Insert(key, &value, sizeof(value), NULL_EP, NULL_HANDLE,
			TBL_NOWAITFORDATA);
//	  TblInsert(fibtbl, key, &value, sizeof(value), -1, 
//			  NULL);
}

#endif
