#ifndef _fam_P_
#define _fam_P_

#include "fam.h"
readonly int fam_topFib, fam_grainSize;
readonly ACC1 handle fam_acc1id;
readonly ACC2 handle fam_acc2id;
readonly MONO1 handle fam_mono1id;

ACC1::ACC1 (fam_MSGUP *data) {

     msg = new fam_MSGUP ;
     msg->rspData = 0;
}

void
ACC1::Accumulate() {

     (msg->rspData)++;

}

void
ACC1::Combine(fam_MSGUP *y) {

     msg->rspData += y->rspData;

}

ACC2::ACC2 (fam_MSGUP *data) {

     int i;
     
     msg = new fam_MSG_LEVEL ;
     for (i=0; i<N; i++)
	  msg->counter[i] = 0;
}

void
ACC2::Accumulate (int y) {
     msg->counter[y]++;
}

void
ACC2::Combine (fam_MSG_LEVEL *y) {

     int i;
     for (i=0;i<20;i++)
	  msg->counter[i] += y->counter[i];

}

MONO1::MONO1 (fam_MSGUP *data) {
     msg = new fam_MSGUP ;
     msg->rspData = 0;
}

int
MONO1::Update (fam_MSGUP *y) {

     if (msg->rspData < y->rspData) {
	  
	  msg->rspData = y->rspData;
	  return(1);
	  
     }
     else
	  return(0);	
}     

void fam_initfn () {

     fam_MSGUP	*msg1, *msg2, *msg3;
     
     fam_topFib = 10;
     fam_grainSize = 5;
     
     msg1 = new fam_MSGUP ;
     msg2 = new fam_MSGUP ;
     msg3 = new fam_MSGUP ;
     msg1->rspData = 10;
     fam_acc1id = newaccumulator ACC1(msg1);
     msg2->rspData = 20;
     fam_acc2id = newaccumulator ACC2(msg2);
     msg3->rspData = 30;
     fam_mono1id =  newmonotonic MONO1(msg3);

}

/************************************************************/
/************************************************************/
/************************************************************/

fam_start::fam_start (INIT_MSG *imsg) {

     int   	i;
     int 	data;
     fam_MSG1 	*pMsg;
     ChareIDType mainid;
     
     store = imsg;
     
     pMsg  = new fam_MSG1 ;
     pMsg->fibNum = fam_topFib;  
     pMsg->level = 0;
     pMsg->parentID = thishandle;
     newchare fam_fib(pMsg);
     
     mainid = thishandle;
     CStartQuiescence(&(fam_start::Quiescence), mainid);
}

void
fam_start::Quiescence (QuiescenceMessage *msg) {

     IT_MSG *imsg;
     
     imsg = new IT_MSG ;
     imsg->iteration = store->iteration;
     
     CPrintf("FAM:Quiesence: Time = %d\n",CTimer());
     CPrintf("FAM:Quiescence Detected.\n");
     CPrintf("FAM:Value of bound is %d\n", 
	     ((fam_MSGUP *) fam_mono1id->MonoValue())->rspData);
     
     generic_class handle h = store->retID;
     EntryPointType ep = store->retEP;
     h=>ep(imsg);

     delete msg ;
     delete store ;
}

void
fam_start::MAINEP1 (fam_MSGUP *m) {

     CPrintf("FAM:Main ep message received.\n");
     CPrintf("FAM:Result = %d\n", m->rspData);
     CPrintf("FAM:*************************************************\n");
     CPrintf("FAM:\t\tTime Elapsed in milliseconds is %d\n",CTimer());
     CPrintf("FAM:*************************************************\n");
     delete m ;
}

void
fam_start::MAINEP2 (fam_MSG_LEVEL *msg) {

     int 	i;
     
     for (i=0; i<N;i++)
	  if (msg->counter[i] >0)
	       CPrintf("FAM:Number of nodes at level %d = %d\n", i,
		       msg->counter[i]);
     CPrintf("FAM:MAINEP2: Time = %d\n", CTimer());
     delete msg ;
}

void
fam_start::MAINEP3 (fam_MSGUP *msg) {

     CPrintf("FAM:Total number of nodes = %d\n", msg->rspData);
     CPrintf("FAM:Value of bound is %d\n", 
	     ((fam_MSGUP *) fam_mono1id->MonoValue())->rspData);
     CPrintf("FAM:MAINEP3: Time = %d\n", CTimer());
     delete msg ;
} 

fam_fib::fam_fib (fam_MSG1 *msg1P) {

     int 	n,i, fibVal;
     fam_MSG1	*ptr1;
     fam_MSGUP	*ptr2;
     fam_MSGUP   *monomsg;
     int 	temp;

     n = msg1P->fibNum;
     fibNum = n;
     
     fam_acc1id->Accumulate();
     fam_acc2id->Accumulate(msg1P->level);
     
     temp = fam_topFib - n;
     monomsg = new fam_MSGUP ;
     monomsg->rspData = temp;
     fam_mono1id->Update(monomsg);
     delete monomsg ;
     
     isFinal = ( msg1P->fibNum == fam_topFib ) ? TRUE : FALSE;
     parentID = msg1P->parentID;
     if (msg1P->fibNum <= fam_grainSize)
     { 
	  ptr2 = new fam_MSGUP ;
	  fibVal = Fib(n);
	  delete msg1P ;
	  fam_ProcessResult(isFinal, &parentID, fibVal, ptr2);
     }
     else 
     {
	  rspNum= 2;
	  rspData= 0;
	  ptr1 = new fam_MSG1 ;
	  ptr1->fibNum = n-1;
	  ptr1->level = msg1P->level + 1;
	  ptr1->parentID = thishandle;
	  msg1P->fibNum = n-2;
	  msg1P->level++;
	  msg1P->parentID = thishandle;
	  newchare fam_fib(ptr1);
	  newchare fam_fib(msg1P);
     }
}

void
fam_fib::RESPONSE (fam_MSGUP *msg2P) {

     rspNum--;
     rspData += msg2P->rspData;
     if (rspNum == 0) 
	  fam_ProcessResult(isFinal, &parentID,  rspData, msg2P);
     else
	  delete msg2P ;
}

/************************************************************/
/************************************************************/
/************************************************************/

void
fam_ProcessResult(int top, ChareIDType *CID, int value, fam_MSGUP *msg) {

     if (top)  
     {
	  fam_start handle h = *CID;

	  msg->rspData = value;
	  h=>MAINEP1(msg);

	  fam_acc1id->CollectValue(&(fam_start::MAINEP3), *CID);
	  fam_acc2id->CollectValue(&(fam_start::MAINEP2), *CID);
     }
     else
     {
	  msg->rspData = value;
	  
	  fam_fib handle h = *CID;
	  h=>RESPONSE(msg);
     }
}

#endif
