/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: pgm.p,v $
 *	$Author: jyelon $	$Locker:  $		$State: Exp $
 *	$Revision: 1.2 $	$Date: 1995/11/10 12:49:48 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: pgm.p,v $
 * Revision 1.2  1995/11/10 12:49:48  jyelon
 * removed header files.
 *
 ***************************************************************************/

module Nqueens {
  
#define Nmax 20
  
readonly int grain, N;
readonly AccIDType solutionCount;
readonly ChareNumType bocId;

message { 
  int nextRow;
  int Queens[Nmax];  
} PartialBoard;
message {
  int junk;
} DUMMYMSG;
message {
  int value;
} SINGLE_INT_MSG;

accumulator {
  
  SINGLE_INT_MSG *count;
  
  SINGLE_INT_MSG * initfn (data)
    DUMMYMSG *data;
  {  
    count = (SINGLE_INT_MSG *) CkAllocMsg(SINGLE_INT_MSG);
    count->value = 0;
    return(count);   
  }
  
  addfn (m)
    int m;
  { 
    count->value += m; 
  }
  
  combinefn (y)
    SINGLE_INT_MSG *y;
  { 
    count->value += y->value;
  }
}  AccIntPlus;

chare main {
  int t0; /* starting time */
  entry CharmInit:
  { 
    PartialBoard * pMsg ;
    DUMMYMSG *m, *m1;
    ChareIDType mainid;
    
    CkPrintf("Enter n: ");
    CkScanf("%d", &N);
    ReadInit(N);
    CkPrintf("Enter grain-size: ");
    CkScanf("%d", &grain);
    ReadInit(grain); 
    m = (DUMMYMSG *) CkAllocMsg(DUMMYMSG);
    solutionCount = CreateAcc(AccIntPlus, m);
    m1 = (DUMMYMSG *) CkAllocMsg(DUMMYMSG);
    bocId = CreateBoc(recordProgress, recordProgress@InitRecord, m1);
    ReadInit(bocId);
    pMsg = (PartialBoard *) CkAllocPrioMsg(PartialBoard,0);
    CkSetQueueing(pMsg, CK_QUEUEING_BFIFO);
    pMsg->nextRow = 0;
    
    CreateChare(queens, queens@NewBoard, pMsg);  
    t0 = CkTimer();
    
    MyChareID(&mainid);
    StartQuiescence(Quiescence1, &mainid);
  }
  
  entry Quiescence1: (message DUMMYMSG *msg) 
    { 
      ChareIDType cid;
      MainChareID(&cid);
      CollectValue(  ReadValue(solutionCount), main@RcvCount, &cid); 
    }
  
  entry RcvCount: (message SINGLE_INT_MSG *finalCount)
    { 
      CkPrintf("The total number of solutions to %d queens is: %d, at time=%d\n", 
	       ReadValue(N), finalCount->value, CkTimer()-t0);
      CkExit();
    }
}

BranchOffice recordProgress {
  int count;

  entry InitRecord: (message DUMMYMSG *m) { 
    count = 0; 
  }
  public processedOne() { 
    count++;
  }
}

chare queens {
  /* No local variables */
  entry NewBoard: (message PartialBoard *m)
    { 
      int col,i, row;
      PartialBoard * newMsg;
      static int seqQueens();
      static int consistent();
      
      row = m->nextRow;  
      BranchCall(ReadValue(bocId), recordProgress@processedOne());
      if (row == ReadValue(N)) 
	Accumulate( ReadValue(solutionCount), addfn(1));
      else if ( (ReadValue(N)-row) < ReadValue(grain)) 
	seqQueens(m->Queens, row); 
      else
	for (col = 0; col<ReadValue(N); col++) 
	  if (consistent(m->Queens, row, col)) {
	    newMsg = (PartialBoard *) CkAllocPrioMsg(PartialBoard, CkPrioSizeBits(m)+3);
	    CkSetQueueing(newMsg, CK_QUEUEING_BFIFO);
	    
	    CkPrioConcat(m, newMsg, 4*(col%2)+(col/2));
	    newMsg->nextRow = row + 1;
	    for (i=0; i<ReadValue(N); i++)
	      newMsg->Queens[i] = m->Queens[i];
	    newMsg->Queens[row] = col;
	    CreateChare(queens, queens@NewBoard, newMsg);  
	  }
      CkFreeMsg(m); 
      ChareExit(); 
    }
}

seqQueens(queens, nextRow)
int queens[], nextRow;
{ 
  int col;
  static int consistent();
  
  if (nextRow == ReadValue(N)) 
    { 
      printSolution(queens);
      Accumulate( ReadValue(solutionCount), addfn(1)); 
      return; 
    }
  for (col = 0; col<ReadValue(N); col++) 
    if (consistent(queens, nextRow, col)) {
      queens[nextRow] = col;
      seqQueens(queens, nextRow+1);
    }
}

int consistent(queens, lastRow, col)
int queens[], lastRow, col;
{ 
  /* check if the new queen is safe from each of the previously placed queens */
  int x,y;
  for (x=0; x<lastRow; x++)
    { 
      y = queens[x];
      if ((y==col)  || ((lastRow-x) == (col-y)) || ((lastRow-x) == (y-col)) )
	return(0);
    }
  return(1);
}

printSolution(queens)
int queens[];
{ 
  int row;
  char buf[80], tmp[80];
  
  buf[0] = '\0';
  for (row=0; row<N; row++)
    { 
      sprintf(tmp, "(%d,%d) ", row, queens[row]);
      strcat(buf, tmp);
    }
  CkPrintf("%s\n", buf);
}

}

