/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: pgm.p,v $
 *	$Author: jyelon $	$Locker:  $		$State: Exp $
 *	$Revision: 2.2 $	$Date: 1995/10/27 09:09:31 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: pgm.p,v $
 * Revision 2.2  1995/10/27 09:09:31  jyelon
 * *** empty log message ***
 *
 * Revision 2.1  1995/06/15  18:17:17  jyelon
 * *** empty log message ***
 *
 * Revision 2.0  1995/06/01  21:13:24  brunner
 * Reorganized directory structure
 *
 * Revision 1.1  1994/10/14  22:00:03  brunner
 * Initial revision
 *
 ***************************************************************************/

module TSP {

#include "qd.h"

#define Max 50
#define MaxSquare (Max*Max)/30
#define INFINITY 999999		/* indicates to edge present	*/
#define SMALL	-999999		/* very small			*/
#define RANDOM_BOUND 200	/* limit on weight of edges	*/
#define ROUTINE1 1
#define ROUTINE2 2
#define TRUE 1
#define FALSE 0

#define IsFree(a,ind)  !( (a[(ind/32)]) & (1<<(ind % 32)) )
#define Set(a,ind) a[(ind/32)] = ( a[(ind/32)] | (1<<(ind % 32)) )
#define Reset(a,ind) a[(ind/32)] = ( a[(ind/32)] & (~(1<<(ind % 32))) )

#define DETERMINE_MATRIX determine_matrix0
#define BRANCH_OUT branch_out0
#define SOLVE_RELAXATION reduce_matrix

message {
	int cost;
	unsigned int isDefined[MaxSquare];
	unsigned int in[MaxSquare];
} MSG1;

message {
	int cost;
	int cycle[Max];
} SolnMsg;

readonly int N;			/* number of rows and columns	*/
readonly int matrix[Max][Max];	/* initial cost matrix		*/ 

message {
	int nodes;
} ACC_MSG;

accumulator { 

	ACC_MSG *msg;

	/****************************************************************/
	/* This is the initialization function.				*/
	/****************************************************************/

	ACC_MSG * initfn(data)
	ACC_MSG *data;
	{
		msg = (ACC_MSG *) CkAllocMsg(ACC_MSG);
		msg->nodes = data->nodes;
		return(msg);

	}

	/****************************************************************/
	/* This is the increment function for the accumulator that 	*/
	/* will count the number of nodes in the tree.			*/
	/****************************************************************/

	addfn () 
	{
		(msg->nodes)++;
	}


	/****************************************************************/
	/* This is the combine function for the accumulator.		*/ 
	/****************************************************************/
	
	combinefn(b)
	ACC_MSG *b;
	{
		(msg->nodes) += (b->nodes);
	}

} ACC_INT;			/* counts number of nodes 	*/



message {
	int bound;
} MONO_MSG;

monotonic {
	
	MONO_MSG *msg;

	/****************************************************************/
	/* This is the initfn.						*/
	/****************************************************************/

	MONO_MSG * initfn(data)
	MONO_MSG *data;
	{
		msg = (MONO_MSG *) CkAllocMsg(MONO_MSG);
		msg->bound = data->bound;
		return(msg);
	}


	/****************************************************************/
	/* This is the comparison function for the monotonic variable.	*/
	/****************************************************************/
	
	updatefn(new)
	MONO_MSG *new;
	{
		if (msg->bound > new->bound)
		{
			msg->bound = new->bound;
			return(1);
		}
		return(0);
	}
} MONO_INT ;			/* the current bound on solution*/
				/* in the tree.			*/


readonly int acc_nodes;
readonly int mono_bound;

chare main {

	int cost;
	int temp[Max][Max];
	ChareIDType chareid;
	int temp1[Max], temp2[Max];

	entry CharmInit: 
	{
		int *x;
		int i, j;
		int index;
		MSG1 *msg;
		ACC_MSG *acc_msg;
		int choice, upper;
		MONO_MSG *mono_msg;
		static int read_in_matrix();
                static int reduce_matrix();


     	CkScanf("%d", &N);
		CkPrintf("The number of cities are : %d\n", N);
		ReadInit(N);
		CkScanf("%d", &choice); 
		CkScanf("%d", &upper);

     	read_in_matrix(matrix, N); 	
		cost = reduce_matrix(matrix, temp, N, temp1, temp2);

		acc_msg = (ACC_MSG *) CkAllocMsg(ACC_MSG);
		mono_msg = (MONO_MSG *) CkAllocMsg(MONO_MSG);

		if (choice)
			mono_msg->bound = upper;
		else
			mono_msg->bound = INFINITY;

		acc_msg->nodes = 0;

		mono_bound = CreateMono(MONO_INT, mono_msg);
		ReadInit(mono_bound);
		acc_nodes =  CreateAcc(ACC_INT, acc_msg);
		ReadInit(acc_nodes);
		ReadInit(matrix); 

		msg = (MSG1 *) CkAllocPrioMsg(MSG1, CK_INT_BITS);
		CkSetQueueing(msg, CK_QUEUEING_IFIFO);
		x = (int *)CkPrioPtr(msg);
		*x = cost;

		msg->cost = cost;
		for (i=0; i<N; i++)
			for (j=0; j<N; j++)
			{
				index = i*N + j;
				Reset(msg->isDefined, index);
				Reset(msg->in, index);

			}
		CreateChare(start, start@LEAF, msg);
		MyChareID(&chareid);
		StartQuiescence(Quiescence, &chareid);
	}


	entry Quiescence: (message QUIESCENCE_MSG *dmsg) 
	{
		ChareIDType chareid;

		CkPrintf("Totalling number of nodes in the tree.\n");
		MyChareID(&chareid);
		CollectValue(ReadValue(acc_nodes), MAINEP1, &chareid);
	}

	entry MAINEP1 : (message ACC_MSG * msg)
	{
		CkPrintf("Total number of nodes in the tree = %d\n",
				msg->nodes);

		CkPrintf("---------------------------------------------------------------\n");
		CkExit();
	}

	entry RECEIVE : (message SolnMsg *msg)
	{
		int i, j;
		MONO_MSG *tmsg;

		if (msg->cost <= ((MONO_MSG *) MonoValue(mono_bound))->bound)
		{
			tmsg = (MONO_MSG *) CkAllocMsg(MONO_MSG);
			tmsg->bound = msg->cost;
			NewValue(mono_bound, updatefn(tmsg));

			CkPrintf("New Tour of cost %d found at time %d :\n\n\t",
					msg->cost, CkTimer());
			for (i=0; i<N; i++)
				CkPrintf("%2d->", msg->cycle[i]);
			CkPrintf("%2d\n", msg->cycle[0]);
		}	
		CkFreeMsg(msg);
	}
}
	

chare start {

	entry LEAF : (message MSG1 *msg)
	{
		int *x;
		int n;
		int cost;
		MONO_MSG *tmsg;
		int A[Max][Max];
		int soln[Max][Max];
		int rows[Max], columns[Max];
		static int reduce_matrix();
		static int determine_matrix0();
		static int branch_out0();
		static int isSolution();
		static int printout_new_solution();


		n = ReadValue(N);
		DETERMINE_MATRIX(msg, ReadValue(matrix), A, n);
		cost = SOLVE_RELAXATION(A, soln, n, rows, columns);
		cost += msg->cost;
/* CkPrintf("[%d] LEAF: cost=%d, bound=%d\n",
McMyPeNum(), cost, ((MONO_MSG *) MonoValue(mono_bound))->bound); */

		if (cost < ((MONO_MSG *) MonoValue(mono_bound))->bound)
			if (isSolution(msg, soln, n))
			{
				tmsg = (MONO_MSG *)  CkAllocMsg(MONO_MSG);
				tmsg->bound = cost;
				NewValue(mono_bound,
					updatefn(tmsg));
				printout_new_solution(soln, n);
			}
			else
			{
				/*
				upper = find_upper_bound();
			   	remove_arcs(A, upper); 
				*/
				BRANCH_OUT(msg, A, n, cost, rows, columns);
			}
		CkFreeMsg(msg);
		ChareExit();
	}
}

/****************************************************************/
/* This function reads in the initial cost matrix.		*/
/****************************************************************/

read_in_matrix(A, n)
int A[Max][Max];
int n;
{
	int i, j;

	for (i=0; i<n; i++)
		for (j=0; j<n; j++)
		{
			CkScanf("%d", &A[i][j]); 
			/* A[i][j] = rand() % RANDOM_BOUND; */ 
		}
	for (i=0; i<n; i++)
		A[i][i] = INFINITY;
}



/****************************************************************/
/* This function prints out a solution. Since the monotonic	*/
/* variable does not guarantee the global best on every node 	*/
/* the solution found may not necessarily be the best.		*/
/****************************************************************/

printout_new_solution(soln , n)
int soln[Max][Max];
int n;
{
	int *x;
	int i, j;
	int next; 
	int index = 0;
	SolnMsg *msg;
	ChareIDType chareid;

	msg = (SolnMsg *) CkAllocPrioMsg(SolnMsg, CK_INT_BITS);
	CkSetQueueing(msg, CK_QUEUEING_IFIFO);
	x = (int *) CkPrioPtr(msg);
	*x = 0;
	msg->cost = ((MONO_MSG *) MonoValue(mono_bound))->bound;
	MainChareID(&chareid);
	for (i=0; i<n; i++)
		if (soln[0][i] == 1)
			break;

	msg->cycle[index++] = 0;
	next = i;
	while (next != 0)
	{
		msg->cycle[index++] = next;
		for (j=0; j<n; j++)
			if (soln[next][j])
			{
				next = j;
				break;
			}
	}
	SendMsg(main@RECEIVE, msg, &chareid);
}


/****************************************************************/
/* This function reduces the cost matrix to a non-negative 	*/
/* matrix. We use this to fire off the computations, and also	*/
/* to determine the first reasonable lower bound.		*/
/****************************************************************/

reduce_matrix(A, soln, n, rows, columns)
int A[Max][Max];
int soln[Max][Max];
int n;
int rows[Max], columns[Max];
{
	int i,j;
	int lowest;
	int cost = 0;

	for (i=0; i<n; i++)
	{
		lowest = INFINITY;
		for (j=0; j<n; j++)
			if (A[i][j] < lowest)
				lowest = A[i][j];

		if (lowest != INFINITY)
		{
			for (j=0; j<n; j++)
				if (A[i][j] != INFINITY)
					A[i][j] -= lowest;
			cost += lowest;	
		}
		rows[i] = lowest;
	}

	for (j=0; j<n; j++)
	{
		lowest = INFINITY;
		for (i=0; i<n; i++)
			if (A[i][j] < lowest)
				lowest = A[i][j];

		if (lowest != INFINITY)
		{
			for (i=0; i<n; i++)
				if (A[i][j] != INFINITY)
					A[i][j] -= lowest;
			cost += lowest;
		}
		columns[j] = lowest;
	}
	for (i=0; i<n; i++)
		for (j=0; j<n; j++)
			soln[i][j] = 0;
	return(cost);
}



/****************************************************************/
/* This function determines whether the solution to the 	*/
/* assignment problem is also a solution to the traveling 	*/
/* salesman problem.						*/
/****************************************************************/

isSolution(msg, soln, n)
MSG1 *msg;
int soln[Max][Max];
int n;
{
	int x, y;
	int i, j;
	int next;
	int index;
	int length = 0;
	int cycle_start, cycle_end;
	static int get_cycle_edge();

	for (i=0; i<n; i++)
		for (j=0; j<n; j++)
		{
			index = i*n + j;
			if (!IsFree(msg->in, index))
			{
				x = i;
				y = j;
				soln[i][j] = 1;
				length++;
			}
		}

	if (length != n - 1)
		return(0);

	get_cycle_edge(msg, x, y, n, &cycle_start, &cycle_end);
	soln[cycle_end][cycle_start] = 1;
	return(1);
}



/****************************************************************/
/* This function gets  for the sub-branch that edge which	*/
/* could contribute to a cycle.					*/
/****************************************************************/

get_cycle_edge(msg, v1, v2, n, cycle_start, cycle_end)
MSG1 *msg;
int v1, v2;
int n;
int *cycle_start;
int *cycle_end;
{
	int i;
	int index;
	int end = v2;
	int start = v1;
	int done = FALSE;

	while (!done)
	{
		for (i=0; i<n; i++)
		{
			index = end*n + i;
			if (!IsFree(msg->in, index))
			{
				end = i;
				break;
			}
		}
		if (i==n)
			done = TRUE;
	}

	*cycle_end = end;
	done = FALSE;

	while (!done)
	{
		for (i=0; i<n; i++)
		{
			index = i*n + start;
			if (!IsFree(msg->in, index))
			{
				start = i;
				break;
			}
		}
		if (i==n)
			done = TRUE;
	}
	*cycle_start = start;
}



/****************************************************************/
/* This function returns the index of the least element in the	*/
/* row.								*/
/****************************************************************/

least_in_row(A, row, n)
int A[Max][Max];
int row, n;
{
	int j;
	int least = INFINITY;

	for (j=0; j<n; j++)
		if (least > A[row][j])
			least = A[row][j];
	return(least);
}


/****************************************************************/
/* This function returns the index of the least element in the	*/
/* column.							*/
/****************************************************************/

least_in_col(A, col, n)
int A[Max][Max];
int col, n;
{
	int i;
	int least = INFINITY;

	for (i=0; i<n; i++)
		if (least > A[i][col])
			least = A[i][col];
	return(least);
}

/****************************************************************/
/* This function determines the best zero according to the 	*/
/* criterion established in the book by Reingold.		*/
/****************************************************************/

find_best_zero(A, n, best_i, best_j)
int A[Max][Max];
int n;
int *best_i, *best_j;
{
	int temp;
	int store;
	int i, j, k;
	int best = SMALL;

	for (i=0; i<n; i++)
		for (j=0; j<n; j++)
		{
			temp = 0;
			if (A[i][j] == 0)
			{
				store = A[i][j];
				A[i][j] = INFINITY;
				temp = least_in_row(A, i, n);
				temp += least_in_col(A, j, n);
				A[i][j] = store;
				if (temp > best)
				{
					best = temp;
					*best_i = i;
					*best_j = j;
				}
			}
		}
	return(best);
}


/****************************************************************/
/* This is the trivial branching out procedure. It determines 	*/
/* the best node in the relaxation problem and then branches 	*/
/* out on in a binary fashion with one branch excluding the	*/
/* edge and the other including the edge.			*/
/****************************************************************/

branch_out0(msg, A, n, cost, rows, columns)
MSG1 *msg;
int A[Max][Max];
int n;
int cost;
int rows[Max], columns[Max];
{
	int *x;
	int i,j;
	int temp;
	int best;
	int index;
	MSG1 *msg1, *msg2;
	int best_i, best_j;
	int cycle_start, cycle_end;
	int temp1[Max], temp2[Max], temp3[Max][Max];
	static int reduce_matrix();
	
	best_i = best_j = (-1);
	best = find_best_zero(A, n, &best_i, &best_j);
	if (best_i != -1)
	{
		msg1 = (MSG1 *) CkAllocPrioMsg(MSG1, CK_INT_BITS);
		msg2 = (MSG1 *) CkAllocPrioMsg(MSG1, CK_INT_BITS);
		CkSetQueueing(msg1, CK_QUEUEING_IFIFO);
		CkSetQueueing(msg2, CK_QUEUEING_IFIFO);
		msg1->cost = msg2->cost = msg->cost;
	
		for (i=0; i<n; i++)
			for (j=0; j<n; j++)
			{
				index = i*n + j;
				if (IsFree(msg->isDefined, index))
				{
					Reset(msg1->isDefined, index);
				 	Reset(msg2->isDefined, index);
				}
				else
				{
					Set(msg1->isDefined, index);
				 	Set(msg2->isDefined, index);
				}
				if (IsFree(msg->in, index))
				{
					Reset(msg1->in, index);
				 	Reset(msg2->in, index);
				}
				else
				{
					Set(msg1->in, index);
				 	Set(msg2->in, index);
				}
			}	

		index = best_i*n + best_j;
		if ( (cost < ((MONO_MSG *) MonoValue(mono_bound))->bound &&
		     	(best >= INFINITY)) ||
		     (cost + best <
			((MONO_MSG *) MonoValue(mono_bound))->bound))
		{
			Set(msg1->isDefined, index);
			Reset(msg1->in, index); 

			A[best_i][best_j] = INFINITY;
			if (least_in_row(A, best_i, n) == INFINITY)
				if (rows[best_i] < INFINITY)
					msg1->cost += rows[best_i];
			if (least_in_col(A, best_j, n) == INFINITY)
				if (columns[best_j] < INFINITY)
					msg1->cost += columns[best_j];

			x = (int *) CkPrioPtr(msg1);
			*x = cost + best;
			A[best_i][best_j] = 0;

			CreateChare(start, start@LEAF, msg1);
			Accumulate(acc_nodes, addfn());
		}

		/* include best edge, and exclude its symmetric partner */
		if (rows[best_i] < INFINITY)
			msg2->cost += rows[best_i];
		if (columns[best_j] < INFINITY)
			msg2->cost += columns[best_j];
		Set(msg2->isDefined, index);
		Set(msg2->in, index);
		index = best_j*n + best_i;
		Set(msg2->isDefined, index);
		Reset(msg2->in, index);
	
		temp = A[best_j][best_i];
		A[best_j][best_i] = INFINITY;
		if (least_in_row(A, best_j, n) == INFINITY)
			if (rows[best_j] < INFINITY)
				msg2->cost += rows[best_j];
		if (least_in_col(A, best_i, n) == INFINITY)
			if (columns[best_i] < INFINITY)
				msg2->cost += columns[best_i];
		A[best_j][best_i] = temp;
	
		/* Get the edge that completes the cycle and exclude it. */
		get_cycle_edge(msg2, best_i, best_j, n,
				&cycle_start, &cycle_end);
		index = cycle_end*n + cycle_start;
		Set(msg2->isDefined, index);
		Reset(msg2->in, index);
		temp = A[cycle_end][cycle_start];
		A[cycle_end][cycle_start] = INFINITY;
		if (least_in_row(A, cycle_end, n) == INFINITY)
			if (rows[cycle_end] < INFINITY)
				msg2->cost += rows[cycle_end];
		if (least_in_col(A, cycle_start, n) == INFINITY)
			if (columns[cycle_start] < INFINITY)
				msg2->cost += columns[cycle_start];
		A[cycle_end][cycle_start] = temp;

		A[best_j][best_i] = A[cycle_end][cycle_start] = INFINITY;
		for (i=0; i<n; i++)
			A[best_i][i] = A[i][best_j] = INFINITY;
		x = (int *) CkPrioPtr(msg2);
		*x = SOLVE_RELAXATION(A, temp3, n, temp1, temp2) +
			cost;

		CreateChare(start, start@LEAF, msg2);
		Accumulate(acc_nodes, addfn());
	}
}


/****************************************************************/
/* This function determines the updated cost matrix after 	*/
/* looking at the edges excluded and included in this branch.	*/
/****************************************************************/

determine_matrix0(msg, matrix, A, n)
MSG1 *msg;
int matrix[Max][Max];
int A[Max][Max];
int n;
{
	int index;
	int i, j, k;

	for (i=0; i<n; i++)
		for (j=0; j<n; j++)
			A[i][j] = matrix[i][j];
	for (i=0; i<n; i++)
		for (j=0; j<n; j++)
		{
			index = i*n +j;
			if (!IsFree(msg->isDefined, index))	
				if (!IsFree(msg->in, index))
				{
					for (k=0; k<n; k++)
						A[k][j] = INFINITY;
					for (k=0; k<n; k++)
						A[i][k] = INFINITY;
					A[j][i] = INFINITY;
				}
				else
					A[i][j] = INFINITY;

		}
}
}
