/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: shared.h,v $
 *	$Author: jyelon $	$Locker:  $		$State: Exp $
 *	$Revision: 1.2 $	$Date: 1995/02/24 23:25:52 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: shared.h,v $
 * Revision 1.2  1995/02/24 23:25:52  jyelon
 * *** empty log message ***
 *
 ***************************************************************************/
#define MAX_HASH_KEYS 1009

#define STAGE_BY_STAGE_ANALYSIS 1
#define SUMMARY_ANALYSIS 2

#define HAVE_NO_PROBLEM 0
#define HAVE_PROBLEM 1

#define MAXSTRING 200
#define MAX_PROBLEMS 35

#define CHARMINIT_NOPROBLEM         0
#define CHARMINIT_PROBLEM           1
#define BRANCHINIT_PROBLEM          2
#define FINE_GRAIN_PROBLEM          3
#define COARSE_GRAIN_PROBLEM        4
#define LOAD_BALANCE_PROBLEM        5
#define LOG_FILE_PROBLEM            6
#define LDB_INTERFERENCE         	7
#define QD_INTERFERENCE         	8
#define SYSTEM_INTERFERENCE         9
#define OVERHEAD_IMBALANCE          10
#define BOC_IMBALANCE               11
#define CHARE_IMBALANCE             12
#define FORCHARE_IMBALANCE          13
#define GRAIN_IMBALANCE             14
#define TAIL_END_MESSAGE			15
#define WAIT_PROBLEM				16
#define WAIT_BOC_IMBALANCE          17
#define WAIT_CHARE_IMBALANCE        18
#define WAIT_FORCHARE_IMBALANCE     19
#define WAIT_GRAIN_IMBALANCE        20
#define WAIT_OVERHEAD_IMBALANCE     21
#define POSSIBLE_BOTTLENECK_PROBLEM 22
#define BOTTLENECK_PROBLEM			23
#define SEQUENTIAL_CHAIN_PROBLEM	24
#define PIPELINING_PROBLEM			25
#define UNNECESSARY_LDB				26
#define LOW_PARALLELISM				27
#define POOR_LDB					28


#define NUMBER_PATTERNS 8
#define BOTTLENECK 		0
#define SPANTREE 		1
#define EXCHANGE 		2
#define CYCLIC 			3
#define CHAIN 			4
#define SEQCHAIN 		5
#define REDUCTION 		6
#define BROADCAST 		7

typedef struct _key_entry {
    int key;
    int location;
    int *inserts, *deletes, *finds;
    struct _key_entry *next;
} KEY_ENTRY;

#define problem(i, s) strcpy(problem_list[i], s)
#define IsNewChareMsg(t) (t->info->msg_type==NewChareMsg &&  \
		t->type==END_PROCESSING)
#define IsUserBocMsg(t) (t->info->msg_type==BocMsg && \
		t->type==END_PROCESSING \
        && (get_ep_index(t->info->ep, t->info->msg_type) != -1))

#define IsSystemBocMsg(t) (get_ep_index(t->info->ep, t->info->msg_type) == -1)

#define IsLdbMsg(t) (t->info->msg_type==LdbMsg) 
#define IsQdMsg(t) \
	(t->info->msg_type==QdBocMsg || t->info->msg_type==QdBroadcastBocMsg) 

#define KeyHash(key) (1013*key % MAX_HASH_KEYS)


extern int TotalPseudos;

#ifdef SHARED

int evaluate_ldb=0;
int problem_type=-1;
int problem_stage=-1;

unsigned int local_problem_benefit[MAX_PROBLEMS];
unsigned int global_problem_benefit[MAX_PROBLEMS];

int this_table;
int **patterns;
int type_of_analysis;
char temp_string[1000];
KEY_ENTRY *hash_keys[MAX_HASH_KEYS];

char problem_encountered[MAX_PROBLEMS];
char problem_list[MAX_PROBLEMS][MAXSTRING];

TRANSACTION_LIST *critical_list, *sync_list;

unsigned int total_time, wait_time;
unsigned int compute_time, communicate_time, delay_time, qd_time;

int *critical_entries, *other_entries;



int 	**patterns;
char 	*branchinit_entries;
char 	*fine_grain_problem;
char	*both_large_and_tail;
char 	*tail_end_entries, *large_ep, *seq_chain_entries, *bottleneck_entries;
char 	*crime_sheet, *global_crime_sheet;
char 	*boc_entries, *chare_entries, *forchare_entries;
int 	*charesp, *forcharesp, *bocsp, *alltotal, **totalp, **numberp, **grainp;
char 	*grain_imbalance, *chare_imbalance, *forchare_imbalance, *boc_imbalance;
char 	*wait_grain_imbalance, *wait_chare_imbalance,
		*wait_forchare_imbalance, *wait_boc_imbalance;
int 	*wait_tail_benefit, *wait_pipe_benefit;

char 	*global_seq_chain_entries, *global_bottleneck_entries;
char	*global_both_large_and_tail;
char 	*global_branchinit_entries, *global_tail_end_entries,
    	*global_large_ep, *global_fine_grain_problem, *global_grain_imbalance,
    	*global_chare_imbalance, *global_forchare_imbalance,
    	*global_boc_imbalance, *global_crime_sheet, *global_totalp,
    	*global_numberp, *global_grainp;

int 	*global_alltotal;
char 	**global_status;

char 	*global_wait_grain_imbalance, *global_wait_chare_imbalance,
		*global_wait_forchare_imbalance, *global_wait_boc_imbalance;


int execution_total, *execution_total_idx;
int severe_ldb_interference, severe_qd_interference;


#else

extern int problem_type;
extern int problem_stage;
extern TRANSACTION_LIST *critical_list, *sync_list;

extern int evaluate_ldb;

extern int global_problem_benefit[];
extern int local_problem_benefit[];

extern int this_table;
extern int **patterns;
extern int type_of_analysis;
extern char temp_string[1000];
extern KEY_ENTRY *hash_keys[MAX_HASH_KEYS];
extern char problem_encountered[MAX_PROBLEMS];
extern char problem_list[MAX_PROBLEMS][MAXSTRING];
extern unsigned int total_time, wait_time;
extern unsigned int compute_time, communicate_time, delay_time, qd_time;

extern int *critical_entries, *other_entries;

extern int 	**patterns;
extern char *branchinit_entries;
extern char *fine_grain_problem;
extern char *tail_end_entries, *large_ep,
			*seq_chain_entries, *bottleneck_entries;
extern char *crime_sheet, *global_crime_sheet;
extern char *boc_entries, *chare_entries, *forchare_entries;
extern int 	*charesp, *forcharesp, *bocsp, *alltotal, **totalp,
			**numberp, **grainp;
extern char *grain_imbalance, *chare_imbalance, *forchare_imbalance,
			*boc_imbalance;
extern char *wait_grain_imbalance, *wait_chare_imbalance,
			*wait_forchare_imbalance, *wait_boc_imbalance;
extern int 	*wait_tail_benefit, *wait_pipe_benefit;

extern char	*global_both_large_and_tail;
extern char	*both_large_and_tail;

extern char *global_seq_chain_entries, *global_bottleneck_entries;
extern char	*global_branchinit_entries, *global_tail_end_entries,
    		*global_large_ep, *global_fine_grain_problem,
			*global_grain_imbalance, *global_chare_imbalance,
			*global_forchare_imbalance, *global_boc_imbalance, 
			*global_crime_sheet;

extern int *global_alltotal;
extern char 	**global_status;

extern char *global_wait_grain_imbalance, *global_wait_chare_imbalance,
			*global_wait_forchare_imbalance, *global_wait_boc_imbalance;


extern 		int execution_total, *execution_total_idx;
extern int severe_ldb_interference, severe_qd_interference;

#endif



