/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: data.h,v $
 *	$Author: sanjeev $	$Locker:  $		$State: Exp $
 *	$Revision: 1.3 $	$Date: 1995/09/21 21:07:55 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: data.h,v $
 * Revision 1.3  1995/09/21 21:07:55  sanjeev
 * *** empty log message ***
 *
 * Revision 1.2  1995/02/24  23:25:52  jyelon
 * *** empty log message ***
 *
 ***************************************************************************/
#ifndef NULL
#define NULL 0
#endif
#define MAX_TRANSACTIONS 5000

#define ACCUMULATOR 0
#define MONOTONIC 1
#define TABLE 2

#define NONE 0
#define INITIALIZATION 1
#define CHARMINIT 2
#define INTERRUPT 3

#define RING_EP 1
#define SPANTREE_EP 2
#define FEW_EP 3

#define MAX_MACHINES 10

#define SIMULATOR 0
#define SEQUENT 1
#define MAX 2
#define IPSC2 3
#define I860 4
#define NCUBE3 5
#define CM5 6
#define PARAGON 7
#define NETWORK 8
#define NETWORK_ATM 9


#define INTERVAL(x)  ((x - begin_time)/timestep)


#define HASH_TABLE_SIZE 25913
#define HashMap(a, b) ((20011*a+20021*b) % HASH_TABLE_SIZE)
#define HashEqual(x, a, b)  ((x->pe==a) && (x->event==b))

#define InitPrintEP(length, string) { length = 0;  sprintf(string, ""); }
#define PrintEP(tabs, ep, length) {\
	int current_tab_no; \
	total_ep_string_length += length; \
	if (total_ep_string_length>=40) {\
		mysprintf("\n"); \
		for (current_tab_no=0; current_tab_no<tabs; current_tab_no++) \
			mysprintf("\t"); \
		total_ep_string_length=0; \
	} \
	sprintf(temp_string, "%s@%s  ", \
			chare_list[grainsize_table[ep].chareid].name, \
			grainsize_table[ep].name); \
	mysprintf(temp_string); \
} \


typedef struct _transaction {
	char type;
	int queue, pe;
	struct _node *info;
	struct _transaction *next, *previous;
} TRANSACTION;


typedef struct _transaction_list {
	struct _transaction *ptr;
	struct _transaction_list *next, *previous;
} TRANSACTION_LIST;

typedef struct _queue_list {
	unsigned int time;
	struct _transaction *ptr;
	struct _queue_list *next;
} QUEUE_LIST;


typedef struct _node {
	int dop, tag, pe, event, ep, msg_type; 

	struct _transaction *creator;
	unsigned int timec, timep1, timep2;
	struct _transaction_list *creation_list;
	struct _transaction *ptrc, *ptrp1, *ptrp2;

	struct _table_property *table;

	struct _queue_list *enqueue, *dequeue;

	struct _node *next;
} NODE;


typedef struct _transaction_queue {
	struct _transaction  *head, *tail;
} TRANSACTION_QUEUE;

typedef struct _machine_property {
    float alpha, beta;
    char name[100];
} MACHINE_PROPERTY;

typedef struct _table_property {
	char type;
	int tbl, key, pe;
	struct _table_property *next;
} TABLE_PROPERTY;

typedef struct _pseudo_struct {
	int type;
	int index;
	char name[1000];
} PSEUDO_STRUCT;


#ifdef DATA

NODE * HashFind();
NODE *AddTransaction();
int AddCurrentCreationList();
unsigned int GetTime1(), GetTime2();
TRANSACTION *GetPrevious(), *find_lesser(), *find_greater();

NODE *current_node=NULL;
void * additional_table =  NULL;


int queue_size;
int machine_type;
int **stage_status;
char machine_name[1000];
PSEUDO_STRUCT *pseudo_table;
TRANSACTION  ***start_stage;
NODE *hash_table[HASH_TABLE_SIZE];
TRANSACTION_QUEUE *transaction_table;
TRANSACTION_LIST *current_creation_list;
char *my_string, *store_string, *save_string;
MACHINE_PROPERTY machine_table[MAX_MACHINES];

#else

extern NODE *current_node;
extern void * additional_table;

extern int queue_size;
extern int machine_type;
extern int **stage_status;
extern char machine_name[1000];
extern PSEUDO_STRUCT *pseudo_table;
extern TRANSACTION  ***start_stage;
extern NODE *hash_table[HASH_TABLE_SIZE];
extern TRANSACTION_QUEUE *transaction_table;
extern TRANSACTION *find_lesser(), *find_greater();
extern char *my_string, *store_string, *save_string;
extern MACHINE_PROPERTY machine_table[MAX_MACHINES];

extern unsigned int GetTime1(), GetTime2();
extern TRANSACTION *GetPrevious();

#endif
