/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: timeline_graphics.c,v $
 *	$Author: jyelon $	$Locker:  $		$State: Exp $
 *	$Revision: 1.2 $	$Date: 1995/02/24 23:23:03 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: timeline_graphics.c,v $
 * Revision 1.2  1995/02/24 23:23:03  jyelon
 * *** empty log message ***
 *
 ***************************************************************************/
static char ident[] = "@(#)$Header: /expand1/cvsroot/projections/sources/graphics/timeline_graphics.c,v 1.2 1995/02/24 23:23:03 jyelon Exp $";
#include "head.h"
#include "common.h"
#include "graphics.h"
#include "timeline.h"
#include "data.h"
#include "analyse.h"


/*****************************************************************/
/** draw creation arrow if both creator and event are in frame **/
/*****************************************************************/
draw_creation_arrow(canvas2, gc2, current, x2,  y2, start_pe,
						finish_pe, start_time, finish_time, min_time, XSTEP)
Widget canvas2;
GC gc2;
TRANSACTION *current;
int x2, y2;
unsigned int start_pe, finish_pe, start_time, finish_time, min_time;
int XSTEP;
{
	int idx1, x1, y1;
	TRANSACTION *creator= current->info->ptrc;
	
	if (!creator) return;
	idx1 = get_ep_index(creator->info->ep, creator->info->msg_type);
	if (idx1 == -1) return;
	
	if (creator->pe < start_pe || creator->pe > finish_pe) return;
	if (creator->info->timec < start_time || 
			creator->info->timec > finish_time) return;

    y1 = YS + (creator->pe-start_pe)*YS;
    x1 = XS +  (creator->info->timec - min_time)/XSTEP;
	draw_line(canvas2, gc2, x1, y1, x2, y2);
	draw_filled_circle(canvas2, gc2, x1-5, y1-5, x1+5, y1+5);
}


/*****************************************************************/
/** Draw the scales for this graph.				**/
/*****************************************************************/
draw_timeline(data, gc1, gc2, canvas1, canvas2, start_pe, finish_pe, start_time, finish_time, min_time, XSTEP, draw_creator)
graphics_data *data;
GC gc1, gc2;
Widget canvas1, canvas2;
unsigned int start_pe, finish_pe, start_time, finish_time, min_time;
int XSTEP;
int draw_creator;
{
	int n;
	int i;
	Font font1;
	char str[1000];
	int x0, x1, x2, y;
	XFontStruct *font_struct1;
	TRANSACTION *t1, *t2, *current;
	
    font1 = XLoadFont(XtDisplay(canvas1), "8x13");
	font_struct1 = XQueryFont(XtDisplay(canvas1), font1);

	for (i=start_pe; i<=finish_pe; i++)
	{
        	t1 = find_lesser(i, start_time);
        	t2 = find_greater(i, finish_time);
        	if (t1 == NULL || t2 == NULL) return;

			x0 = 0;
			y = YS + (i-start_pe)*YS;
			sprintf(str, "%d", i);
			draw_string(canvas1, gc1, XS, y, str, strlen(str), "8x13");


			for (current=t1; current!=t2->next; current=current->next) 
			{
				int idx, idx2;

				if (current->type != END_PROCESSING) continue;
				idx = get_ep_index(current->info->ep, current->info->msg_type);
				if (idx == -1) continue;

				if (current->info->timep1 <= min_time)
					x1 = XS;
				else
					x1 = XS +  (current->info->timep1 - min_time)/XSTEP;
				if (current->info->timep2 <= min_time)
					x2 = XS;
				else
					x2 = XS + (current->info->timep2 - min_time)/XSTEP;

				/* printf("%d %d %d\n", x0, x1, x2); */

    			XSetLineAttributes(XtDisplay(canvas2), gc2, 1, 
							LineSolid, CapButt, JoinMiter);
    			XSetForeground(XtDisplay(canvas2), gc2, data->foreground);
				draw_line(canvas2, gc2, x0, y, x1, y);

				set_color_and_line_type(canvas2, gc2, FALSE, idx);

				if (draw_creator)
					draw_creation_arrow(canvas2, gc2, current, x1,  y-YS/3,
										start_pe, finish_pe,
										start_time, finish_time, min_time,
										XSTEP);

				draw_rectangle(canvas2, gc2, x1, y-YS/3, x2, y+YS/3);
				x0 = x2;	
			}
	}

	x0 = 0;
	y = YS + (finish_pe-start_pe+1)*YS;
	sprintf(str, "Time ");
	draw_string(canvas1, gc1, XS-XTextWidth(font_struct1, str, strlen(str))/2,
		y, str, strlen(str), "8x13");
	for (i=INTERVAL(start_time); i<=INTERVAL(finish_time); i++)
	{
		x1 = XS +  (begin_time + timestep*i - min_time)/XSTEP;
		draw_line(canvas2, gc2, x0, y, x1-3, y);
		sprintf(str, "%d", i);
		draw_string(canvas2, gc2, x1, y, str, strlen(str), "8x13");
		x0 = x1 + XTextWidth(font_struct1, str, strlen(str)) + 3;
	}

    XSetLineAttributes(XtDisplay(canvas2), gc2, 1, 
							LineSolid, CapButt, JoinMiter);
    XSetForeground(XtDisplay(canvas2), gc2, data->foreground);
}
