/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: common_graphics.c,v $
 *	$Author: jyelon $	$Locker:  $		$State: Exp $
 *	$Revision: 1.2 $	$Date: 1995/02/24 23:23:03 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: common_graphics.c,v $
 * Revision 1.2  1995/02/24 23:23:03  jyelon
 * *** empty log message ***
 *
 ***************************************************************************/
static char ident[] = "@(#)$Header: /expand1/cvsroot/projections/sources/graphics/common_graphics.c,v 1.2 1995/02/24 23:23:03 jyelon Exp $";
#include "head.h"
#include "common.h"
#include "graphics.h"

void *determine_yaxis_title();
graphics_data *current_data;

#define MAX_WIDTH 2
#define MAX_LINE_TYPES 3
int line_type[MAX_LINE_TYPES] = {LineSolid, LineOnOffDash, LineDoubleDash};

#define update(x, y, total) { \
			total++; \
			x = (total%MAX_LEGEND_ROWS)*LEGEND_WIDTH + LEGEND_XOFFSET; \
			y = (total/MAX_LEGEND_ROWS)*LEGEND_SPACE + LEGEND_XOFFSET; }

min(a, b)
int a, b;
{
	if (a<b)
		return a;
	return b;
}


/*****************************************************************/
/** Check whether the points are in increasing sequence, else	**/
/** flip them over.						**/
/*****************************************************************/
check_points(x, y, x2, y2)
int *x, *y, *x2, *y2;
{
	int tmp;

	if (*x2 < *x)
	{
		tmp = *x; 
		*x = *x2;
		*x2 = tmp;
	};
	if (*y2 < *y)
	{
		tmp = *y; 
		*y = *y2;
		*y2 = tmp;
	};
}

/*****************************************************************/
/** Draw a string.						**/
/*****************************************************************/
void draw_string(w, gc, x, y, str, length, font) 
Widget w;
GC gc;
int x, y;
char *str;
int length;
char  *font;
{
	Display *dpy = XtDisplay(w);
	Window win = XtWindow(w);

	XDrawString(dpy, win, gc, x, y, str, length); 
}


/*****************************************************************/
/** Draw a line between the points (x,y) and (x2,y2).		**/
/*****************************************************************/
void draw_line(w, gc, x, y, x2, y2)
Widget w;
GC gc;
int x, y, x2, y2;
{
	Display *dpy = XtDisplay(w);
	Window win = XtWindow(w);

	XDrawLine(dpy, win, gc, x, y, x2, y2);
}





/*****************************************************************/
/** Draw a rectangle with the two opposite vertices being (x,y) **/
/** and (x2, y2).						**/
/*****************************************************************/
void draw_rectangle(w, gc, x, y, x2, y2)
Widget w;
GC gc;
int x, y, x2, y2;
{
	Display *dpy = XtDisplay(w);
	Window win = XtWindow(w);

	check_points(&x, &y, &x2, &y2);
	XDrawRectangle(dpy, win, gc, x, y, x2 - x, y2 - y);
}


/*****************************************************************/
/** Draw a filled rectangle with the two opposite vertices being**/
/** (x,y) and (x2, y2).						**/
/*****************************************************************/
void draw_filled_rectangle(w, gc, x, y, x2, y2)
Widget w;
GC gc;
int x, y, x2, y2;
{
	Display *dpy = XtDisplay(w);
	Window win = XtWindow(w);

	check_points(&x, &y, &x2, &y2);
	XFillRectangle(dpy, win, gc, x, y, x2 - x, y2 - y);
}


/*****************************************************************/
/** Draw a filled circle.					**/
/*****************************************************************/
void draw_filled_circle(w, gc, x1, y1, x2, y2)
Widget w;
GC gc;
int x1, y1, x2, y2;
{
	Display *dpy = XtDisplay(w);
	Window win = XtWindow(w);

	XFillArc(dpy, win, gc, x1, y1, x2-x1, y2-y1, 0, 64*360);
}

/*****************************************************************/
/** This is to determine the title.				**/
/*****************************************************************/
char *determine_title(is_ep, is_creation, temp_data)
int is_ep, is_creation, temp_data;
{
	char *str;

	if (is_ep)
	{
		if (is_creation)
		{
			str = (char *) malloc(strlen(grainsize_table[temp_data].name)+
							strlen(" Created")+1);
			strcpy(str, grainsize_table[temp_data].name);
			strcat(str, " Created");
		}
		else
		{
			str = (char *) malloc(strlen(grainsize_table[temp_data].name)+
							strlen(" Processed")+1);
			strcpy(str, grainsize_table[temp_data].name);
			strcat(str, " Processed");
		}
		return str;
	}

	str = (char *) malloc(sizeof(char)*30);
	switch (temp_data) {
	case CREATE_NEWCHARE:
		strcpy(str, "NewChares Created");
		break;
	case CREATE_FORCHARE:
		strcpy(str, "ForChares Created");
		break;
	case CREATE_FORBOC:
		strcpy(str, "BocMsg Created");
		break;
	case PROCESS_NEWCHARE:
		strcpy(str, "NewChares Processed");
		break;
	case PROCESS_FORCHARE:
		strcpy(str, "ForChares Processed");
		break;
	case PROCESS_FORBOC:
		strcpy(str, "BocMsg Processed");
		break;
	case PROCESS_LDB:
		strcpy(str, "Ldb Processed");
		break;
	case PROCESS_QD:
		strcpy(str, "Qd Processed");
		break;
	case QUEUE_SIZE:
		strcpy(str, "Queue Size");
		break;
	case IDLE_TIME:
		strcpy(str, "Percent Busy");
		break;
	case OVERHEAD_TIME:
		strcpy(str, "Percent Overhead");
		break;
	default:
		printf("*** ERROR *** Improper Title Choice.\n");
		break;
	}
	return str;
}


/*****************************************************************/
/** CONVERT COLOR:  is an integer function that returns the 	**/
/** pixel value of a string representing a color.		**/
/*****************************************************************/
int ConvertColor(display, colorname)
Display *display;
char *colorname;
{
	int screen;
	Colormap cmap;
	XColor color,ignore;

	screen = DefaultScreen(display);
	cmap = DefaultColormap(display, screen);

	if(XAllocNamedColor(display, cmap, colorname, &color, &ignore))
	      	return (color.pixel);
	else
	{
	     	printf("Warning:  cannot allocate `%s'\n",colorname);
		return (BlackPixel(display, screen));
	}
}



/*****************************************************************/
/* Set color and line types.					**/
/*****************************************************************/
set_color_and_line_type(w, gc, is_creation, table)
Widget w; 
GC gc;
int is_creation, table;
{
	int index = is_creation;
	Display *display = XtDisplay(w);
	int color = ConvertColor(display, 
					colors[(NUMBER_COLORS+1)*table % NUMBER_COLORS]);
	

    XSetFunction(display, gc, GXcopy);
	XSetForeground(display, gc, color);

	XSetLineAttributes(XtDisplay(w), gc, index%MAX_WIDTH + 1,
				index%MAX_LINE_TYPES, CapButt, JoinMiter);
}

/*****************************************************************/
/** Write out legend on scroll canvas.							**/
/*****************************************************************/
draw_legend_information(data)
graphics_data *data;
{
 	int i, n;
	int count=0;
    Arg wargs[10];
	int rows, x, y;
	GC gci = data->lgc;
	Widget wi = data->legend;

    for (i=0; i<NUMBER_DISPLAYS; i++)
        if (data->chosen[i]) count++;
   	for (i=0; i<number_entries; i++)
    {
        if (data->ep_c_chosen[i]) count++;
        if (data->ep_p_chosen[i]) count++;
	}

    XClearArea(XtDisplay(data->legend), XtWindow(data->legend),
            0, 0, 0, 0, FALSE);

	rows = count/MAX_LEGEND_ROWS;
	if ((count%MAX_LEGEND_ROWS) > 0) rows++;
  	n=0;
    XtSetArg(wargs[n], XtNheight, rows*LEGEND_SPACE+2*LEGEND_YOFFSET); n++;
    XtSetValues(wi, wargs, n);


	count=0;
	x = LEGEND_XOFFSET;
	y = LEGEND_YOFFSET;
    for (i=0; i<NUMBER_DISPLAYS; i++)
        if (data->chosen[i]) 
		{
			set_color_and_line_type(wi, gci, FALSE, i);
			legend_information(wi, gci, FALSE, FALSE, i, x, y, 15);
			update(x, y, count);
		}
   	for (i=0; i<number_entries; i++)
    {
        if (data->ep_c_chosen[i]) 
		{
			set_color_and_line_type(wi, gci, TRUE, i);
			legend_information(wi, gci, TRUE, TRUE, i, x, y, 15);
			update(x, y, count);
		}
        if (data->ep_p_chosen[i]) 
		{
			set_color_and_line_type(wi, gci, FALSE, i);
			legend_information(wi, gci, TRUE, FALSE, i, x, y, 15);
			update(x, y, count);
		}
	}
}


/*****************************************************************/
/** Write out legend info. at x, y.								**/
/*****************************************************************/
legend_information(wi, gci, is_ep, is_creation, table, x, y, maxlength)
Widget wi;
GC gci;
int is_ep, is_creation, table;
int x, y, maxlength;
{
    char *str;
	int length;

    draw_line(wi, gci, x, y, x + XSKIP, y);
    str = determine_title(is_ep, is_creation, table);

	if (strlen(str) > maxlength) 
		length = maxlength;
	else
		length = strlen(str);

    draw_string(wi, gci, x + 2*XSKIP, y, str, length, "8x13");
}

