/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: animation_graphics.c,v $
 *	$Author: milind $	$Locker:  $		$State: Exp $
 *	$Revision: 1.4 $	$Date: 1997/08/11 18:16:40 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: animation_graphics.c,v $
 * Revision 1.4  1997/08/11 18:16:40  milind
 * Replaced sleep with a modified jsleep based on select.
 *
 * Revision 1.3  1995/09/21 21:08:55  sanjeev
 * *** empty log message ***
 *
 * Revision 1.2  1995/02/24  23:23:03  jyelon
 * *** empty log message ***
 *
 ***************************************************************************/
static char ident[] = "@(#)$Header: /expand1/cvsroot/projections/sources/graphics/animation_graphics.c,v 1.4 1997/08/11 18:16:40 milind Exp $";
#include "head.h"
#include "common.h"
#include "graphics.h"
#include "animation.h"
#include <math.h>
#include <time.h>

extern graphics_data *current_data;


/*****************************************************************/
/** Get a particular color.					**/
/*****************************************************************/
int get_pixel(w, green, red, blue)
Widget w;
int green, red, blue;
{
	XColor color;
	Display *display = XtDisplay(w);
	int screen = DefaultScreen(display);
	Colormap cmap = DefaultColormap(display, screen);
	
	color.green = green;
	color.red   = red;
	color.blue  = blue;

	if (XAllocColor(display, cmap, &color))
		return(color.pixel);
	else
	{
	     	printf("Warning:  cannot allocate. \n");
		return (BlackPixel(display, screen));
	}
}


void square_mesh(xheight, yheight, begin_pe, end_pe, x1, y1, x2, y2, line, mydata)
int xheight, yheight;
int begin_pe, end_pe;
int *x1, *y1, *x2, *y2;
PAIR *line;
animation_data *mydata;
{
	int i;
	int total_pe;
	int xoffset, yoffset;
	int per_row, square_side;

	total_pe = end_pe - begin_pe + 1;

	xoffset = ANIMATION_X;
	yoffset = ANIMATION_Y;
	per_row = (int) ceil(sqrt((double) total_pe));
	square_side = (min(xheight-2*ANIMATION_X, yheight-2*ANIMATION_Y))/(2*per_row-1);
	for (i=0; i<total_pe; i++)
	{
		int row_index;
		int col_index;

		row_index = i / per_row;
		col_index = i % per_row;

		x1[i] = xoffset + 2*col_index*square_side; 
		x2[i] = x1[i] + square_side;
		y1[i] = yoffset +  2*row_index*square_side; 
		y2[i] = y1[i] + square_side;
	}
}


void ring(xheight, yheight, begin_pe, end_pe, x1, y1, x2, y2, line, mydata)
int xheight, yheight;
int begin_pe, end_pe;
int *x1, *y1, *x2, *y2;
PAIR *line;
animation_data *mydata;
{
	int i;
	int radius;
	int theta;
	int xorigin, yorigin;
	int xoffset, yoffset;
	int total_pe, square_side;

	total_pe = end_pe - begin_pe + 1;
	xoffset = ANIMATION_X;
	yoffset = ANIMATION_Y;

	radius = (min(xheight-2*ANIMATION_X, yheight-2*ANIMATION_Y))/2;
	xorigin = xoffset + radius;
	yorigin = yoffset + radius;

	theta = 360/total_pe;
	square_side = (3.1415*radius)/(total_pe*sqrt((double) 2));
	if (square_side > radius/3)
		square_side = 90;

	for (i=0; i<total_pe; i++)
	{
		int x, y;
		double angle;

		angle = (double) (i*theta)/180.0;
		x = xorigin + radius*sin(angle); 
		y = yorigin - radius*sin(0.5-angle);
		x1[i] = x - square_side/2; 
		y1[i] = y - square_side/2; 
		x2[i] = x + square_side/2;
		y2[i] = y + square_side/2; 
	}
	for (i=0; i<total_pe; i++)
	{
		line[i].first = i;
		line[i].second = i+1;
	}
	line[total_pe-1].second = 0;
}

void spanning_tree(xheight, yheight, begin_pe, end_pe, x1, y1, x2, y2, line, mydata)
int xheight, yheight;
int begin_pe, end_pe;
int *x1, *y1, *x2, *y2;
PAIR *line;
animation_data *mydata;
{
	int i;
	int count;
	int levels;
	int spread[25];
	int yspacing;
	int xoffset, yoffset;
	int total_pe, square_side; 

	xoffset = ANIMATION_X;
	yoffset = ANIMATION_Y;
	total_pe = end_pe - begin_pe + 1;

	spread[0] = 1;
	for (i=1; i<25; i++)
		spread[i] = 2*spread[i-1];
	levels = floor(log10((double) total_pe)/log10(2.0));

	square_side = min( (xheight - ANIMATION_X)/(spread[levels]+1),
				(yheight - 2*ANIMATION_Y)/(2*levels - 1));
	yspacing = (yheight - 2*ANIMATION_Y - levels*square_side)/levels; 
	yspacing += square_side;

	for (i=0; i<total_pe; i++)
	{
		int x, y;
		int level;
		int idash;
		int kid[25];
		int current_distance;

		idash = i + 1;
		if (i==0)
		{
			y = yoffset; 
			x = (xheight - 2*ANIMATION_X)/2;
		}
		else
		{
			int j, temp;

			level = (int) floor(log10((double) idash)/log10(2.0));
			y = yoffset + level*yspacing;

			x = current_distance = (xheight - 2*ANIMATION_X)/2;
			temp = idash;
			for (j=level; j>0; j--)
			{
				if (temp % 2 == 0)	
					kid[j] = -1;
				else
					kid[j] = 1;
				temp /= 2;
			}
			for (j=1; j<=level; j++)
			{
				current_distance /= 2;
				x += kid[j]*current_distance;
			}
			if (idash % 2 == 0)
				x += SPACING/2;
			else
				x -= SPACING/2;
		}
		x += xoffset;
		x1[i] = x - square_side/2; 
		y1[i] = y - square_side/2; 
		x2[i] = x + square_side/2;
		y2[i] = y + square_side/2;
	}
	count = 0;
	for (i=0; i<total_pe; i++)
	{
		if (2*i+1 < total_pe)
		{
			line[count].first = i;
			line[count].second = 2*i+1;
			count++;
		}
		if (2*(i+1) < total_pe)
		{
			line[count].first = i;
			line[count].second = 2*(i+1);
			count++;
		}
	}
}



void three_d(xheight, yheight, begin_pe, end_pe, x1, y1, x2, y2, line, mydata)
int xheight, yheight;
int begin_pe, end_pe;
int *x1, *y1; 
int *x2, *y2; 
PAIR *line;
animation_data *mydata;
{
	int i;
	int count;
	int temp;
	int radius;
	int x, y, z;
	int Nx = mydata->x;
	int Ny = mydata->y;
	int Nz = mydata->z;
	int xoffset, yoffset;

	count = 0;
#define ZSPACING 50
	radius = min( (xheight - 2*ANIMATION_X - (Nz-1)*ZSPACING)/
				((2*Nx-1)*Nz), 
			   (yheight - 2*ANIMATION_Y)/((2*Ny-1)/((Nz+1)/2)));
	for (z=0; z<Nz; z++)
	{
		int temp;

		xoffset = ANIMATION_X + (2*Nx-1)*z*radius + z*ZSPACING;
		yoffset = ANIMATION_Y + ((2*Ny-1)*z*radius)/2;

		for (y=0; y<Ny; y++)
			for (x=0; x<Nx; x++)
			{
				i = x + y*Nx + z*Ny*Nx;
				x1[i] = (2*x-1)*radius + xoffset;
				y1[i] = (2*y-1)*radius + yoffset;
				x2[i] = x1[i] + radius;
				y2[i] = y1[i] + radius;
			}
		temp = z*Ny*Nx;
		line[count].first = line[count+3].second = temp;
		line[count+1].first = line[count].second = Nx-1 + temp;
		line[count+2].first = line[count+1].second =
				Nx-1 + (Ny-1)*Nx + temp;
		line[count+3].first = line[count+2].second = 
				(Ny-1)*Nx + temp;
		count += 4;
	}
	temp = (Nz-1)*Ny*Nx;
	line[count].first = 0; 
	line[count].second = temp;
	line[count+1].first = (Nx-1);
	line[count+1].second = (Nx-1) + temp;
	line[count+2].first = (Nx-1) + (Ny-1)*Nx;
	line[count+2].second = (Nx-1) + (Ny-1)*Nx + temp; 
	line[count+3].first = (Ny-1)*Nx; 
	line[count+3].second = (Ny-1)*Nx + temp;
	count += 4;
}


void write_out_current_stage(display, canvas, gc, xheight, font_struct,
	black_color, i)
Display *display;
Widget canvas;
GC gc;
int xheight;
XFontStruct *font_struct;
int black_color;
int i;
{
	char str[30];
	int xpe, ype;
	
	xpe =  15;
	ype =  15;
	sprintf(str, "Current Stage: %d", i);
	XClearArea(display, XtWindow(canvas), 0, 0, xheight, ANIMATION_Y, FALSE);
       	XSetFunction(display, gc, GXcopy);
	XSetForeground(display, gc, black_color);
	draw_string(canvas, gc, xpe, ype, str, strlen(str));
}	

void jsleep(usecs)
unsigned int usecs;
{
  struct timeval tm;
  tm.tv_sec = 0;
  tm.tv_usec = usecs;
  select(0,NULL,NULL,NULL,&tm);
}

/*****************************************************************/
/** This draws the animation.					**/
/*****************************************************************/
void draw_animation(data, choice)
graphics_data *data;
int choice;
{
	int i;
	Font font;
	PAIR *line;
	int xpe, ype;
	int line_count;
	int black_color;
	int white_color;
	animation_data mydata;
	int *x1, *x2, *y1, *y2;
	XFontStruct *font_struct;
	int begin_pe, end_pe, total_pe;
	Display *display = XtDisplay(data->canvas1);

	current_data = data;
	XClearArea(XtDisplay(data->canvas1), XtWindow(data->canvas1),
			0, 0, 0, 0, FALSE);

	begin_pe = data->begin_pe;
	end_pe   = data->end_pe;
	total_pe = end_pe - begin_pe + 1;

	font = XLoadFont(display, "6x12");
	font_struct = XQueryFont(display, font);
	black_color = get_pixel(data->canvas1, 0, 0, 0);
	white_color = get_pixel(data->canvas1, 65535, 65535, 65535);

	x1 = (int *) malloc(sizeof(int)*total_pe);
	y1 = (int *) malloc(sizeof(int)*total_pe);
	x2 = (int *) malloc(sizeof(int)*total_pe);
	y2 = (int *) malloc(sizeof(int)*total_pe);

	mydata.x = 2;
	mydata.y = 2;
	mydata.z = 4;

	switch (choice) {
	case RING:	
		line_count = end_pe - begin_pe + 1;
		line = (PAIR *) malloc(sizeof(PAIR)*line_count);
		ring(data->xheight, data->yheight, 
			begin_pe, end_pe, x1, y1, x2, y2, line, &mydata);
		break;
	case SPANNING_TREE:
		line_count = end_pe - begin_pe; 
		line = (PAIR *) malloc(sizeof(PAIR)*line_count);
		spanning_tree(data->xheight, data->yheight, 
			begin_pe, end_pe, x1, y1, x2, y2, line, &mydata);
		break;
	case SQUARE_MESH:	
		line_count = 0;
		square_mesh(data->xheight, data->yheight, 
			begin_pe, end_pe, x1, y1, x2, y2, line, &mydata);
		break;
	case THREE_D_MESH:
		line_count = 4*mydata.z+ 4;
		line = (PAIR *) malloc(sizeof(PAIR)*line_count);
		three_d(data->xheight, data->yheight, 
			begin_pe, end_pe, x1, y1, x2, y2, line, &mydata);
			
		break;
	}


	switch (choice) {
	case RING:	
	case SPANNING_TREE:
	case SQUARE_MESH:	
		for (i=data->begin_stages; i<=data->end_stages; i++)
		{
			int j;
			int color;
			int pixels;
			char str[30];
	
			write_out_current_stage(display,
				data->canvas1, data->gc1, data->xheight, 
				font_struct, black_color, i);
	
			for (j=0; j<line_count; j++)
				draw_line(data->canvas1, data->gc1, 
				(x1[line[j].first]+x2[line[j].first])/2,
				(y1[line[j].first]+y2[line[j].first])/2, 
				(x1[line[j].second]+x2[line[j].second])/2,
				(y1[line[j].second]+y2[line[j].second])/2);

			for (j=begin_pe; j<=end_pe; j++)
			{
				int index;
				int jdash = j - begin_pe;
	
				index = display_table[IDLE_TIME][j][i];
				color = get_pixel(data->canvas1, 0,
					(65535*(100-index))/100,
					(65535*index)/100);
        			XSetFunction(display, data->gc1, GXcopy);
				XSetForeground(display, data->gc1, color);
	
				draw_filled_rectangle(data->canvas1, data->gc1, 
					x1[jdash], y1[jdash], 
					x2[jdash], y2[jdash]);

       				XSetFunction(display, data->gc1, GXcopy);
				XSetForeground(display, data->gc1, white_color);
				sprintf(str, "%d", j);
				pixels = XTextWidth(font_struct, 
						str, strlen(str));
				xpe = (x1[jdash] + x2[jdash])/2 - pixels/2;
				ype = (y1[jdash] + y2[jdash])/2; 
				draw_string(data->canvas1, data->gc1,
					xpe, ype,
					str, strlen(str), "8x13");
			}
			jsleep(100000);
		}
		break;

	case THREE_D_MESH:
		for (i=data->begin_stages; i<=data->end_stages; i++)
		{
			int j;
			int color;
			int pixels;
			char str[30];
	
			write_out_current_stage(display,
				data->canvas1, data->gc1, data->xheight, 
				font_struct, black_color, i);
			for (j=0; j<line_count; j++)
				draw_line(data->canvas1, data->gc1, 
				(x1[line[j].first]+x2[line[j].first])/2,
				(y1[line[j].first]+y2[line[j].first])/2, 
				(x1[line[j].second]+x2[line[j].second])/2,
				(y1[line[j].second]+y2[line[j].second])/2);
	
			for (j=begin_pe; j<=end_pe; j++)
			{
				int index;
				int jdash = j - begin_pe;
	
				index = display_table[IDLE_TIME][j][i];
				color = get_pixel(data->canvas1, 0,
					(65535*(100-index))/100,
					(65535*index)/100);
        			XSetFunction(display, data->gc1, GXcopy);
				XSetForeground(display, data->gc1, color);
	
				draw_filled_circle(data->canvas1, data->gc1, 
					x1[jdash], y1[jdash], 
					x2[jdash], y2[jdash]); 

       				XSetFunction(display, data->gc1, GXcopy);
				XSetForeground(display, data->gc1, white_color);
				sprintf(str, "%d", j);
				pixels = XTextWidth(font_struct, 
						str, strlen(str));
				xpe = (x1[jdash] + x2[jdash])/2 - pixels/2;
				ype = (y1[jdash] + y2[jdash])/2; 
				draw_string(data->canvas1, data->gc1,
					xpe, ype,
					str, strlen(str), "8x13");
			}
			jsleep(100000);
		}
		break;
	}

	free(x1); free(x2); free(y1); free(y2); free(line);
	XSetForeground(XtDisplay(data->canvas1), data->gc1, data->foreground);
}


