/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: timestep.c,v $
 *	$Author: sanjeev $	$Locker:  $		$State: Exp $
 *	$Revision: 1.3 $	$Date: 1995/09/21 21:09:15 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: timestep.c,v $
 * Revision 1.3  1995/09/21 21:09:15  sanjeev
 * *** empty log message ***
 *
 * Revision 1.2  1995/02/24  23:22:53  jyelon
 * *** empty log message ***
 *
 ***************************************************************************/
static char ident[] = "@(#)$Header: /expand1/cvsroot/projections/sources/callbacks/timestep.c,v 1.3 1995/09/21 21:09:15 sanjeev Exp $";
#include "head.h"
#include "common.h"
#include "xs.h"
#include "graphics.h"
#include "timestep.h"


/*****************************************************************/
/** This function is the call back when the cancel button in 	**/
/** the command menu is pressed.				**/
/*****************************************************************/
void timestep_cancel_callback(w, data, call_data)
Widget w;
struct timestep_widgets *data;
XmAnyCallbackStruct *call_data;
{
	XtDestroyWidget(data->timestep);
}


/*****************************************************************/
/** This function is the call back when the ok button in 	**/
/** the command menu is pressed.				**/
/*****************************************************************/
void timestep_ok_callback(w, data, call_data)
Widget w;
struct timestep_widgets *data;
XmAnyCallbackStruct *call_data;
{
	int i;
	int temp;
	char *str;
	graphics_data *g_data;

	temp	= atoi (XmTextGetString(data->timestep_text));

	if (temp != timestep)
	{
		timestep = temp;
		reanalyse();
		for (i=0; i<current_window_pos; i++)
		{
			g_data = windows[i];
			switch (g_data->type) {

			case CONSTANT_STAGE:
			case CONSTANT_PE:
			case TOTAL_STAGE:
			case TOTAL_PE:
				set_detailed_parameters(g_data, g_data->type,
					0, number_pe - 1, 0, stages - 1);
				draw_display(g_data, g_data->type); 
				break;
			
			case OVERVIEW_STAGE:
			case OVERVIEW_PE:
				set_overview_parameters(g_data, g_data->type,
					0, number_pe - 1, 0, stages - 1);
				draw_overview(g_data); 
				break;
			
			case UTIL_STAGE:
			case UTIL_PE:
				g_data->view_type = g_data->type ;
				set_util_parameters(g_data, 
					0, number_pe - 1, 0, stages - 1);
				draw_util(g_data); 
				break;

			case GRID:
				g_data->begin_pe = 0;
				g_data->end_pe = number_pe - 1;
				g_data->begin_stages = 0;
				g_data->end_stages = stages - 1;
				g_data->current = 0;
				break;
			}
		}
		printf("The timestep has been modified;  the new timestep is %d \n", timestep); 
	}
	else
	 	printf("Time Step not modified. \n"); 
	XtDestroyWidget(data->timestep);
}


/*****************************************************************/
/** This function is the call back for the clicking of the time	**/
/** options button in the display menu. A new shell is 		**/
/** created. 							**/
/*****************************************************************/
void timestep_callback(w, temp_data, call_data)
Widget w;
int temp_data;
XmAnyCallbackStruct *call_data;
{
	int i;
	int n;
	Arg wargs[10];
	Widget  ok;
	Widget cancel;
	char string[100];
	XmString message;
	graphics_data *data;
	Widget 	shell3, framework3; 
	Widget  timestep_label, timestep_text;
	struct timestep_widgets *timestep_widget_data;



	n=0;
	XtSetArg(wargs[n], XtNtitle, "Set Timestep"); n++;
	shell3 = XtCreateApplicationShell("shell3",
				topLevelShellWidgetClass,
				wargs, n);

	n=0;
	framework3 = XmCreateBulletinBoardDialog(shell3, "framework3", wargs, n);

	sprintf(string, "TimeStep:");
	message = XmStringCreate(string, XmSTRING_DEFAULT_CHARSET);
	n=0;
	XtSetArg(wargs[n], XmNlabelString, message); n++; 
	XtSetArg(wargs[n], XmNx, TIMESTEP_LABEL_X); n++; 
	XtSetArg(wargs[n], XmNy, TIMESTEP_LABEL_Y); n++; 
	timestep_label = XtCreateManagedWidget(TIMESTEP_LABEL,
				xmLabelWidgetClass, 
				framework3, wargs, n);

	n=0;
	XtSetArg(wargs[n], XmNx, TIMESTEP_TEXT_X); n++; 
	XtSetArg(wargs[n], XmNy, TIMESTEP_TEXT_Y); n++; 
	timestep_text = XtCreateManagedWidget(TIMESTEP_TEXT,
				xmTextWidgetClass, 
				framework3, wargs, n);
	sprintf(string, "%d", timestep);
	XmTextSetString(timestep_text, string); 


	timestep_widget_data = (struct timestep_widgets *)
		malloc(sizeof(struct timestep_widgets));
	timestep_widget_data->timestep = shell3; 	
	timestep_widget_data->timestep_text = 	
			timestep_text;
	
	n=0;
	XtSetArg(wargs[n], XmNx, OK_X); n++; 
	XtSetArg(wargs[n], XmNy, OK_Y); n++; 
	ok = XtCreateManagedWidget(OK,
				xmPushButtonWidgetClass, 
				framework3, wargs, n);
	XtAddCallback(ok, XmNactivateCallback,
			timestep_ok_callback,
			timestep_widget_data);

	n=0;
	XtSetArg(wargs[n], XmNx, CANCEL_X); n++; 
	XtSetArg(wargs[n], XmNy, CANCEL_Y); n++; 
	cancel = XtCreateManagedWidget(CANCEL,
				xmPushButtonWidgetClass, 
				framework3, wargs, n);
	XtAddCallback(cancel, XmNactivateCallback,
			timestep_cancel_callback,
			timestep_widget_data);

	XtManageChild(framework3);
	XtRealizeWidget(shell3);
}


