/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: overview.c,v $
 *	$Author: sanjeev $	$Locker:  $		$State: Exp $
 *	$Revision: 1.3 $	$Date: 1995/09/21 21:09:15 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: overview.c,v $
 * Revision 1.3  1995/09/21 21:09:15  sanjeev
 * *** empty log message ***
 *
 * Revision 1.2  1995/02/24  23:22:53  jyelon
 * *** empty log message ***
 *
 ***************************************************************************/
static char ident[] = "@(#)$Header: /expand1/cvsroot/projections/sources/callbacks/overview.c,v 1.3 1995/09/21 21:09:15 sanjeev Exp $";
#include "head.h"
#include "common.h"
#include "xs.h"
#include "graphics.h"
#include "overview.h"


/*****************************************************************/
/** The following provide the data structures that declare the 	**/
/** menu.							**/
/*****************************************************************/
static xs_menu_struct new_chare[] = {
        {"Creation", overview_choice, CREATE_NEWCHARE},
        {"Processing", overview_choice, PROCESS_NEWCHARE}
};
static xs_menu_struct for_chare[] = {
        {"Creation", overview_choice, CREATE_FORCHARE},
        {"Processing", overview_choice, PROCESS_FORCHARE}
};
static xs_menu_struct for_boc[] = {
        {"Creation", overview_choice, CREATE_FORBOC},
        {"Processing", overview_choice, PROCESS_FORBOC}
};
static xs_menu_struct system_msgs[] = {
        {"Load balancing", overview_choice, PROCESS_LDB},
        {"Quiescence detection", overview_choice, PROCESS_QD}
};

static xs_menu_struct overview_view_entries[] = {
        {"New Chare Msgs", NULL, 0,
                new_chare, XtNumber(new_chare), ""},
        {"For Chare Msgs", NULL, 0,
                for_chare, XtNumber(for_chare), ""},
        {"Boc Messages", NULL, 0,
                for_boc, XtNumber(for_boc), ""},
        {"System Messages", NULL, 0,
                system_msgs, XtNumber(system_msgs), ""},
		{"", NULL, 0},
        {"Queue Size", overview_choice, QUEUE_SIZE},
        {"Busy Time", overview_choice, IDLE_TIME},
        {"Overhead Time",  overview_choice, OVERHEAD_TIME}
};

static xs_menu_struct overview_view[] = {
        {"View-System-Attributes", NULL, 0,
                 overview_view_entries, XtNumber(overview_view_entries), ""}
};


static xs_menu_struct overview_file_entries[] = {
        {"Quit", intermediate_quit_callback, 0}
};
static xs_menu_struct overview_file[] = {
        {"File     ", NULL, 0,
                overview_file_entries, XtNumber(overview_file_entries), ""}
};

static xs_menu_struct overview_edit_entries[] = {
        {"Clear All", clearall_callback, 0},
        {"Set Parameters", parameters_callback, 0}
};
static xs_menu_struct overview_edit[] = {
        {"Edit     ", NULL, 0,
                overview_edit_entries, XtNumber(overview_edit_entries), ""}
};



/*****************************************************************/
/** Choose this widget.						**/
/*****************************************************************/
void overview_choice(w, data, call_data)
Widget w;
graphics_data *data;
XmAnyCallbackStruct *call_data;
{
	int n;
	int i;
	Arg wargs[10];

	n=0;
	XtSetArg(wargs[n], XmNuserData, &i); n++;
	XtGetValues(w, wargs, n);

	if (data->chosen[i])
		data->chosen[i] = 0;
	else
		data->chosen[i] = 1;
	draw_overview(data); 
}


/*****************************************************************/
/** This function sets xscale and xsteps.			**/
/*****************************************************************/
overview_set_xscale_and_xstep( height, divisons, step, scale)
int height, divisons, *step, *scale;
{
	int temp_divisons;

	*step = 1;
	if (divisons-1 > XMAXDIVISONSPERPAGE)
	{
		*step = (divisons-1) / XMAXDIVISONSPERPAGE + 1; 
		temp_divisons = (divisons - 1)/ (*step) + 1;
		*scale = (height - 2*XBOUNDARY) / temp_divisons + 1; 
	}
	else
		*scale = (height - 2*XBOUNDARY) / (divisons-1) + 1; 
}


/*****************************************************************/
/** This function sets up various parameters for the drawing of	**/
/** histograms.							**/
/*****************************************************************/
set_overview_parameters(data, type, begin_pe, end_pe, 
		begin_stages, end_stages)
graphics_data *data;
int type;
int begin_pe; 
int end_pe; 
int begin_stages; 
int end_stages;
{
	int i, j;
	int table;
	int min, max;
	int busy_min, busy_max;

	data->type = type;

	max = 0;
	min = 9999999;
	busy_max = 0;
	busy_min = 9999999;

	switch (type) {

	case OVERVIEW_PE:
		data->xdivisons = end_pe - begin_pe+ 1;
		data->start_xdivs = begin_pe;
		data->finish_xdivs = end_pe;
		data->xtitle = (char *) malloc(strlen("PROCESSORS")+1);
		strcpy(data->xtitle, "PROCESSORS");

		for (table=0; table<NUMBER_DISPLAYS; table++)
		if (data->chosen[table])
			for (i=begin_pe; i<=end_pe; i++)
			{
				int temp;
	
				temp = 0;
				for (j=begin_stages; j<=end_stages; j++)
					temp += display_table[table][i][j];	

				if (table != IDLE_TIME && table != OVERHEAD_TIME) 
					MIN_MAX(temp, min, max)
				else
					MIN_MAX(temp/
						(end_stages-begin_stages+1),
						busy_min, busy_max)
			}
        for (table=0; table<number_entries; table++)
		{
            int temp;
        	if (data->ep_c_chosen[table])
            	for (i=begin_pe; i<=end_pe; i++)
            	{
                	temp = 0;
                	for (j=begin_stages; j<=end_stages; j++)
                    	temp += ep_c_display_table[table][i][j];
                	MIN_MAX(temp, min, max)
            	}
        	if (data->ep_p_chosen[table])
            	for (i=begin_pe; i<=end_pe; i++)
            	{
                	temp = 0;
                	for (j=begin_stages; j<=end_stages; j++)
                    	temp += ep_p_display_table[table][i][j];
                	MIN_MAX(temp, min, max)
            	}
		}
		break;

	case OVERVIEW_STAGE:
		data->xdivisons = end_stages - begin_stages + 1;
		data->start_xdivs = begin_stages;
		data->finish_xdivs = end_stages;
		data->xtitle = (char *) malloc(1000);
		sprintf(data->xtitle, "STAGES (Each stage is %d microseconds)", 
				timestep);

		for (table=0; table<NUMBER_DISPLAYS; table++)
		if (data->chosen[table])
			for (i=begin_stages; i<=end_stages; i++)
			{
				int temp;
	
				temp = 0;
				for (j=begin_pe; j<=end_pe; j++)
					temp += display_table[table][j][i];	
				if (table != IDLE_TIME && table != OVERHEAD_TIME) 
					MIN_MAX(temp, min, max)
				else
					MIN_MAX(temp/
						(end_pe-begin_pe+1),
						busy_min, busy_max)
			}
		for (table=0; table<number_entries; table++)
		{
			if (data->ep_c_chosen[table])
				for (i=begin_stages; i<=end_stages; i++)
				{
					int temp;
					temp = 0;
					for (j=begin_pe; j<=end_pe; j++)
						temp += ep_c_display_table[table][j][i];	
					MIN_MAX(temp, min, max)
				}
			if (data->ep_p_chosen[table])
				for (i=begin_stages; i<=end_stages; i++)
				{
					int temp;
					temp = 0;
					for (j=begin_pe; j<=end_pe; j++)
						temp += ep_p_display_table[table][j][i];	
					MIN_MAX(temp, min, max)
				}
		}
		break;

	}

	if (min > max) { min = 0; max = 1; }
	data->min = min;
	data->max = max;
	if (busy_min > busy_max) { busy_min = 0; busy_max = 100; }
	data->busy_min = busy_min;
	data->busy_max = busy_max;

	data->begin_pe = begin_pe;
	data->end_pe = end_pe;
	data->begin_stages = begin_stages;
	data->end_stages = end_stages;

	data->ydivisons	= (max - min + 1);
	data->busy_ydivisons	= (busy_max - busy_min + 1);

	overview_set_xscale_and_xstep( data->xheight, data->xdivisons,
		&data->xstep, &data->xscale); 
	set_yscale_and_ystep( data->yheight, data->ydivisons, 
		&data->ystep, &data->yscale);
	set_yscale_and_ystep( data->yheight, data->busy_ydivisons, 
		&data->busy_ystep, &data->busy_yscale);
}


/*****************************************************************/
/** This function is used to resize windows on receving a resize */
/** request.							**/
/*****************************************************************/
void resize_overview_callback(w, data, call_data)
Widget w;
graphics_data *data;
XmDrawingAreaCallbackStruct call_data;
{
	int n;
	Arg wargs[10];
	Dimension xheight, yheight;

	n=0;
	XtSetArg(wargs[n], XtNwidth, &xheight); n++;
	XtSetArg(wargs[n], XtNheight, &yheight); n++;
	XtGetValues(data->canvas2, wargs, n);

	if ((data->xheight != xheight) || (data->yheight == yheight))
	{
		data->xheight = xheight;
		data->yheight = yheight;

		set_overview_parameters(data, data->type,
			data->begin_pe, data->end_pe,
			data->begin_stages, data->end_stages);

		draw_overview(data); 
	}
}

/*****************************************************************/
/** This is called when the OverView button is clicked.		**/
/*****************************************************************/
void overview_callback(w, temp_data, call_data)
Widget w;
int temp_data;
XmAnyCallbackStruct *call_data;
{
	int i;
	int n;
	Arg wargs[10];
	graphics_data *data;
	XSetWindowAttributes w_attr;

	Widget shell2;
	Widget menu_bar;  
	Widget framework2;
	Widget main_window2;
	Widget parameters;
	Widget canvas_frame, legend_scroll;


	if (temp_data == OVERVIEW_PE)
		if (number_pe == 1)
		{
			printf("***ERROR*** Too Few Processors.\n");
			return;
		}
	if (temp_data == OVERVIEW_STAGE)
		if (stages == 1)
		{
			printf("***ERROR*** Too Few Stages.\n");
			return;
		}
	n=0;
	switch (temp_data) {
	case OVERVIEW_STAGE:
		XtSetArg(wargs[n], XtNtitle,
			"OverView (Stage)"); n++;
		break;

	case OVERVIEW_PE:
		XtSetArg(wargs[n], XtNtitle,
			"OverView (Processor)"); n++;
		break;
	}

	n=0;
        XtSetArg(wargs[n], XtNtitle, "OverView"); n++;
	shell2 = XtCreateApplicationShell("shell2",
			topLevelShellWidgetClass,
			wargs, n);

	n=0;
	main_window2 = XmCreateMainWindow(shell2, "main_window2", wargs, n);
	XtManageChild(main_window2);

	n=0;
	XtSetArg(wargs[n], XmNmarginWidth, 2); n++;
	XtSetArg(wargs[n], XmNmarginHeight, 2); n++;
	XtSetArg(wargs[n], XmNshadowThickness, 1); n++;
	XtSetArg(wargs[n], XmNshadowType, XmSHADOW_OUT); n++;
	framework2 = XtCreateManagedWidget("framework2",
			xmFormWidgetClass,
			main_window2, wargs, n);

	/*************************************************/
	/** Allocate the data area here, because it's	**/
	/** going to be used before it is actually used.**/
	/*************************************************/
	data = (graphics_data *) malloc(sizeof(graphics_data));

	/*************************************************/
	/** Create the canvas frame.			**/
	/*************************************************/
	canvas_frame = XtCreateManagedWidget("canvas_frame",
			xmFrameWidgetClass,
			framework2, NULL, 0);
	create_and_init_canvas(canvas_frame, &data->canvas2, &data->gc2, data);

    n=0;
    XtSetArg(wargs[n], XmNscrollingPolicy, XmAUTOMATIC); n++;
    XtSetArg(wargs[n], XtNheight, LEGEND_SCROLL_HEIGHT); n++;
    legend_scroll = XtCreateManagedWidget("legend_scroll",
                    xmScrolledWindowWidgetClass,
                    framework2, wargs, n);
    create_and_init_canvas(legend_scroll, &data->legend, &data->lgc, data);
    n=0;
	XtSetArg(wargs[n], XmNworkWindow, data->legend); n++;
	XtSetValues(legend_scroll, wargs, n);



	/*************************************************/
	/** Now create the graphics data, and set up	**/
	/** parameters for this call.			**/
	/*************************************************/
	windows[current_window_pos++] = data;
	data->shell = shell2;
	data->xheight 	= XHEIGHT;
	data->yheight	= YHEIGHT;
	data->current = 0;
	data->view_type = OVERVIEW;
    for (i=0; i<NUMBER_DISPLAYS; i++) data->chosen[i]=0;
    for (i=0; i<number_entries; i++) {
		data->ep_c_chosen[i]=0;
    	data->ep_p_chosen[i]=0;
	}
	set_overview_parameters(data, temp_data, 0, number_pe-1, 0, stages-1);

	/*************************************************/
	/** Now initialize some of the canvas parametes.**/
	/*************************************************/
	w_attr.backing_store = Always;


	/*************************************************/
	/** Create the frame containing the quit and the**/
	/** parameters buttons.				**/
	/*************************************************/
	menu_bar = XmCreateMenuBar(main_window2, "menu_bar", NULL, 0);
	XtManageChild(menu_bar);

	data->no_toggle_buttons = 0;
	data->toggle_buttons = (WidgetList)  XtMalloc(sizeof(Widget)* 
		(count_toggle_buttons(overview_view, XtNumber(overview_view), data)
		+ count_toggle_buttons(options_xs_struct, 1, data)));

    data_xs_create_menu_buttons(menu_bar, overview_file,
                                XtNumber(overview_file), data);
    data_xs_create_menu_buttons(menu_bar, overview_edit,
                                XtNumber(overview_edit), data);
    data_toggle_buttons(menu_bar, overview_view,
                                XtNumber(overview_view), data);
    data_toggle_buttons(menu_bar, options_xs_struct, 1, data);

	n=0;
	XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_FORM); n++;
	XtSetArg(wargs[n], XmNbottomAttachment, XmATTACH_WIDGET); n++;
	XtSetArg(wargs[n], XmNbottomWidget, legend_scroll); n++;
	XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_FORM); n++;
	XtSetArg(wargs[n], XmNrightAttachment, XmATTACH_FORM); n++;
	XtSetValues(canvas_frame, wargs, n);

	n=0;
	XtSetArg(wargs[n], XmNbottomAttachment, XmATTACH_FORM); n++;
	XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_FORM); n++;
	XtSetArg(wargs[n], XmNrightAttachment, XmATTACH_FORM); n++;
	XtSetValues(legend_scroll, wargs, n);

	n=0;
	XtSetArg(wargs[n], XtNwidth, data->xheight); n++;
	XtSetArg(wargs[n], XtNheight, data->yheight); n++;
	XtSetValues(data->canvas2, wargs, n);
	XtAddCallback(data->canvas2, XmNresizeCallback,
			resize_overview_callback, data);

	n=0;
	XtSetArg(wargs[n], XtNwidth, data->xheight); n++;
	XtSetValues(data->legend, wargs, n);


	XtRealizeWidget(shell2);
	XChangeWindowAttributes(XtDisplay(data->canvas2), XtWindow(data->canvas2),
			CWBackingStore, &w_attr);
	XChangeWindowAttributes(XtDisplay(data->legend), XtWindow(data->legend),
			CWBackingStore, &w_attr);
}

