/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: grainsize.c,v $
 *	$Author: sanjeev $	$Locker:  $		$State: Exp $
 *	$Revision: 1.5 $	$Date: 1995/09/22 20:06:03 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: grainsize.c,v $
 * Revision 1.5  1995/09/22 20:06:03  sanjeev
 * *** empty log message ***
 *
 * Revision 1.4  1995/09/22  19:48:12  sanjeev
 * chare numbers 0, 1, 2 need to be ignored
 *
 * Revision 1.3  1995/09/21  21:09:15  sanjeev
 * *** empty log message ***
 *
 * Revision 1.2  1995/02/24  23:22:53  jyelon
 * *** empty log message ***
 *
 ***************************************************************************/
static char ident[] = "@(#)$Header: /expand1/cvsroot/projections/sources/callbacks/grainsize.c,v 1.5 1995/09/22 20:06:03 sanjeev Exp $";
#include "head.h"
#include "common.h"
#include "xs.h"
#include "graphics.h"
#include "overview.h"

#define LEGEND_SCROLL_HEIGHT 100


void draw_grainsize();

/*****************************************************************/
/** The following provide the data structures that declare the 	**/
/** menu.							**/
/*****************************************************************/
static xs_menu_struct grainsize_file_entries[] = {
        {"Quit", intermediate_quit_callback, 0}
};
static xs_menu_struct grainsize_file[] = {
        {"File     ", NULL, 0,
                grainsize_file_entries, XtNumber(grainsize_file_entries), ""}
};

static xs_menu_struct grainsize_edit_entries[] = {
        {"Clear All", clearall_callback, 0}
};
static xs_menu_struct grainsize_edit[] = {
        {"Edit     ", NULL, 0,
                grainsize_edit_entries, XtNumber(grainsize_edit_entries), ""}
};



/*****************************************************************/
/** Create the options menu.									**/
/*****************************************************************/
create_grainsize_struct(chare_list, number_chares)
CHARE *chare_list;
int number_chares;
{
	int i, j, k;
	ENTRY_LIST *list;
	xs_menu_struct *grainsize_menu;

	grainsize_xs_struct = (xs_menu_struct *) malloc(sizeof(xs_menu_struct));
	grainsize_xs_struct[0].name = (char *) malloc(strlen("View") + 1);
	strcpy(grainsize_xs_struct[0].name, "View");
	grainsize_xs_struct[0].func = NULL;
	grainsize_xs_struct[0].data = 0;
    grainsize_xs_struct[0].n_sub_items = number_chares-3;
    grainsize_xs_struct[0].sub_menu = (xs_menu_struct *)
                malloc((number_chares-3)*sizeof(xs_menu_struct));
    grainsize_xs_struct[0].sub_menu_title = (char *) malloc(strlen("")+1);
    strcpy(grainsize_xs_struct[0].sub_menu_title, "");

	grainsize_menu = (xs_menu_struct *) grainsize_xs_struct[0].sub_menu;
	for (i=3,k=0; i<number_chares; i++,k++)
	{
		grainsize_menu[k].name = (char *) 
					malloc(strlen(chare_list[i]. name) + 1);
		strcpy(grainsize_menu[k].name, chare_list[i]. name);
		grainsize_menu[k].func = NULL;
		grainsize_menu[k].data = 0;
		grainsize_menu[k].n_sub_items = chare_list[i].number_entries;
		grainsize_menu[k].sub_menu = (xs_menu_struct *)
				malloc(chare_list[i].number_entries*sizeof(xs_menu_struct));
		grainsize_menu[k].sub_menu_title = (char *) malloc(strlen("")+1); 
		strcpy(grainsize_menu[k].sub_menu_title, ""); 

		list = chare_list[i].list;
		for (j=0; j<chare_list[i].number_entries; j++)
		{
			xs_menu_struct *sub;

			if (list == NULL) 
				printf("*** ERROR *** Incorrect state file information.\n");

			sub = &(grainsize_menu[k].sub_menu[j]);
       		sub->name = (char *) malloc(strlen(list->name) + 1);
        	strcpy(sub->name, list->name);
        	sub->func = draw_grainsize;
        	sub->data = list->index;
        	sub->n_sub_items = 0;
			sub->sub_menu = NULL;
       		sub->sub_menu_title = (char *) malloc(strlen("")+1);
        	strcpy(sub->sub_menu_title, "");

			list = list->next;
		}
	}
}





/*****************************************************************/
/** This function sets xscale and xsteps.			**/
/*****************************************************************/
grainsize_set_xscale_and_xstep( height, divisons, step, scale)
int height, divisons, *step, *scale;
{
	int temp_divisons;

	*step = 1;
	if (divisons-1 > XMAXDIVISONSPERPAGE)
	{
		*step = (divisons-1) / XMAXDIVISONSPERPAGE + 1; 
		temp_divisons = (divisons - 1)/ (*step) + 1;
		*scale = (height - 2*XBOUNDARY) / temp_divisons + 1; 
	}
	else
		*scale = (height - 2*XBOUNDARY) / (divisons-1) + 1; 
}


/*****************************************************************/
/** This function sets up various parameters for the drawing of	**/
/** histograms.							**/
/*****************************************************************/
set_grainsize_parameters(data, begin_pe, end_pe, begin_stages, end_stages)
graphics_data *data;
int begin_pe; 
int end_pe; 
int begin_stages; 
int end_stages;
{
	int i, j;
	int table;
	int min, max;


	max = 0;
	min = 9999999;

	switch (data->view_type) {

	case OVERVIEW_PE:
		data->xdivisons = end_pe - begin_pe+ 1;
		data->start_xdivs = begin_pe;
		data->finish_xdivs = end_pe;
		data->xtitle = "PROCESSORS";
    	for (table=0; table<number_entries; table++)
        	if (data->ep_p_chosen[table])
           		for (i=begin_pe; i<=end_pe; i++) {
					int total, number;
					total = number = 0;
					for (j=begin_stages; j<=end_stages; j++) {
						total += grainsize_table[table].list[i][j].sum;
						number += grainsize_table[table].list[i][j].no;
					}
					if (number) total /= (1000*number);
					else total = 0;
                	MIN_MAX(total, min, max);
				}
		break;

	case OVERVIEW_STAGE:
		data->xdivisons = end_stages - begin_stages+ 1;
		data->start_xdivs = begin_stages;
		data->finish_xdivs = end_stages;
		data->xtitle = "STAGES";
    	for (table=0; table<number_entries; table++)
        	if (data->ep_p_chosen[table])
           		for (i=begin_stages; i<=end_stages; i++) {
					int total, number;
					total = number = 0;
					for (j=begin_pe; j<=end_pe; j++) {
						total += grainsize_table[table].list[j][i].sum;
						number += grainsize_table[table].list[j][i].no;
					}
					if (number) total /= (1000*number);
					else total = 0;
                	MIN_MAX(total, min, max);
				}
		break;

	}

	if (min > max) { min = 0; max = 1; }
	data->min = min;
	data->max = max;

	data->begin_pe = begin_pe;
	data->end_pe = end_pe;
	data->begin_stages = begin_stages;
	data->end_stages = end_stages;

	data->ydivisons	= (max - min + 1);

	grainsize_set_xscale_and_xstep( data->xheight, data->xdivisons,
		&data->xstep, &data->xscale); 
	set_yscale_and_ystep( data->yheight, data->ydivisons, 
		&data->ystep, &data->yscale);
}


/*****************************************************************/
/** This function is used to resize windows on receving a resize */
/** request.							**/
/*****************************************************************/
void resize_grainsize_callback(w, data, call_data)
Widget w;
graphics_data *data;
XmDrawingAreaCallbackStruct call_data;
{
	int n;
	Arg wargs[10];
	Dimension xheight, yheight;

	n=0;
	XtSetArg(wargs[n], XtNwidth, &xheight); n++;
	XtSetArg(wargs[n], XtNheight, &yheight); n++;
	XtGetValues(data->canvas2, wargs, n);

	if ((data->xheight != xheight) || (data->yheight == yheight))
	{
		data->xheight = xheight;
		data->yheight = yheight;

		set_grainsize_parameters(data, data->begin_pe, data->end_pe,
			data->begin_stages, data->end_stages);

		draw_grainsize(data); 
	}
}


/*****************************************************************/
/** This is called when the OverView button is clicked.		**/
/*****************************************************************/
void grainsize_callback(w, temp_data, call_data)
Widget w;
int temp_data;
XmAnyCallbackStruct *call_data;
{
	int i;
	int n;
	Arg wargs[10];
	graphics_data *data;
	XSetWindowAttributes w_attr;

	Widget shell2;
	Widget menu_bar;  
	Widget framework2;
	Widget main_window2;
	Widget parameters;
	Widget canvas_frame;
    Widget legend_scroll;

	switch (temp_data) {
	case OVERVIEW_PE:
		if (number_pe == 1) {
			printf("***ERROR*** Too Few Processors.\n");
			return;
		}
		break;
	case OVERVIEW_STAGE:
 		if (stages == 1) {
			printf("***ERROR*** Too Few Stages.\n");
			return;
		}
		break;
	}

	n=0;
    XtSetArg(wargs[n], XtNtitle, "OverView"); n++;
	shell2 = XtCreateApplicationShell("shell2", topLevelShellWidgetClass,
			wargs, n);

	n=0;
	main_window2 = XmCreateMainWindow(shell2, "main_window2", wargs, n);
	XtManageChild(main_window2);

	n=0;
	XtSetArg(wargs[n], XmNmarginWidth, 2); n++;
	XtSetArg(wargs[n], XmNmarginHeight, 2); n++;
	XtSetArg(wargs[n], XmNshadowThickness, 1); n++;
	XtSetArg(wargs[n], XmNshadowType, XmSHADOW_OUT); n++;
	framework2 = XtCreateManagedWidget("framework2",
			xmFormWidgetClass,
			main_window2, wargs, n);

	/*************************************************/
	/** Allocate the data area here, because it's	**/
	/** going to be used before it is actually used.**/
	/*************************************************/
	data = (graphics_data *) malloc(sizeof(graphics_data));

	/*************************************************/
	/** Create the canvas frame.			**/
	/*************************************************/
	canvas_frame = XtCreateManagedWidget("canvas_frame",
			xmFrameWidgetClass,
			framework2, NULL, 0);
	create_and_init_canvas(canvas_frame, &data->canvas2, &data->gc2, data);

    n=0;
    XtSetArg(wargs[n], XmNscrollingPolicy, XmAUTOMATIC); n++;
    XtSetArg(wargs[n], XtNheight, LEGEND_SCROLL_HEIGHT); n++;
    legend_scroll = XtCreateManagedWidget("legend_scroll",
                    xmScrolledWindowWidgetClass,
                    framework2, wargs, n);
    create_and_init_canvas(legend_scroll, &data->legend, &data->lgc, data);
    n=0;
    XtSetArg(wargs[n], XmNworkWindow, data->legend); n++;
    XtSetValues(legend_scroll, wargs, n);


	/*************************************************/
	/** Now create the graphics data, and set up	**/
	/** parameters for this call.			**/
	/*************************************************/
	windows[current_window_pos++] = data;
	data->shell = shell2;
	data->xheight 	= XHEIGHT;
	data->yheight	= YHEIGHT;
	data->current = 0;
	data->view_type = temp_data;
	data->type = GRAINSIZE;
	for (i=0; i<NUMBER_DISPLAYS; i++) data->chosen[i]=0;
    for (i=0; i<number_entries; i++) {
		data->ep_c_chosen[i]=0;
		data->ep_p_chosen[i]=0;
	}
	set_grainsize_parameters(data, 0, number_pe-1, 0, stages-1);

	/*************************************************/
	/** Now initialize some of the canvas parametes.**/
	/*************************************************/
	w_attr.backing_store = Always;


	/*************************************************/
	/** Create the frame containing the quit and the**/
	/** parameters buttons.				**/
	/*************************************************/
	menu_bar = XmCreateMenuBar(main_window2, "menu_bar", NULL, 0);
	XtManageChild(menu_bar);

    data->no_toggle_buttons = 0;
    data->toggle_buttons = (WidgetList)  XtMalloc(sizeof(Widget)* 
        count_toggle_buttons(grainsize_xs_struct, 1, data));

    data_xs_create_menu_buttons(menu_bar, grainsize_file,
                                XtNumber(grainsize_file), data);
    data_xs_create_menu_buttons(menu_bar, grainsize_edit,
                                XtNumber(grainsize_edit), data);
    data_toggle_buttons(menu_bar, grainsize_xs_struct, 1, data);



	n=0;
	XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_FORM); n++;
	XtSetArg(wargs[n], XmNbottomAttachment, XmATTACH_WIDGET); n++;
    XtSetArg(wargs[n], XmNbottomWidget, legend_scroll); n++;
	XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_FORM); n++;
	XtSetArg(wargs[n], XmNrightAttachment, XmATTACH_FORM); n++;
	XtSetValues(canvas_frame, wargs, n);

    n=0;
    XtSetArg(wargs[n], XmNrightAttachment, XmATTACH_FORM); n++;
    XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_FORM); n++;
    XtSetArg(wargs[n], XmNbottomAttachment, XmATTACH_FORM); n++;
    XtSetValues(legend_scroll, wargs, n);

    n=0;
    XtSetArg(wargs[n], XtNwidth, XHEIGHT); n++;
    XtSetValues(data->legend, wargs, n);


	n=0;
	XtSetArg(wargs[n], XtNwidth, data->xheight); n++;
	XtSetArg(wargs[n], XtNheight, data->yheight); n++;
	XtSetValues(data->canvas2, wargs, n);
	XtAddCallback(data->canvas2, XmNresizeCallback,
			resize_grainsize_callback, data);

	XtRealizeWidget(shell2);
	XChangeWindowAttributes(XtDisplay(data->canvas2), XtWindow(data->canvas2),
			CWBackingStore, &w_attr);
    XChangeWindowAttributes(XtDisplay(data->legend), XtWindow(data->legend),
               CWBackingStore, &w_attr);
}

