/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: expert.c,v $
 *	$Author: sanjeev $	$Locker:  $		$State: Exp $
 *	$Revision: 1.3 $	$Date: 1995/09/21 21:09:15 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: expert.c,v $
 * Revision 1.3  1995/09/21 21:09:15  sanjeev
 * *** empty log message ***
 *
 * Revision 1.2  1995/02/24  23:22:53  jyelon
 * *** empty log message ***
 *
 ***************************************************************************/
static char ident[] = "@(#)$Header: /expand1/cvsroot/projections/sources/callbacks/expert.c,v 1.3 1995/09/21 21:09:15 sanjeev Exp $";
#include "head.h"
#include "xs.h"
#include "data.h"
#include "common.h"
#include <Xm/FileSB.h>

void parameters_callback();
void expert_quit_callback();
void expert_save_callback();
void expert_cancel_callback();
void expert_summary_callback();
void intermediate_quit_callback();

/*****************************************************************/
/** This is used to set up the menu.				**/
/*****************************************************************/

static xs_menu_struct expert_file_entries[] = {
        {"Save", expert_save_callback, 0},
        {"Quit", expert_quit_callback, 0}
};

static xs_menu_struct expert_file[] = {
        {"File     ", NULL, 0,
                expert_file_entries, XtNumber(expert_file_entries), ""}
};

static xs_menu_struct expert_edit_entries[] = {
        {"Set Parameters", parameters_callback, 0} };

static xs_menu_struct expert_edit[] = {
        {"Edit     ", NULL, 0,
                expert_edit_entries, XtNumber(expert_edit_entries), ""} };

static xs_menu_struct expert_view_entries[] = {
	{"Summary Analysis", expert_summary_callback, 0}
};

static xs_menu_struct expert_view[] = {
        {"View     ", NULL, 0,
                expert_view_entries, XtNumber(expert_view_entries), ""} };



/*****************************************************************/
/** This callback is called when the expert button is clicked   **/
/*****************************************************************/
void expert_quit_callback(w, data, cbs)
Widget w;
graphics_data *data;
XmAnyCallbackStruct *cbs;
{
	free(my_string);
	XtDestroyWidget(data->shell);
}


void expert_save_callback(w, data, cbs)
Widget w;
graphics_data *data;
XmAnyCallbackStruct *cbs;
{
	Widget dialog;
	void expert_ok_callback();

	dialog = XmCreateFileSelectionDialog(data->shell, "filesb", NULL, 0);	
	XtAddCallback(dialog, XmNokCallback, expert_ok_callback, data); 
	XtAddCallback(dialog, XmNcancelCallback, expert_cancel_callback, NULL); 
	XtManageChild(dialog);
}

void expert_cancel_callback(w, data, cbs)
Widget w;
graphics_data *data;
XmFileSelectionBoxCallbackStruct *cbs;
{
	XtDestroyWidget(w);
}

void expert_ok_callback(w, data, cbs)
Widget w;
graphics_data *data;
XmFileSelectionBoxCallbackStruct *cbs;
{
	FILE *f;
	char *filename;
	extern int SummaryExpert();

	if (!XmStringGetLtoR(cbs->value, XmSTRING_DEFAULT_CHARSET, &filename))
		return;
	if (!*filename) {
		XtFree(filename);
		return;
	}
	f = fopen(filename, "w");
	if (!f) {
		printf("*** ERROR *** Cannot open file %s\n", filename);
		return;
	}
	fprintf(f, "%s\n", my_string); 
	fclose(f);
	XtDestroyWidget(w);
}


void expert_summary_callback(w, data, call_data)
Widget w;
graphics_data *data;
XmAnyCallbackStruct *call_data;
{
	extern int SummaryExpert();

	SummaryExpert(data); 
    XmTextSetString(data->information, my_string);
}


create_expert_window(w, temp_data, call_data)
Widget w;
int temp_data;
XmAnyCallbackStruct *call_data;
{
	int i;
	int n;
	Arg wargs[10];
    XGCValues values;
	graphics_data *data;
	XSetWindowAttributes w_attr;

	Widget shell1, main_window1, menu_bar; 
	Widget scrolled_text, information_frame;



	/*************************************************/
	/** Create the widget tree.						**/
	/*************************************************/
	n=0;
    XtSetArg(wargs[n], XtNtitle, "expert"); n++;
	XtSetArg(wargs[n], XmCNoResize, TRUE); n++;
	shell1 = XtCreateApplicationShell("shell1",
			topLevelShellWidgetClass, wargs, n);

	main_window1 = XmCreateMainWindow(shell1, "main_window1",
				NULL, 0);
	XtManageChild(main_window1);

	information_frame = XtCreateManagedWidget("information_frame",
				xmFrameWidgetClass, main_window1, NULL, 0);

    n=0;
    XtSetArg(wargs[n], XmNeditable, FALSE); n++;
    XtSetArg(wargs[n], XmNrows, 15); n++;
    XtSetArg(wargs[n], XmNcolumns, 70); n++;
    XtSetArg(wargs[n], XmNeditMode, XmMULTI_LINE_EDIT); n++;
    scrolled_text = XmCreateScrolledText(information_frame,
					 "scrolled", wargs, n);

	/*************************************************/
	/** Allocate the data area here, because it's	**/
	/** going to be used before it is actually used.**/
	/*************************************************/
	data = (graphics_data *) malloc(sizeof(graphics_data));
	data->information = scrolled_text;
	data->type = EXPERT;
	data->begin_stages = 0;
	data->end_stages = stages - 1;
	data->begin_pe = 0;
	data->end_pe = number_pe - 1;

	/*************************************************/
	/** Create the frame containing the quit button **/
	/*************************************************/
	menu_bar = XmCreateMenuBar(main_window1, "menu_bar", NULL, 0);
	XtManageChild(menu_bar);
	data_xs_create_menu_buttons(menu_bar, expert_file,
				XtNumber(expert_file), data);
	/*
	data_xs_create_menu_buttons(menu_bar, expert_edit,
				XtNumber(expert_edit), data);
	*/
	data_xs_create_menu_buttons(menu_bar, expert_view,
				XtNumber(expert_view), data);

	/*************************************************/
	/** No output **/
	/*************************************************/
	my_string = (char *) malloc(strlen("") + 1);
	strcpy(my_string, "");
	save_string = my_string;

	/*************************************************/
	/** Now create the graphics data, and set up	**/
	/** parameters for this call.			**/
	/*************************************************/
	windows[current_window_pos++] = data;
	data->shell = shell1;

    XtManageChild(scrolled_text);
	XtRealizeWidget(shell1);
}
