/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: common.c,v $
 *	$Author: sanjeev $	$Locker:  $		$State: Exp $
 *	$Revision: 1.5 $	$Date: 1995/09/22 20:06:19 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: common.c,v $
 * Revision 1.5  1995/09/22 20:06:19  sanjeev
 * *** empty log message ***
 *
 * Revision 1.4  1995/09/22  19:48:12  sanjeev
 * chare numbers 0, 1, 2 need to be ignored
 *
 * Revision 1.3  1995/09/21  21:09:15  sanjeev
 * *** empty log message ***
 *
 * Revision 1.2  1995/02/24  23:22:53  jyelon
 * *** empty log message ***
 *
 ***************************************************************************/
static char ident[] = "@(#)$Header: /expand1/cvsroot/projections/sources/callbacks/common.c,v 1.5 1995/09/22 20:06:19 sanjeev Exp $";
#include "head.h"
#include "common.h"
#include "xs.h"
#include "graphics.h"

#define BORDER_WIDTH 1

void ep_choice();

/*****************************************************************/
/** This macro checks whether the first quantity is between     **/
/** 0 and (second_quantity - 1).                                **/
/*****************************************************************/
check_for_range(first, second)
int first, second;
{
        if ((first<0) && (first>second-1))
                return 0;
        else
                return 1;
}



/*****************************************************************/
/** Check whether a required value is within range.  **/
/*****************************************************************/
within_range(i, n1, n2)
int i, n1, n2;
{
	if (i>=n1 && i<=n2)
		return 1;
	return 0;
}


/*****************************************************************/
/** This quit function is called when an intermediate		**/
/** has to be quit.						**/
/*****************************************************************/
void intermediate_quit_callback(w, data, call_data)
Widget w;
graphics_data *data;
XmAnyCallbackStruct *call_data;
{
	XtDestroyWidget(data->shell); 
}

/*****************************************************************/
/** This function sets yscale and ysteps.                       **/
/*****************************************************************/
set_yscale_and_ystep( height, divisons, step, scale)
int height, divisons, *step, *scale;
{
        int temp_divisons;

        *step = 1;
        if (divisons > YMAXDIVISONS)
        {
                *step = int_ceil(divisons,YMAXDIVISONS); 
                temp_divisons = int_ceil(divisons,(*step)); 
                *scale = int_ceil((height - YBOUNDARY),temp_divisons);
        }
        else
                *scale = int_ceil((height - YBOUNDARY),divisons); 
}

/*****************************************************************/
/* Reset the toggle buttons.									**/
/*****************************************************************/
reset_toggle_buttons(data)
graphics_data *data;
{
	int i;
	for (i=0; i<data->no_toggle_buttons; i++) 
		XmToggleButtonSetState(data->toggle_buttons[i], False, False);
}

/*****************************************************************/
/** Clear the canvas area and start afresh.			**/
/*****************************************************************/
void clearall_callback(w, data, call_data)
Widget w;
graphics_data *data;
XmAnyCallbackStruct *call_data;
{
	int i;

	XClearArea(XtDisplay(data->canvas2), XtWindow(data->canvas2),
                        0, 0, 0, 0, FALSE);
	for (i=0; i<NUMBER_DISPLAYS; i++)
		data->chosen[i] = 0;
	for (i=0; i<number_entries; i++)
		data->ep_c_chosen[i] = data->ep_p_chosen[i] = 0;

    switch (data->type) {

        case TOTAL_PE:
        case TOTAL_STAGE:
        case CONSTANT_PE:
        case CONSTANT_STAGE:
			reset_toggle_buttons(data);
			XClearArea(XtDisplay(data->legend),
							 XtWindow(data->legend), 0, 0, 0, 0, FALSE);
            break;

        case OVERVIEW_PE:
        case OVERVIEW_STAGE:
		case UTIL_PE:
		case UTIL_STAGE:
			reset_toggle_buttons(data);
			XClearArea(XtDisplay(data->legend),
							 XtWindow(data->legend), 0, 0, 0, 0, FALSE);
			break;

		case GRAINSIZE:
			reset_toggle_buttons(data);
			XClearArea(XtDisplay(data->legend),
							 XtWindow(data->legend), 0, 0, 0, 0, FALSE);
			break;
	}
}


/*****************************************************************/
/** Create quit button.						**/
/*****************************************************************/
create_quit_button(menu_bar, shell)
Widget menu_bar;
Widget shell;
{
	int n;
	Arg wargs[10];
	Widget menu_pane1, quit, cascade;

        menu_pane1 = XmCreatePulldownMenu(menu_bar, "menu_pane1",
                        NULL, 0);
        quit = XmCreatePushButton(menu_pane1, "Quit  ", NULL, 0);
        XtManageChild(quit);
        XtAddCallback(quit, XmNarmCallback,
                        intermediate_quit_callback, shell);
        n=0;
        XtSetArg(wargs[n], XmNsubMenuId, menu_pane1); n++;
        cascade = XmCreateCascadeButton(menu_bar, "Exit   ", wargs,
                                n);
        XtManageChild(cascade);
}


/*****************************************************************/
/** Create the options menu.									**/
/*****************************************************************/
create_options_struct(chare_list, number_chares)
CHARE *chare_list;
int number_chares;
{
	int i, j, k;
	ENTRY_LIST *list;
	xs_menu_struct *options_menu;

	options_xs_struct = (xs_menu_struct *) malloc(sizeof(xs_menu_struct));
	options_xs_struct[0].name = (char *) malloc(strlen("View-User-Attributes") 
													+ 1);
	strcpy(options_xs_struct[0].name, "View-User-Attributes");
	options_xs_struct[0].func = NULL;
	options_xs_struct[0].data = 0;
    options_xs_struct[0].n_sub_items = number_chares-3;
    options_xs_struct[0].sub_menu = (xs_menu_struct *)
                malloc((number_chares-3)*sizeof(xs_menu_struct));
    options_xs_struct[0].sub_menu_title = (char *) malloc(strlen("")+1);
    strcpy(options_xs_struct[0].sub_menu_title, "");

	options_menu = (xs_menu_struct *) options_xs_struct[0].sub_menu;
	for (i=3,k=0; i<number_chares; i++,k++)
	{
		options_menu[k].name = (char *) 
					malloc(strlen(chare_list[i]. name) + 1);
		strcpy(options_menu[k].name, chare_list[i]. name);
		options_menu[k].func = NULL;
		options_menu[k].data = 0;
		options_menu[k].n_sub_items = chare_list[i].number_entries;
		options_menu[k].sub_menu = (xs_menu_struct *)
				malloc(chare_list[i].number_entries*sizeof(xs_menu_struct));
		options_menu[k].sub_menu_title = (char *) malloc(strlen("")+1); 
		strcpy(options_menu[k].sub_menu_title, ""); 

		list = chare_list[i].list;
		for (j=0; j<chare_list[i].number_entries; j++)
		{
			xs_menu_struct *sub, *t0, *t1;

			if (list == NULL) 
				printf("*** ERROR *** Incorrect state file information.\n");

			sub = &(options_menu[k].sub_menu[j]);
       		sub->name = (char *) malloc(strlen(list->name) + 1);
        	strcpy(sub->name, list->name);
        	sub->func = NULL;
        	sub->data = 0;
        	sub->n_sub_items = 2;
			sub->sub_menu = (xs_menu_struct *)
				malloc(2*sizeof(xs_menu_struct));
       		sub->sub_menu_title = (char *) malloc(strlen("")+1);
        	strcpy(sub->sub_menu_title, "");

			t0 = &(sub->sub_menu[0]);
			t1 = &(sub->sub_menu[1]);

			t0->name = (char *) malloc(strlen("Creation")+1);
			strcpy(t0->name, "Creation");
			t0->func = ep_choice;
			t0->data = -(list->index)-1;
			t0->sub_menu = NULL;
			t0->n_sub_items = 0;
			t0->sub_menu_title = (char *) malloc(strlen("")+1);
			strcpy(t0->sub_menu_title, "");

			t1->name = (char *) malloc(strlen("Processing")+1);
			strcpy(t1->name, "Processing");
			t1->func = ep_choice;
			t1->data = list->index;
			t1->sub_menu = NULL;
			t1->n_sub_items = 0;
			t1->sub_menu_title = (char *) malloc(strlen("")+1);
			strcpy(t1->sub_menu_title, "");

			list = list->next;
		}
	}
}


/*****************************************************************/
/** Choose an entry point.                                      **/
/*****************************************************************/
void ep_choice(w, data, call_data)
Widget w;
graphics_data *data;
XmAnyCallbackStruct *call_data;
{
        int n, i;
        Arg wargs[10];

        n=0;
        XtSetArg(wargs[n], XmNuserData, &i); n++;
        XtGetValues(w, wargs, n);

		if (i < 0)
        	if (data->ep_c_chosen[-i-1])
                data->ep_c_chosen[-i-1] = 0;
        	else
                data->ep_c_chosen[-i-1] = 1;
		else
        	if (data->ep_p_chosen[i])
                data->ep_p_chosen[i] = 0;
        	else
                data->ep_p_chosen[i] = 1;

		switch (data->view_type) {

		case OVERVIEW: 
						draw_overview(data);
						break;
		case DETAILED_VIEW:
        				draw_display(data, data->type);
						break;
		}
}


create_and_init_canvas(parent, w, gc, data)
Widget parent, *w;
GC *gc;
graphics_data *data;
{
        Arg wargs[5];
        XGCValues values;

    	*w = XtCreateManagedWidget("canvas", xmDrawingAreaWidgetClass,
            				parent, NULL, 0);

        XtSetArg(wargs[0], XtNforeground, &data->foreground);
        XtSetArg(wargs[1], XtNbackground, &data->background);
        XtGetValues(*w, wargs, 2);
        values.foreground = data->foreground;
        values.background = data->background;
        values.fill_style = FillSolid;
        *gc = XtGetGC(*w, GCForeground | GCBackground | GCFillStyle,
                        &values);

}
