/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: animation.c,v $
 *	$Author: sanjeev $	$Locker:  $		$State: Exp $
 *	$Revision: 1.3 $	$Date: 1995/09/21 21:09:15 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: animation.c,v $
 * Revision 1.3  1995/09/21 21:09:15  sanjeev
 * *** empty log message ***
 *
 * Revision 1.2  1995/02/24  23:22:53  jyelon
 * *** empty log message ***
 *
 ***************************************************************************/
static char ident[] = "@(#)$Header: /expand1/cvsroot/projections/sources/callbacks/animation.c,v 1.3 1995/09/21 21:09:15 sanjeev Exp $";
#include "head.h"
#include "common.h"
#include "xs.h"
#include "graphics.h"
#include "animation.h"

/*****************************************************************/
/** These define menu.						**/
/*****************************************************************/
static xs_menu_struct animation_file_entries[] = {
        {"Quit", intermediate_quit_callback, 0}
};

static xs_menu_struct animation_file[] = {
        {"File     ", NULL, 0,
                animation_file_entries, XtNumber(animation_file_entries), ""}
};

static xs_menu_struct animation_edit_entries[] = {
        {"Clear All", clearall_callback, 0},
        {"Set Parameters", parameters_callback, 0}
};

static xs_menu_struct animation_edit[] = {
        {"Edit     ", NULL, 0,
                animation_edit_entries, XtNumber(animation_edit_entries), ""}
};

static xs_menu_struct animation_view_entries[] = {
        {"Ring", animation_choice, RING},
        {"Spanning Tree", animation_choice, SPANNING_TREE},
        {"Square Mesh", animation_choice, SQUARE_MESH},
        {"3-Dimensional Mesh", animation_choice, THREE_D_MESH}
 };

static xs_menu_struct animation_view[] = {
        {"View", NULL, 0,
                 animation_view_entries, XtNumber(animation_view_entries), ""}
};



/*****************************************************************/
/** Choose this widget.						**/
/*****************************************************************/
void animation_choice(w, data, call_data)
Widget w;
graphics_data *data;
int *call_data;
{
	int n;
	int i;
	Arg wargs[10];

	n=0;
	XtSetArg(wargs[n], XmNuserData, &i); n++;
	XtGetValues(w, wargs, n);

	draw_animation(data, i);
}


/*****************************************************************/
/** This is to create the choices for the animation.		**/
/*****************************************************************/
void create_animation_choice(selection, choice, i, data)
Widget selection;
char *choice;
int i;
graphics_data *data;
{
	int n;
	Widget w;
	Arg wargs[10];

	n=0;
	XtSetArg(wargs[n], XmNuserData, i); n++;
	w = XtCreateManagedWidget(choice, xmToggleButtonWidgetClass, 
			selection, wargs,  n);
	XtAddCallback(w, XmNarmCallback,  animation_choice, data);
}



/*****************************************************************/
/** This function is used to resize windows on receving a resize */
/** request.							**/
/*****************************************************************/
void resize_animation_callback(w, data, call_data)
Widget w;
graphics_data *data;
XmDrawingAreaCallbackStruct call_data;
{
	int n;
	Arg wargs[10];
	Dimension xheight, yheight;

	n=0;
	XtSetArg(wargs[n], XtNwidth, &xheight); n++;
	XtSetArg(wargs[n], XtNheight, &yheight); n++;
	XtGetValues(data->canvas1, wargs, n);

	if ((data->xheight != xheight) || (data->yheight == yheight))
	{
		data->xheight = xheight;
		data->yheight = yheight;
	}
}

/*****************************************************************/
/** This callback is called when the button on the processor is **/
/** clicked for any of the selections. temp_data is the name of **/
/** the selection. A shell is created, and the canvas widget is **/
/** created as a child of this shell.				**/
/*****************************************************************/
void animation_callback(w, temp_data, call_data)
Widget w;
int temp_data;
XmAnyCallbackStruct *call_data;
{
	int n;
	Arg wargs[10];
	graphics_data *data;
	XSetWindowAttributes w_attr;

	Widget shell5, framework5, main_window5, menu_bar, parameters, quit,
			canvas_frame;


	n=0;
	XtSetArg(wargs[n], XtNtitle,
		"Percent Busy"); n++;
	shell5 = XtCreateApplicationShell("shell5",
			topLevelShellWidgetClass,
			wargs, n);

	main_window5 = XmCreateMainWindow(shell5, "main_window5",
				NULL, 0);
	XtManageChild(main_window5);

	n=0;
	XtSetArg(wargs[n], XmNmarginWidth, 2); n++;
	XtSetArg(wargs[n], XmNmarginHeight, 2); n++;
	XtSetArg(wargs[n], XmNshadowThickness, 1); n++;
	XtSetArg(wargs[n], XmNshadowType, XmSHADOW_OUT); n++;
	framework5 = XtCreateManagedWidget("framework5",
			xmFormWidgetClass,
			main_window5, wargs, n);

	/*************************************************/
	/** Allocate the data area here, because it's	**/
	/** going to be used before it is actually used.**/
	/*************************************************/
	data = (graphics_data *) malloc(sizeof(graphics_data));

	/*************************************************/
	/** Create the canvas and the command frames.	**/
	/*************************************************/
	n=0;
	canvas_frame = XtCreateManagedWidget("canvas_frame",
			xmFrameWidgetClass,
			framework5, NULL, 0);
	create_and_init_canvas(canvas_frame, &data->canvas1, &data->gc1, data);


	/*************************************************/
	/** Create the frame containing the quit and the**/
	/** parameters buttons.				**/
	/*************************************************/
	menu_bar = XmCreateMenuBar(main_window5, "menu_bar", NULL, 0);
	XtManageChild(menu_bar);

	data_xs_create_menu_buttons(menu_bar, animation_file, 
			XtNumber(animation_file), data);
	data_xs_create_menu_buttons(menu_bar, animation_edit, 
			XtNumber(animation_edit), data);
	data_xs_create_menu_buttons(menu_bar, animation_view, 
			XtNumber(animation_view), data);

	/*************************************************/
	/** Now create the graphics data, and set up	**/
	/** parameters for this call.			**/
	/*************************************************/
	windows[current_window_pos++] = data;
	data->shell = shell5;
	data->xheight 	= HEIGHT;
	data->yheight	= HEIGHT;
	data->type	= GRID;
	data->begin_pe = 0;
	data->end_pe = number_pe - 1;
	data->begin_stages = 0;
	data->end_stages = stages - 1;
	data->current = 0;



	/*************************************************/
	/** Now initialize some of the canvas parametes.**/
	/*************************************************/
	w_attr.backing_store = Always;
	n=0;
	XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_FORM); n++;
	XtSetArg(wargs[n], XmNbottomAttachment, XmATTACH_FORM); n++;
	XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_FORM); n++;
	XtSetArg(wargs[n], XmNrightAttachment, XmATTACH_FORM); n++;
	XtSetValues(canvas_frame, wargs, n);

	n=0;
	XtSetArg(wargs[n], XtNwidth, data->xheight); n++;
	XtSetArg(wargs[n], XtNheight, data->yheight); n++;
	XtSetValues(data->canvas1, wargs, n);
	XtAddCallback(data->canvas1, XmNresizeCallback,
			resize_animation_callback, data);

	XtRealizeWidget(shell5);
        XChangeWindowAttributes(XtDisplay(data->canvas1),
				XtWindow(data->canvas1),
				CWBackingStore, &w_attr);
}

