/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: wait.c,v $
 *	$Author: jyelon $	$Locker:  $		$State: Exp $
 *	$Revision: 1.2 $	$Date: 1995/02/24 23:22:35 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: wait.c,v $
 * Revision 1.2  1995/02/24 23:22:35  jyelon
 * *** empty log message ***
 *
 ***************************************************************************/
static char ident[] = "@(#)$Header: /expand1/cvsroot/projections/sources/analyse/wait.c,v 1.2 1995/02/24 23:22:35 jyelon Exp $";
#include "head.h"
#include "common.h"
#include "analyse.h"
#include "data.h"
#include "shared.h"
#include <math.h>


static int benefit=0;


/*************************************************************/
/* Wait analysis follows									**/
/*************************************************************/
WaitAnalysis(data, t1, t2, p1, p2)
graphics_data *data;
TRANSACTION *t1, *t2;
int p1, p2;
{
	int i;
	int both;
	int idx1, idx2;
	int total_ep_string_length=0;
	TRANSACTION *temp, *tenq, *tdeq;
	TRANSACTION_LIST *SequentialChain();
	unsigned int wait, tolerable, overlap;
	int is_there_a_problem = HAVE_NO_PROBLEM;
	TRANSACTION_LIST *current, *previous, *tlist;

 	tolerable = machine_table[machine_type].alpha +
			 	machine_table[machine_type].beta*1;


	for (current=critical_list; current && current->ptr!=t2; 
				current=current->next);
	/* Should not look at sync. element, so let's skip it */
	/* Go back from last event, and check for events that could overlap */
	/* current->ptr is t1 */
	if (!current) printf("*** ERROR *** Illegal synchronization point.\n");
	for (; current && current->ptr!=t1; current=previous) {
		
		previous = current->previous;

		/*************************/
		/** find first element on critical path which is scheduled **/
		/** on an idle processor. further current must be as a result **/
		/** of some system functionality, like quiescence. **/
		/*************************/
		idx1 = get_ep_index(current->ptr->info->ep, current->ptr->info->msg_type);
		if (idx1 == -1) break;
		if (current->ptr->queue!=0) continue;
		if (current->ptr->info->creator == current->ptr->info->ptrp1) break;
		if (!current->ptr->info->creator) continue;

		/*************************/
		/** find waiting period **/
		/*************************/
		wait = 0;
		for (temp=current->ptr; temp; temp=temp->previous) {
			if (temp->type != END_PROCESSING) continue;
			idx2 = get_ep_index(temp->info->ep, temp->info->msg_type);
			if (idx2 == -1) continue;
		
			wait = current->ptr->info->timep1 - temp->info->timep2;
			break;
		}

		if (wait<tolerable) continue;

		ComputeTimes(current->ptr);

		/*************************/
		/** wait was not tolerable **/
		/** determine cause of wait **/
		/*************************/
		temp = current->ptr->info->creator;
		idx2 = -1;
		if (temp) idx2 = get_ep_index(temp->info->ep, temp->info->msg_type);
		if (idx2 == -1) continue;

		tlist=SequentialChain(current, p1, p2);
		if (tlist) {
			previous=tlist;
			continue;
		}
		if (Bottleneck(current->ptr, t1, t2,  p1, p2)) continue;

		switch (current->ptr->info->msg_type) {
		case NewChareMsg:
			evaluate_ldb=1;
			break;

		case ForChareMsg:
			break;

		case BocMsg:
			overlap = DetermineOverlap(current->ptr->info->timec,
							current->ptr->info->timep1, p1, p2); 
			TailEndWait(idx1, current->ptr, temp, tolerable, p1, p2, overlap);
			Pipelining(idx1, current->ptr, temp, tolerable, p1, p2, overlap);
			ScheduleAnalysis(current->ptr);
			break;

		case BroadcastBocMsg:
			break;
		}
		/*
		if (current->ptr->pe != temp->pe)
			IsLoadUnbalanced(data, current->ptr, temp, p1, p2, t1, t2);
		*/
	}
}


/*******************************************************************/
/** Is there some user synchronization going on at this entry point **/
/** If so, then report only about problems, such as bottleneck, **
/*******************************************************************/
Bottleneck(current, t1, t2, p1, p2)
TRANSACTION *current, *t1, *t2;
int p1, p2;
{
	int no;
	TRANSACTION *t;
	int idx = get_ep_index(current->info->ep, current->info->msg_type);

	if (patterns[idx][BOTTLENECK]) {

		no=benefit=0;
		for (t=current; t && GetTime(t) >= GetTime(t1); t=t->previous) {
			int idx2;
			
			if (t->type!=BEGIN_PROCESSING) continue;
			idx2 = get_ep_index(t->info->ep, t->info->msg_type);
			if (idx==idx2) {
				benefit += t->info->timep2 - t->info->timep1; 
				no++;
			}
		}

		if (no>=3) {
			benefit -= (benefit*4)/no; 
			if (patterns[idx][SPANTREE]) 
				update_crime(POSSIBLE_BOTTLENECK_PROBLEM, benefit); 
			else update_crime(BOTTLENECK_PROBLEM, benefit); 
			bottleneck_entries[idx] = 1;
			return 1;
		}
	}
	return 0;
}


/*******************************************************************/
/** Is this point a sequential chain **/
/*******************************************************************/
TRANSACTION_LIST *SequentialChain(current, p1, p2, overlap)
TRANSACTION_LIST *current;
int p1, p2;
unsigned int overlap;
{
	TRANSACTION *me = current->ptr;
	int idx = get_ep_index(me->info->ep, me->info->msg_type);

	if (patterns[idx][SEQCHAIN]) { 
		int idx2, p;
		int benefit=0;
		unsigned int max, overlap;
		TRANSACTION_LIST *creation, *temp2;
		TRANSACTION *start, *finish, *temp, *t;

		/*********************************/
		/** find the start of the chain **/
		/*********************************/
		temp=me;
		start=me->info->creator;
		while (start) {
			idx2 = get_ep_index(start->info->ep, start->info->msg_type);
			if (idx2!=idx) start=NULL;
			else {
				temp=start;
				start=start->info->creator;	
			}
		}
		start=temp;

		/*********************************/
		/** find the end of the chain **/
		/*********************************/
		temp = finish = me;
		creation = me->info->creation_list;
		while (finish) {
			for (temp2=creation; temp2; temp2=temp2->next) {
				idx2 = get_ep_index(temp2->ptr->info->ep, 
										temp2->ptr->info->msg_type);
				if (idx2==idx) break;
			}
			if (temp2) {
				finish = temp2->ptr;
				creation = finish->info->creation_list;
			}
			else finish=NULL;
		}
		finish = temp;

		overlap = DetermineOverlap(start->info->timep1, finish->info->timep2,
										p1, p2); 

		if ((overlap < finish->info->timep2 - start->info->timep1) &&
			!within(overlap, finish->info->timep2 - start->info->timep1, 30)) {
				update_crime(SEQUENTIAL_CHAIN_PROBLEM, 
						finish->info->timep2 - start->info->timep1 - overlap);
				seq_chain_entries[idx]=1;	

				for (current=critical_list; current; current=current->next)
					if (current->ptr == start) return current->previous;
			}
	}
	return NULL;
}



/*******************************************************************/
/** Is this message at the end of the entry point?				**/
/*******************************************************************/
TailEndWait(idx, current, creator, tolerable, p1, p2)
int idx;
TRANSACTION *current, *creator;
unsigned int tolerable;
int p1, p2;
{
	TRANSACTION *t;
	unsigned int overlap;
	int last_processing_time;
	int msg_index = grainsize_table[idx].msgid;

	/*****************************************/
	/**** was it created really late by the creator **/
	/*****************************************/
	if ((creator->info->timep2 - creator->info->timep1 > tolerable) &&
		!within(creator->info->timep2 - current->info->timec, 
				creator->info->timep2 - creator->info->timep1, 80)) {

		benefit = current->info->timec - creator->info->timep1;

        for (t=current; t&&(GetTime(t)>=current->info->timec); t=t->previous) {
            int idx2;

            if (t->type!=END_PROCESSING) continue;
			idx2 = get_ep_index(t->info->ep, t->info->msg_type);
			if (idx2==-1) continue;

			if (current->info->timep1 - t->info->timep2 < benefit)
				benefit=current->info->timep1 - t->info->timep2; 
			break;
        }

		overlap = DetermineOverlap(current->info->timep1-benefit,
							current->info->timep1, p1, p2); 
		if (benefit > overlap) {
			wait_tail_benefit[idx] += benefit-overlap; 
			tail_end_entries[idx] = 1;
			return 1;
		}
	}
	return 0;
}

/*******************************************************************/
/** Is pipelining possible for this message?				**/
/*******************************************************************/
Pipelining(idx, current, creator, tolerable, p1, p2, overlap)
int idx;
TRANSACTION *current, *creator;
unsigned int tolerable;
int p1, p2;
unsigned int overlap;
{
	int msg_index = grainsize_table[idx].msgid;
	int grain = EpOverhead(msg_index);

	if (msg_table[msg_index] < 10000) return;

	benefit = PipeliningBenefit(current);
/* printf("benefit=%d\n", benefit); */
	if (overlap < benefit) {
		large_ep[idx] = 1;
		wait_pipe_benefit[idx] += benefit-overlap; 
		return 1;
	}
	return 0;
}




/*************************************************************/
/* Schedule analysis follows									**/
/*************************************************************/
ScheduleAnalysis(current)
TRANSACTION *current;
{
	int i, j;
	int idx, idx2;
	TRANSACTION *t, *tenq, *tdeq;
	int is_there_a_problem = HAVE_NO_PROBLEM;

	tdeq = GetPrevious(current);
	if (tdeq && tdeq->type==DEQUEUE) {
		tenq = GetPrevious(tdeq);
		if (!tenq || (tenq->pe!=tdeq->pe) || (tdeq->pe!=current->pe)) 
			printf("*** ERROR *** unmatched enqueue-dequeue.\n");
	}
	else return;

	for (t=tenq; t!=tdeq; t=t->next)
	{
		int idx2;

		if (t->type != BEGIN_PROCESSING) continue;
		idx2 = get_ep_index(t->info->ep, t->info->msg_type);
		if (idx2 == -1) continue;
		if (idx!=idx2) other_entries[idx2] = 1;
	}
}



/************************************************************/
/** calculates various things needed to determine  **/
/** importance of analysis **/
/************************************************************/
ComputeTimes(t) 
TRANSACTION *t;
{
	NODE *me;
	unsigned int timeq, timedq;
	TRANSACTION *dequeue, *enqueue;
	extern TRANSACTION *find_lesser(), *find_greater();

	me = t->info;
	compute_time = communicate_time = delay_time = 0;
				
	dequeue = GetPrevious(me->ptrp1);
	if (dequeue->type != DEQUEUE) {
		timedq = timeq = me->timep1;
		enqueue = me->ptrp1;
	}
	else {
		timedq =  GetTime(dequeue);
		enqueue = GetPrevious(dequeue);
		timeq = GetTime(enqueue);
	}

	compute_time = me->timep2  - me->timep1;
	communicate_time = me->timep1 - me->timec;
	delay_time = timedq - timeq; 
}


/********************************************************/
/** Check if load is unbalanced for the two processors. **/
/********************************************************/
static int IsLoadUnbalanced(data, current, creator, p1, p2, t1, t2)
graphics_data *data;
TRANSACTION *current, *creator;
int p1, p2;
TRANSACTION *t1, *t2;
{
	int j;
	int p, q;
	int is_there_a_problem=0;

	p=current->pe;
	q=creator->pe;
	/*************************************************/
	/** now start checking for imbalances.			**/
	/*************************************************/
	/* check whether new chare messages were Unbalanced */
 	if (!within(charesp[p-p1], charesp[q-p1], 20)) {
		for (j=0; j<number_entries; j++) {
			if (IGNORE(p1, p, q, j)) continue;
			if (!chare_entries[j]) continue;
			if (numberp[p-p1][j] <= numberp[q-p1][j]) continue;

			if (!within(numberp[p-p1][j], numberp[q-p1][j], 20))  {
				wait_chare_imbalance[j] = 1;
				is_there_a_problem=1;
			}
		}
	}

	/* check whether boc messages were Unbalanced */
 	if (!within(forcharesp[p-p1], forcharesp[q-p1], 20)) { 
		for (j=0; j<number_entries; j++) {
			if (IGNORE(p1, p, q, j)) continue;
			if (!forchare_entries[j]) continue;
			if (numberp[p-p1][j] <= numberp[q-p1][j]) continue;

			if (!within(numberp[p-p1][j], numberp[q-p1][j], 20))  {
				wait_forchare_imbalance[j] = 1;
				is_there_a_problem=1;
			}
		}
	}
	
	/* check whether boc messages were Unbalanced */
 	if (!within(bocsp[p-p1], bocsp[q-p1], 20)) { 
		for (j=0; j<number_entries; j++) {
			if (IGNORE(p1, p, q, j)) continue;
			if (!boc_entries[j]) continue;
			if (numberp[p-p1][j] <= numberp[q-p1][j]) continue;

			if (!within(numberp[p-p1][j], numberp[q-p1][j], 20))  {
				wait_boc_imbalance[j] = 1;
				is_there_a_problem=1;
			}
		}
	}
	
	/* check whether grain size of messages were Unbalanced */
	for (j=0; j<number_entries; j++) {
		if (IGNORE(p1, p, q, j)) continue;
		if (grainp[p-p1][j] <= grainp[q-p1][j]) continue;

		if (!within(grainp[p-p1][j], grainp[q-p1][j], 20)) { 
				wait_grain_imbalance[j] = 1;
				is_there_a_problem=1;
		}
	}

}



int AllocWaitStuff()
{
	int i;
    wait_grain_imbalance  = (char *) malloc(sizeof(char)*number_entries);
    wait_chare_imbalance  = (char *) malloc(sizeof(char)*number_entries);
    wait_forchare_imbalance  = (char *) malloc(sizeof(char)*number_entries);
    wait_boc_imbalance  = (char *) malloc(sizeof(char)*number_entries);

    wait_tail_benefit  = (int *) malloc(sizeof(int)*number_entries);
    wait_pipe_benefit  = (int *) malloc(sizeof(int)*number_entries);
}

int FreeWaitStuff()
{
	int i;
    free(wait_chare_imbalance);
    free(wait_forchare_imbalance);
    free(wait_boc_imbalance);
    free(wait_grain_imbalance);
    free(wait_tail_benefit);
    free(wait_pipe_benefit);
}


InitWaitStuff()
{	
	int i;
	for (i=0; i<number_entries; i++) {
		wait_grain_imbalance[i] =  0;
		wait_chare_imbalance[i] = 0;
		wait_forchare_imbalance[i] = 0; 
		wait_boc_imbalance[i] = 0;
		wait_tail_benefit[i] = 0;
		wait_pipe_benefit[i] = 0;
	}
}

/*********************************************************************/
/** Now figure out all the costs.                                   **/
/*********************************************************************/
DetermineWaitBenefits(p1, p2)
int p1, p2;
{
	int j;

    /********************************************************/
    /* determine possible benefits of solving imbalance problems. **/
    /********************************************************/
	for (j=0; j<number_entries; j++)
		if (wait_chare_imbalance[j]) 
			update_crime(WAIT_CHARE_IMBALANCE, EntryImbalanceCost(p1, p2, j));

	for (j=0; j<number_entries; j++)
		if (wait_forchare_imbalance[j]) 
			update_crime(WAIT_FORCHARE_IMBALANCE, 
								EntryImbalanceCost(p1, p2, j));

	for (j=0; j<number_entries; j++)
		if (wait_boc_imbalance[j]) 
			update_crime(WAIT_BOC_IMBALANCE, EntryImbalanceCost(p1, p2, j));

	for (j=0; j<number_entries; j++)
		if (wait_grain_imbalance[j]) 
			update_crime(WAIT_GRAIN_IMBALANCE, EntryImbalanceCost(p1, p2, j));

	for (j=0; j<number_entries; j++)
		if (tail_end_entries[j]) 
				update_crime(TAIL_END_MESSAGE, wait_tail_benefit[j]);

	for (j=0; j<number_entries; j++)
		if (large_ep[j]) 
				update_crime(PIPELINING_PROBLEM, wait_pipe_benefit[j]);
}

/*********************************/
/** now determine the max. overlap for all processors, **/
/** and compare that to length of chain. **/
/*********************************/
DetermineOverlap(start, finish, p1, p2)
unsigned int start, finish;
int p1, p2;
{
	int p;
	unsigned int a, b;
	TRANSACTION *t1, *t2, *t;
	unsigned int overlap, temp;

	overlap=0;
	for (p=p1; p<=p2; p++) {
		temp=0;
		t1 = find_lesser(p, start);
		t2 = find_greater(p, finish);
		for (t=t1; t&&t!=t2; t=t->next) {
			if (t->info->timep2 < start) continue;
			if (t->info->timep1 > finish) break;
			a = t->info->timep1;
			if (t->info->timep1 < start) a = start;
			b = t->info->timep2;
			if (t->info->timep2 > finish) b = finish;
			temp += (b-a);
		}
		if (temp>overlap) overlap = temp;
	}
	/* return overlap/(p2-p1+1)); */
	return overlap;
}

/*********************************/
/** look up thesis to figure this out, why? **/
/*********************************/
PipeliningBenefit(current)
TRANSACTION *current;
{
	unsigned int gb = current->info->timep2 - current->info->timep1;
	int idx = get_ep_index(current->info->ep, current->info->msg_type);
	int msg_index = grainsize_table[idx].msgid;
	int size = msg_table[msg_index];
	float beta = machine_table[machine_type].beta;
	float alpha = machine_table[machine_type].alpha;
	int ksquare = (2*(gb + size*beta))/alpha;
	int k = ((int) sqrt((double) ksquare));

/*
printf("alpha=%f, beta=%f, size = %d, ksquare=%d, k=%d\n", 
alpha, beta, size, ksquare, k);
*/
	return ((gb+size*beta)*(k-1))/k + (alpha*k)/2;
}
