/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: tachyon.c,v $
 *	$Author: sanjeev $	$Locker:  $		$State: Exp $
 *	$Revision: 1.3 $	$Date: 1995/09/21 21:06:13 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: tachyon.c,v $
 * Revision 1.3  1995/09/21 21:06:13  sanjeev
 * *** empty log message ***
 *
 * Revision 1.2  1995/02/24  23:22:35  jyelon
 * *** empty log message ***
 *
 ***************************************************************************/
static char ident[] = "@(#)$Header: /expand1/cvsroot/projections/sources/analyse/tachyon.c,v 1.3 1995/09/21 21:06:13 sanjeev Exp $";
#include "head.h"
#include "common.h"
#include "analyse.h"
#include "data.h"
#include "shared.h"

static int mini;
static int printed=0;
static TRANSACTION *minptr;
static unsigned int *shifts;
static unsigned int mint, *leastc;
static TRANSACTION **processing_list;

#define IsTachyon(p) (p->info->timec > p->info->timep1) 


/******************************************************/
/* hash table stuff 							**/
/******************************************************/
#define MAX_HASH 1001
#define CreationHashMap(t) ((t->info->pe*1003 + t->info->event*1005)%MAX_HASH)
#define CreationHashEqual(t1, t2) ((t1->info->pe==t2->info->pe) && \
							(t1->info->event==t2->info->event))
static TRANSACTION_LIST *creation_hash[MAX_HASH];

InsertCreation(t)
TRANSACTION *t;
{
	int index = CreationHashMap(t);
	TRANSACTION_LIST *tl = (TRANSACTION_LIST *)malloc(sizeof(TRANSACTION_LIST));
	tl->ptr = t;
	tl->previous = NULL;
	tl->next = creation_hash[index];
	if (creation_hash[index]) creation_hash[index]->previous = tl;
	creation_hash[index] = tl;
}


DeleteCreation(t)
TRANSACTION *t;
{
	int index = CreationHashMap(t);
	TRANSACTION_LIST *current, *previous;

	for (current=creation_hash[index]; current; current = current->next) 
		if (CreationHashEqual(current->ptr, t))
		{
			previous = current->previous;
			if (previous) previous->next = current->next;
			else creation_hash[index] = current->next;
			if (current->next) current->next->previous = NULL;
			free(current);
			return;
		}

	printf("*** ERROR *** creation not found in hash table %d.\n", index);
}


static FindCreation(t)
TRANSACTION *t;
{
	int index = CreationHashMap(t);
	TRANSACTION_LIST *current;

	current = creation_hash[index];
	while (current != NULL)
		if (CreationHashEqual(current->ptr, t)) return 1;
		else current = current->next;
	return 0;
}


/******************************************************/
/* determine new minimum */
/******************************************************/
static int NewMinimum()
{
	int i;

	mini = -1;
	mint = -1;
	minptr = NULL;

	for (i=0; i<number_pe; i++) {
		if (processing_list[i] && FindCreation(processing_list[i]) &&
				(GetTime(processing_list[i]) < mint)) {
			mint = GetTime(processing_list[i]);
			minptr = processing_list[i];
			mini = processing_list[i]->pe;
		}
	}
}

static TRANSACTION * SkipToProcessing(t)
TRANSACTION *t;
{
	while (t && (t->type != BEGIN_PROCESSING)) {
		RightShift(t, shifts[t->pe]);
		if (t->type==CREATION) InsertCreation(t);
		t = t->next;
	}
	if (t) RightShift(t, shifts[t->pe]);
	return t;
}



/******************************************************/
/** right shift everything.							**/
/******************************************************/

int RightShift(current, delta)
TRANSACTION *current;
unsigned int delta;
{
	QUEUE_LIST *q;

	switch (current->type) {
		case CREATION:
			current->info->timec += delta;
			break;

		case ENQUEUE:
       		q = current->info->enqueue;
       		while (q != NULL)
       		{
           		if (q->ptr == current) {
               		q->time += delta;
					break;
				}
           		q = q->next;
       		}
       		break;

    	case DEQUEUE:
       		q = current->info->dequeue;
       		while (q != NULL)
       		{
           		if (q->ptr == current) {
               		q->time += delta;
					break;
				}
           		q = q->next;
			}
			break;

		case BEGIN_PROCESSING:
			current->info->timep1 += delta;
		break;

		case END_PROCESSING:
			current->info->timep2 += delta;
			break;
	}
}

int RemoveTachyons()
{
	int i;
	unsigned int delta; 

	mint = -1;
	shifts = (unsigned int *) malloc(sizeof(unsigned int)*number_pe);
	for (i=0; i<number_pe; i++) shifts[i] = 0;

	for (i=0; i<MAX_HASH; i++) creation_hash[i] = NULL;
	processing_list = (TRANSACTION **) malloc(sizeof(TRANSACTION *)*number_pe);
	for (i=0; i<number_pe; i++) 
		processing_list[i] = SkipToProcessing(transaction_table[i].head);
	NewMinimum();

	while (minptr) {
		if (IsTachyon(minptr)) {
			delta = (minptr->info->timec - minptr->info->timep1) +
							Overhead(minptr);
			RightShift(minptr, delta);
			shifts[minptr->pe] += delta;
		}
		DeleteCreation(minptr->info->ptrc);
		processing_list[mini] = SkipToProcessing(processing_list[mini]->next);
		NewMinimum();
	}		

	free(processing_list);
}

