/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: sync.c,v $
 *	$Author: jyelon $	$Locker:  $		$State: Exp $
 *	$Revision: 1.2 $	$Date: 1995/02/24 23:22:35 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: sync.c,v $
 * Revision 1.2  1995/02/24 23:22:35  jyelon
 * *** empty log message ***
 *
 ***************************************************************************/
static char ident[] = "@(#)$Header: /expand1/cvsroot/projections/sources/analyse/sync.c,v 1.2 1995/02/24 23:22:35 jyelon Exp $";
#include "head.h"
#include "common.h"
#include "analyse.h"
#include "data.h"
#include "shared.h"

static int      mini;
static unsigned int mint;
static TRANSACTION *minptr, **points;
static TRANSACTION_LIST *my_sync_list, *finish=NULL;

static TRANSACTION * SkipToUser(t)
TRANSACTION *t;
{
	while (t && get_ep_index(t->info->ep, t->info->msg_type) == -1) 
		t = t->next;
	return t;
}



/* determine new minimum */
static int NewMinimum()
{
	int             i;

	minptr = NULL;
	mint = -1;
	for (i = 0; i < number_pe; i++) {
		if (points[i] && (GetTime(points[i]) < mint)) {
			mint = GetTime(points[i]);
			minptr = points[i];
			mini = points[i]->pe;
		}
	}
}


/* Add this transaction to the synchronization list */
static int AddToSyncPoints(t)
TRANSACTION *t;
{
    TRANSACTION_LIST *new, *current;

	if (!t->info->creation_list) return;

    if  (finish && (t->info->creator == finish->ptr)) {
        if (finish->ptr->info->ep!=charminit_id) {
            finish->ptr = t;
            return;
        }
    }

    new = (TRANSACTION_LIST *) malloc(sizeof(TRANSACTION_LIST));
    new->ptr = minptr;
    new->next = NULL;;
	new->previous = finish;
	if (finish) finish->next = new;
	else my_sync_list = new;
	finish = new;
}

TRANSACTION_LIST *DetermineSyncPoints()
{
	int  i, actual, chare_actual;

	actual = chare_actual = 0;
	mint = -1;

	my_sync_list = NULL;
	points = (TRANSACTION **) malloc(sizeof(TRANSACTION *) * number_pe);
	for (i = 0; i < number_pe; i++) {
		points[i] = transaction_table[i].head;
		points[i] = SkipToUser(points[i]);
	}
	NewMinimum();


	while (minptr) {
		switch (minptr->type) {
		case BEGIN_PROCESSING:
			minptr->info->dop = chare_actual;
			if (actual==1) AddToSyncPoints(minptr);
			break;

		case END_PROCESSING:
			if (minptr->info->msg_type == NewChareMsg) chare_actual--;
			actual--;
			break;

		case CREATION:
			if (minptr->info->msg_type == NewChareMsg) chare_actual++;
			actual++;
			break;

		}
		points[mini] = SkipToUser(minptr->next);
		NewMinimum();
	}

	free(points);
	/* JustDoIt("\nSynchronization from algo1 are:", my_sync_list); */ 
	return my_sync_list;
}
