/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: report.c,v $
 *	$Author: jyelon $	$Locker:  $		$State: Exp $
 *	$Revision: 1.2 $	$Date: 1995/02/24 23:22:35 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: report.c,v $
 * Revision 1.2  1995/02/24 23:22:35  jyelon
 * *** empty log message ***
 *
 ***************************************************************************/
static char ident[] = "@(#)$Header: /expand1/cvsroot/projections/sources/analyse/report.c,v 1.2 1995/02/24 23:22:35 jyelon Exp $";
#include "head.h"
#include "common.h"
#include "analyse.h"
#include "data.h"
#include "shared.h"

static int program_total;

#define print_fraction(this_time, total_time) {\
    sprintf(temp_string, "(%3.2f%%) ", \
                ((100.0*((double) this_time))/((double) total_time))); \
    mysprintf(temp_string); \
}


/*************************************************************/
/* maintain a list of problems								**/
/*************************************************************/

int update_crime(crime, benefit)
int crime;
int benefit;
{
	crime_sheet[crime] = 1;
	local_problem_benefit[crime] += benefit;
	return HAVE_PROBLEM;
}

/*************************************************************/
/** Combine reporting of problems.						**/
/*************************************************************/
int Combine(benefit, sheet)
int *benefit;
char *sheet;
{
	int i;

	if (!(sheet[TAIL_END_MESSAGE] && sheet[PIPELINING_PROBLEM])) return;
	for (i=0; i<number_entries; i++) {

		if (!(large_ep[i] && tail_end_entries[i])) continue; 

		both_large_and_tail[i] = 1;
		if (wait_tail_benefit[i] > wait_pipe_benefit[i]) {
			benefit[PIPELINING_PROBLEM] -=  wait_pipe_benefit[i];
			large_ep[i] = 0;
		}
		else {
			benefit[TAIL_END_MESSAGE] -=  wait_tail_benefit[i];
			tail_end_entries[i] = 0;
		}
	}
	for (i=0; i<number_entries; i++) 
		if (large_ep[i] && wait_pipe_benefit[i]) break;
	if (i>=number_entries) sheet[PIPELINING_PROBLEM]=0;

	for (i=0; i<number_entries; i++) 
		if (tail_end_entries[i] && wait_tail_benefit[i]) break;
	if (i>=number_entries) sheet[TAIL_END_MESSAGE]=0;
}


/*************************************************************/
/** Report problems											**/
/*************************************************************/
ReportGlobalStatus(x, str, time1, time2)
int x;
char *str;
unsigned int time1, time2;
{
	int i;
	int start=-1;
	int written=0;
	int start_stage = INTERVAL(time1);
	int end_stage = INTERVAL(time2);

	i=start_stage; 
	while (i<=end_stage) {
		if (global_status[x][i]) { 
			if (start==-1) start = i;
		}	
		else {
			if (start!=-1 && (5*(i-start+1) > (end_stage -start_stage+1))) {
				if (!written) {
					mysprintf(str);
					mysprintf("\t\t");
					written=1;
				}
    			sprintf(temp_string, "%d--%d ", start, i-1);
				start=-1;
    			mysprintf(temp_string); 
			}
		}
		i++;
	}
	mysprintf("\n");
}

ReportEPProblem(rpt, n)
char *rpt;
int n;
{
	int idx, total_ep_string_length;

	InitPrintEP(total_ep_string_length, temp_string);
	for (idx=0; idx<n; idx++) mysprintf("\t");
	for (idx=0; idx<number_entries; idx++)
		if (rpt[idx] && grainsize_table[idx].ep!=charminit_id) 
			PrintEP(2, idx, strlen(temp_string));
	mysprintf("\n");
}


int Report(benefit, sheet, time1, time2)
int *benefit;
char *sheet;
unsigned int time1, time2;
{
	int idx;
	int i, k;
	int *temp;
	int count=0;
	int max, maxk;
	unsigned int store;

	temp = (int *) malloc(sizeof(int)*number_entries);
	while (1) {

		max=0;
		maxk=-1;
		for (k=0; k<MAX_PROBLEMS; k++)
			if (sheet[k] && benefit[k]>max)  {
				maxk=k;
				max=benefit[k];
			}
		if (maxk==-1) break;
		k=maxk;

		/* printf("problem=%d, benefit=%u, total=%u\n", 
		k, benefit[k], program_total); */

		print_fraction(benefit[k], program_total);
		switch (k) {

		case CHARMINIT_NOPROBLEM:
			break;

		case CHARMINIT_PROBLEM:
			mysprintf("CharmInit is long; it sequentializes execution.\n");
			if (sheet[BRANCHINIT_PROBLEM]) { 
				mysprintf("\t--  The branch of a BOC on processor 0 is \n");
				mysprintf("\t    initialized inside CharmInit. If it's big\n");
				mysprintf("\t    it sequentializes program execution.  In\n");
				mysprintf("\t    this program, this is true for the following\n");
				mysprintf("\t    entry points:\n");
				ReportEPProblem(branchinit_entries, 2);
			}
			break;

		case OVERHEAD_IMBALANCE:
			mysprintf("Processors have imbalance in overheads.\n");
			break;

		case GRAIN_IMBALANCE:
			mysprintf("Processors have imbalance in granularity of following tasks.\n");
			ReportEPProblem(grain_imbalance, 2);
			break;

		case CHARE_IMBALANCE:
			mysprintf("Processors have imbalance in new chares.\n");
			if (!sheet[CHARMINIT_PROBLEM])
				ReportEPProblem(chare_imbalance, 2);
			break;

		case FORCHARE_IMBALANCE:
			mysprintf("Processors have imbalance in messages to chares.\n");
			ReportEPProblem(forchare_imbalance, 2);
			break;

		case BOC_IMBALANCE:
			mysprintf("Processors have imbalance in number of messages to bocs.\n");
			ReportEPProblem(boc_imbalance, 2);
			break;

		case FINE_GRAIN_PROBLEM:
			mysprintf("There is a grainsize problem: following tasks are too fine-grained.\n");
			ReportEPProblem(fine_grain_problem, 2);
			break;

		case UNNECESSARY_LDB:                         
			mysprintf("The load balancing library is unnecessary.\n");
			sheet[LDB_INTERFERENCE] = benefit[LDB_INTERFERENCE] = 0;
			break;

		case LOW_PARALLELISM:                       
		case POOR_LDB:                 
			if (sheet[LOW_PARALLELISM]) {
				mysprintf("\tThe degree of parallelism in the program is low.\n");
				break;
			}
			mysprintf("The load balancing strategy is not doing a good job.\n");
			mysprintf("\tThere is sufficient work, however it is not being balanced.\n"); 
			if (sheet[QD_INTERFERENCE]) {
				mysprintf("\t-- ");
				print_fraction(benefit[QD_INTERFERENCE], program_total);
				mysprintf("Quiescence detection becomes over-active.\n");
				ReportGlobalStatus(QD_INTERFERENCE, 
					"\t    The problem is most severe for the following stages:\n",
					time1, time2);
			}
			if (sheet[LDB_INTERFERENCE]) {
				mysprintf("\t-- ");
				print_fraction(benefit[LDB_INTERFERENCE], program_total);
				mysprintf("Even though load balance is bad, the strategy uses large number of messages.\n");
			}

			sheet[SYSTEM_INTERFERENCE] = sheet[LDB_INTERFERENCE] = 
			sheet[QD_INTERFERENCE] =  benefit[LDB_INTERFERENCE] =
			benefit[SYSTEM_INTERFERENCE] = benefit[QD_INTERFERENCE] =  0;
			break;

		case SYSTEM_INTERFERENCE:
		case LDB_INTERFERENCE:
		case QD_INTERFERENCE:

			if (sheet[SYSTEM_INTERFERENCE]) 
				mysprintf("Processors are doing system work.\n");

			if (sheet[LDB_INTERFERENCE]) 
				if (severe_ldb_interference) {
					mysprintf("\t-- "); 
					print_fraction(benefit[LDB_INTERFERENCE], program_total);
					mysprintf(" Load balancing strategy SEVERELY interferes with user work.\n");
				}
				else 
					mysprintf("\t-- Load balancing strategy interferes with user work.\n");
			if (sheet[QD_INTERFERENCE]) 
				if (severe_qd_interference)
				{
					mysprintf("\t-- ");
					print_fraction(benefit[QD_INTERFERENCE], program_total);
					mysprintf(" Quiescence detection SEVERELY interferes with user work.\n");
					ReportGlobalStatus(QD_INTERFERENCE, 
						"\t    The problem is most severe for the following stages:\n",
						time1, time2);
				}
				else
					mysprintf("\t-- Quiescence detection interferes with user work.\n");
				sheet[SYSTEM_INTERFERENCE] = sheet[LDB_INTERFERENCE] =
					sheet[QD_INTERFERENCE] = 0;
			break;



    	case TAIL_END_MESSAGE:
        	mysprintf("Processors wait because a message is sent at the \n");
        	mysprintf("\tvery end of the following entry-points:\n");
        	ReportEPProblem(tail_end_entries, 2);
			break;

		case PIPELINING_PROBLEM:
        	mysprintf("Processors wait at the following entry points \n");
			mysprintf("\tfor a large message to arrive:\n");
        	ReportEPProblem(large_ep, 2);
			break;

    	case WAIT_CHARE_IMBALANCE:
        	mysprintf("Processor wait because there is an imbalance in number of\n");
        	mysprintf("\tnew chare messages at the following entry points:\n");
        	ReportEPProblem(wait_chare_imbalance, 2);
			break;

    	case WAIT_FORCHARE_IMBALANCE:
        	mysprintf("Processor wait because there is an imbalance in number of\n");
        	mysprintf("\tfor chare messages at the following entry points:\n");
        	ReportEPProblem(wait_forchare_imbalance, 2);
    		break;

    	case WAIT_BOC_IMBALANCE:
        	mysprintf("Processor wait because there is an imbalance in number of\n");
        	mysprintf("\tboc messages at the following entry points:\n");
        	ReportEPProblem(wait_boc_imbalance, 2);
    		break;
    	
		case WAIT_GRAIN_IMBALANCE:
        	mysprintf("Processor wait because there is an imbalance in the granularity\n");
        	mysprintf("\tof the following entry points:\n");
        	ReportEPProblem(wait_grain_imbalance, 2);
    		break;

    	case WAIT_OVERHEAD_IMBALANCE:
        	mysprintf("The delay is due to an imbalance in overheads of\n");
        	mysprintf("\tload balancing and quiescence detection.\n");
			break;

		case POSSIBLE_BOTTLENECK_PROBLEM:
			mysprintf("The following entry points constitute a possible bottleneck:\n");
        	ReportEPProblem(bottleneck_entries, 2);
			mysprintf("\tHowever, the number of processors is not large enough to decide this.\n");
			break;

		case BOTTLENECK_PROBLEM:
			mysprintf("The following entry points constitute a bottleneck:\n");
        	ReportEPProblem(bottleneck_entries, 2);
			break;

		case SEQUENTIAL_CHAIN_PROBLEM:
			mysprintf("There is a sequential chain involving the following entry points:\n");
        	ReportEPProblem(seq_chain_entries, 2);
			break;

		default:
			break;
    	}
		sheet[k] = benefit[k] = 0;
		count++;
	}
	free(temp);
	if (!count) mysprintf("\tCould not determine the cause of the problem:-(\n");
}

/*************************************************************/
/* Overlap analysis follows									**/
/*************************************************************/
OverlapAnalysis()
{
	int i, j;
	int said =0;
	int idx, idx2;
	int both, alone;
	TRANSACTION_LIST *current;
	int total_ep_string_length=0;
	TRANSACTION *t, *tenq, *tdeq;
	int is_there_a_problem = HAVE_NO_PROBLEM;


	mysprintf("*******************************\n");
	mysprintf("**** OVERLAP ANALYSIS *********\n");
	mysprintf("*******************************\n");

	for (i=0; i<number_entries; i++)
		if (critical_entries[i] && !other_entries[i])  {
			is_there_a_problem = HAVE_PROBLEM;
			break;
		}
	if (!is_there_a_problem) {
		mysprintf("Overlap analysis showed no real problems.\n");
		return;
	}

	mysprintf("Overlap analysis showed possibility of improvement.\n");


	alone=both=0;
	for (i=0; i<number_entries; i++)
		if (critical_entries[i] && other_entries[i]) both++;
		else if (critical_entries[i]) alone++;

	if (both) {
		mysprintf("Eliminating all non-critical entries on critical path.\n");
		for (i=0; i<number_entries; i++)
			if (critical_entries[i] && other_entries[i]) 
				critical_entries[i] = other_entries[i] = 0;
	}
	
	if (alone) {

		for (i=0; i<number_entries; i++) {

			if (!critical_entries[i]) continue;
			if (IGNORE_OVERALL(i)) continue;

			if (!said) {
				mysprintf("Prioritize the following entries to speed execution:\n\t");
				InitPrintEP(total_ep_string_length, temp_string);
				said=1;
			}
			PrintEP(1, i, strlen(temp_string));
		}
		if (said) mysprintf("\n");
	}
	else
		mysprintf("No prioritization scheme can be suggested.\n");
}

/*************************************************************/
/** allocation and deallocation								**/
/*************************************************************/

AllocGlobalStuff()
{
	int i, j, k;

	global_status = (char **) malloc(sizeof(char *)*stages);
	for (i=0; i<stages; i++)
		global_status[i] = (char*) malloc(sizeof(char)*MAX_PROBLEMS);

    global_branchinit_entries = (char *) malloc(sizeof(char)*number_entries);
    global_seq_chain_entries = (char *) malloc(sizeof(char)*number_entries);
    global_bottleneck_entries = (char *) malloc(sizeof(char)*number_entries);
    global_both_large_and_tail = (char *) malloc(sizeof(char)*number_entries);
    global_tail_end_entries = (char *) malloc(sizeof(char)*number_entries);
    global_large_ep = (char *) malloc(sizeof(char)*number_entries);
    global_fine_grain_problem = (char *) malloc(sizeof(char)*number_entries);
    global_grain_imbalance  = (char *) malloc(sizeof(char)*number_entries);
    global_chare_imbalance  = (char *) malloc(sizeof(char)*number_entries);
    global_forchare_imbalance  = (char *) malloc(sizeof(char)*number_entries);
    global_boc_imbalance  = (char *) malloc(sizeof(char)*number_entries);
    global_crime_sheet = (char *) malloc(sizeof(char)*MAX_PROBLEMS);
    global_alltotal = (int *) malloc(sizeof(int)*number_entries);
    global_wait_chare_imbalance = (char *) malloc(sizeof(char)*number_entries);
    global_wait_forchare_imbalance = (char *) malloc(sizeof(char)*number_entries);
    global_wait_boc_imbalance = (char *) malloc(sizeof(char)*number_entries);
    global_wait_grain_imbalance = (char *) malloc(sizeof(char)*number_entries);

	for (i=0; i<number_entries; i++) 
    	global_seq_chain_entries[i] = global_bottleneck_entries[i] = 
    	global_branchinit_entries[i] = global_tail_end_entries[i] = 
			global_both_large_and_tail[i] =
    		global_large_ep[i] = global_fine_grain_problem[i] =
    		global_grain_imbalance[i]  = global_chare_imbalance[i]  = 
    		global_forchare_imbalance[i]  = global_boc_imbalance[i]  = 
    		global_alltotal[i] = global_wait_chare_imbalance[i] = 
			global_wait_forchare_imbalance[i] = 
    		global_wait_boc_imbalance[i] = global_wait_grain_imbalance[i] = 0; 
	for (i=0; i<MAX_PROBLEMS; i++) global_crime_sheet[i] = 0; 
}

FreeGlobalStuff()
{
	int i;

	for (i=0; i<stages; i++) free(global_status[i]);
	free(global_status);
    free(global_branchinit_entries);
    free(global_seq_chain_entries);
    free(global_bottleneck_entries);
    free(global_both_large_and_tail);
    free(global_tail_end_entries);
	free(global_large_ep);
    free(global_fine_grain_problem);
    free(global_chare_imbalance);
    free(global_forchare_imbalance);
    free(global_boc_imbalance);
    free(global_grain_imbalance);
    free(global_crime_sheet);
	free(global_alltotal);
    free(global_wait_chare_imbalance);
    free(global_wait_forchare_imbalance);
    free(global_wait_boc_imbalance);
    free(global_wait_grain_imbalance);
}

AddToGlobalStuff(t1, t2)
TRANSACTION *t1, *t2;
{
	int i;

	/*****************
	printf("---------------------------------\n");
	printf("%u --- %u\n", t2->info->timep2, t1->info->timep1);
	*****************/

	for (i=0; i<number_entries; i++) { 
    	global_branchinit_entries[i] += branchinit_entries[i];
		global_both_large_and_tail[i] += both_large_and_tail[i];
		global_tail_end_entries[i] += tail_end_entries[i];
		global_bottleneck_entries[i] += bottleneck_entries[i];
		global_seq_chain_entries[i] += seq_chain_entries[i];
    	global_large_ep[i] += large_ep[i];
		global_fine_grain_problem[i] += fine_grain_problem[i];
    	global_grain_imbalance[i]  += grain_imbalance[i];
		global_chare_imbalance[i]  += chare_imbalance[i];
    	global_forchare_imbalance[i]  += forchare_imbalance[i];
		global_boc_imbalance[i]  += boc_imbalance[i];
    	global_wait_chare_imbalance[i] += wait_chare_imbalance[i];
		global_wait_forchare_imbalance[i] += wait_forchare_imbalance[i];
    	global_wait_boc_imbalance[i] += wait_boc_imbalance[i];
		global_wait_grain_imbalance[i] += wait_grain_imbalance[i];
    	global_alltotal[i] += alltotal[i];
	}

	program_total = t2->info->timep2 - t1->info->timep1;
	for (i=0; i<MAX_PROBLEMS; i++) {
		global_problem_benefit[i] += local_problem_benefit[i];
		global_crime_sheet[i] += crime_sheet[i];
	}
}

PointToGlobalStuff()
{
	branchinit_entries = global_branchinit_entries;
	grain_imbalance = global_grain_imbalance;
	chare_imbalance = global_chare_imbalance;
	forchare_imbalance = global_forchare_imbalance;
	boc_imbalance = global_boc_imbalance;
	fine_grain_problem = global_fine_grain_problem;
	both_large_and_tail = global_both_large_and_tail;
	tail_end_entries = global_tail_end_entries;
	bottleneck_entries = global_bottleneck_entries;
	seq_chain_entries = global_seq_chain_entries;
	large_ep = global_large_ep;
	wait_chare_imbalance = global_wait_chare_imbalance;
	wait_forchare_imbalance = global_wait_forchare_imbalance;
	wait_boc_imbalance = global_wait_boc_imbalance;
	wait_grain_imbalance = global_wait_grain_imbalance;
    alltotal = global_alltotal;
	program_total = end_time - begin_time;
}

