/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: pattern.c,v $
 *	$Author: jyelon $	$Locker:  $		$State: Exp $
 *	$Revision: 1.2 $	$Date: 1995/02/24 23:22:35 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: pattern.c,v $
 * Revision 1.2  1995/02/24 23:22:35  jyelon
 * *** empty log message ***
 *
 ***************************************************************************/
static char ident[] = "@(#)$Header: /expand1/cvsroot/projections/sources/analyse/pattern.c,v 1.2 1995/02/24 23:22:35 jyelon Exp $";
#include "head.h"
#include "common.h"
#include "analyse.h"
#include "data.h"
#include "shared.h"

typedef struct _transaction_stack {
	int state;
	TRANSACTION *ptr;
	struct _transaction_stack *next, *previous;
} TRANSACTION_STACK;

#define Match(t, x) (get_ep_index(t->info->ep, t->info->msg_type)==x)
#define UnTagged(t) (t->info->tag==-1)

static char *state;
static TRANSACTION_STACK *stack;

InsertStack(t, l) 
TRANSACTION *t;
int l;
{
	TRANSACTION_STACK *current;
	current = (TRANSACTION_STACK *) malloc(sizeof(TRANSACTION_STACK));
	current->ptr = t;
	current->state = l;
	current->previous = NULL;
	current->next = stack;
	if (stack) stack->previous=current;
	stack = current;
}

TRANSACTION *DeleteStack(l)
int *l;
{
	TRANSACTION *t;
	TRANSACTION_STACK *current = stack;

	if (stack->next) {
		stack->next->previous = NULL;
		stack = stack->next;
	}
	else stack = NULL;

	*l = current->state;
	t = current->ptr;
	free(current);
	return t;
}

TRANSACTION *TopStack() { return stack->ptr; }

int DeterminePatterns(data, t1, t2)
graphics_data *data;
TRANSACTION *t1, *t2;
{
	int idx1, idx2;
	TRANSACTION *current;
	TRANSACTION_LIST *list;
	int *max_level, idx, level, **map, i, j;

	max_level = (int *) malloc(sizeof(int)*number_entries);

	idx1 = get_ep_index(t1->info->ep, t1->info->msg_type);
	idx2 = get_ep_index(t2->info->ep, t2->info->msg_type);

	/*
	printf("=================\n");
	printf("%s@%s --- %s@%s\n", 
			chare_list[grainsize_table[idx1].chareid].name,
			grainsize_table[idx1].name,
			chare_list[grainsize_table[idx2].chareid].name,
			grainsize_table[idx2].name);
	*/

	/******************************************************/
	/** first do a depth first search and determine level numbers for **/
	/** all entry points **/
	/******************************************************/
	for (idx=0; idx<number_entries; idx++) { 

		level = -1;
		stack = NULL;
		max_level[idx] = -1;
	

		/*
		if (Match(t1, idx)) {
			InsertStack(t1, level+1);
			t1->info->tag = level+1;
			if (level+1 > max_level[idx]) max_level[idx] = level+1;
		}
		else */
		InsertStack(t1, level);

		while (stack) {

			current=DeleteStack(&level); 

			list=current->info->creation_list; 
			for (; list; list=list->next) { 
				current=list->ptr->info->ptrp1;
				if (current->info->timep2 <= t2->info->timep2) { 
					if (Match(current, idx)) {
						InsertStack(current, level+1);
						current->info->tag = level+1;
						if (level+1 > max_level[idx]) max_level[idx] = level+1;
					}
					else
						InsertStack(current, level);
				}
			}
		}
	}
	


	state = (char *) malloc(sizeof(char)*number_pe);
	for (idx=0; idx<number_entries; idx++) { 

		if (max_level[idx]==-1) continue;
		
		/** allocate map **/
		map = (int **) malloc(sizeof(int *) * number_pe);
	    for (i=0; i<number_pe; i++) {
			map[i] = (int *) malloc(sizeof(int) * (max_level[idx]+1));
			for (j=0; j<=max_level[idx]; j++) map[i][j] = -1;
		}

		InsertStack(t1, t1->info->tag);

		while (stack) {
			int tag, from, dest;

			current=DeleteStack(&level);
			if (Match(current, idx)) {

				tag = current->info->tag;
				if (tag==-1 && current!=t1)
					printf("*** ERROR *** Untagged element encountered.\n");

				dest = current->pe;
				if (current->info->creator) from = current->info->creator->pe;
				else from = current->pe;

				if (map[dest][tag]==-1) map[dest][tag]=from;
				else if (map[dest][tag]>=0) map[dest][tag]=-2;
				else map[dest][tag]--;
			}
			list=current->info->creation_list; 
			for (; list; list=list->next) { 
				current=list->ptr->info->ptrp1;
				if (current->info->timep2 <= t2->info->timep2) 
						InsertStack(current, current->info->tag);
			}
		}

		/*
		printf("%s@%s:\n", chare_list[grainsize_table[idx].chareid].name, 
			grainsize_table[idx].name); 
		for (j=0; j<=max_level[idx]; j++) {
			printf("\t");
	    	for (i=0; i<number_pe; i++) printf("%d ", map[i][j]); 
			printf("\n");
		}
		*/

		if (!strcmp(grainsize_table[idx].type, "BOC"))
			BocWhichPattern(idx, map, max_level[idx]+1);
		else if (!strcmp(grainsize_table[idx].type, "CHARE"))
			ChareWhichPattern(idx, map,  max_level[idx]+1);

		/** free map **/
	    for (i=0; i<number_pe; i++) free(map[i]);
		free(map);
	}
	free(state);

}


/*******************************************************************/
/** Now that I have the map, its time to determine the various **/
/** patterns **/
/*******************************************************************/

IsItAPermutation(map, l)
int **map, l;
{
	int i;

	for (i=0; i<number_pe; i++) state[i]=0;
	for (i=0; i<number_pe; i++) 
		if (map[i][l]>=0) state[map[i][l]]=1;
	for (i=0; i<number_pe; i++) 
		if (!state[i]) return 0;
	return 1;
}

IsItACycle(map, p, levels)
int **map, p, levels;
{
	int j, x;

	for (j=0; j<number_pe; j++) state[j]=0; 
	for (j=levels-1,x=map[p][j]; (x>=0 && j>=0); j=j-1,x=map[x][j]) state[x]++;
	for (j=0; j<number_pe; j++) 
		if (state[j]==2) break;
	if (j>=number_pe) return 0; 
	return 1;
}

IsItAChain(map, levels)
int **map, levels;
{
	int i, j, count;
	for (i=0; i<levels; i++) {
		count=0;
		for (j=0; j<number_pe; j++)
			if (map[j][i]!=-1) {
				if (map[j][i] < 0) return 0;
				else count++;
			}
		if (count!=1) return 0;
	}
	return 1;
}

IsItABottleneck(map)
int **map;
{
	int i, count=0, where;
	for (i=0; i<number_pe; i++) 
		if (map[i][0] != -1) {
			count++;
			where = i;
		}
	if (count==1 && map[where][0] <= 2 - number_pe) return 1;	
	return 0;
}

IsItASpanTree(map, levels)
int **map, levels;
{
	int i, j, count;

	/** levels is greater than 1 **/

	/** check if there is only at most one entry for each processor **/
	for (j=0; j<number_pe; j++) { 
		count = 0;
		for (i=0; i<levels; i++)
			if (map[j][i]!=-1) count++;
		if (count>1) return 0;
	}

	/** check if backward tree covers everyone **/
	count=0;
	for (j=0; j<number_pe; j++) state[j] = -1;
	for (i=levels-1; i>=0; i--)  {
		for (j=0; j<number_pe; j++) 
			if (map[j][i]!=-1) {
				if (map[j][i]>=0) count++;
				else count += -(map[j][i]);
			}
	}
	if (count > number_pe - 2) return 1;
}

IsItABroadcast(map, levels)
int **map, levels;
{
	int i, j, n, total;

	for (j=0; j<levels; j++) {
		n=total=0;
		for (i=0; i<number_pe; i++) state[i]=0;
		for (i=0; i<number_pe; i++) if (map[i][j]<0) return 0; 
		for (i=0; i<number_pe; i++)
			if (map[i][j]!=-1) {
				total++;
				state[map[i][j]]++;
			}
		if (total<number_pe-2 || total>number_pe) return  0;	
		for (i=0; i<number_pe; i++) if (state[i]) n++;
		if (n>1) return 0;
	}
	return 1;
}

IsItAReduction(map, levels)
int **map, levels;
{
	int i, j, count;

	for (i=0; i<levels; i++) {
		count=0;
		for (j=0; j<number_pe; j++) state[j]=0;
		for (j=0; j<number_pe; j++) 
			if (map[j][i]>=0) state[j]++;
			else if (map[j][i]<-1) state[j] += -(map[j][i]);
		for (j=0; j<number_pe; j++) if (state[j] > 1) count++;
		if (count<=1) return 0;
	}
	return 1;
}

BocWhichPattern(idx, map, levels)
int idx, **map, levels;
{
	int i;
	char yes=1;

	if (!levels) return;

	if (IsItABroadcast(map, levels))  patterns[idx][BROADCAST]++;
	for (i=0; i<levels; i++) yes = yes && IsItAPermutation(map, i);
	if (yes) {
		for (i=0; i<number_pe; i++) yes = yes && IsItACycle(map, i, levels);
		if (yes) patterns[idx][CYCLIC]++;
		else patterns[idx][CHAIN]++;
	}
	else if (levels==1) {
		/* small exchange, bottleneck, spantree */
		if (IsItABottleneck(map)) {
			patterns[idx][BOTTLENECK]++;
			if (number_pe<=5) patterns[idx][SPANTREE]++;
		}
	}
	else {
		/** exchange, spanning tree, chain */
		if (IsItAChain(map, levels)) patterns[idx][SEQCHAIN]++;
		else {
			/** exchange, spanning tree **/
			if (IsItASpanTree(map, levels)) patterns[idx][SPANTREE]++;
		}
	}
	if (IsItAReduction(map, levels)) {
		patterns[idx][EXCHANGE]++;
		patterns[idx][REDUCTION]++;
	}
}

ChareWhichPattern(idx, map, levels)
int idx, **map, levels;
{
}
