/***************************************************************************
 * RCS INFORMATION:
 *
 *  $RCSfile: log.c,v $
 *  $Author: milind $  $Locker:  $    $State: Exp $
 *  $Revision: 1.5 $  $Date: 1997/04/03 20:02:08 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: log.c,v $
 * Revision 1.5  1997/04/03 20:02:08  milind
 * Fixed the projections checkin problem due to unnecessary locks
 * inherited from the days when RCS was used.
 *
 * Revision 1.4  1995/11/03 04:31:42  sanjeev
 * for END_PROCESSING, msg_type contains the chare-magic number
 *
 * Revision 1.3  1995/09/21  21:06:13  sanjeev
 * *** empty log message ***
 *
 * Revision 1.2  1995/02/24  23:22:35  jyelon
 * *** empty log message ***
 *
 ***************************************************************************/
static char ident[] = "@(#)$Header: /expand1/cvsroot/projections/sources/analyse/log.c,v 1.5 1997/04/03 20:02:08 milind Exp $";
#include <ctype.h>
#include <string.h>
#include "analyse.h"
#include "common.h"
#include "data.h"

extern NODE *AddTransaction();

static char *null_type = "";
static char *boc_type = "BOC";
static char *chare_type = "CHARE";

static NODE *charminit_node=NULL;
static int TotalChares, TotalEps, TotalMsgs, TotalPseudos;

/*************************************************************************/
/** Remove translator padding                      **/
/*************************************************************************/
char *strip_digits(s)
char *s;
{
  int i=0;
  char *name;

  name = (char *) malloc(strlen(s)+1);
  if (!strstr(s, "_CK"))
    strcpy(name, s);
  else {
    strcpy(name, s+3);
    while (isdigit(name[i])) i++;
  }
  return &(name[i]);
}


/*************************************************************************/
/** Get the corresponding index from the ep_table.            **/
/*************************************************************************/
is_msg_to_boc(msg_type)
int msg_type;
{
  if (msg_type==BocInitMsg || msg_type==BocMsg ||
    msg_type==BroadcastBocMsg || msg_type==DynamicBocInitMsg)
      return 1;
  return 0;
}


get_ep_index(ep, msg_type)
int ep, msg_type;
{
  int i=0;
  char type[1000];

  switch (msg_type) {
    case NewChareMsg:
    case ForChareMsg:
      strcpy(type,  chare_type);
      break;
    case BocInitMsg:
    case BocMsg:
    case BroadcastBocMsg:
    case DynamicBocInitMsg:
    /* this should ideally be boc_type, but i need to get info about bocs*/
      strcpy(type, boc_type);
      break;
    default:
      strcpy(type, null_type);
      return -1;
  }
  while (i<number_entries && (grainsize_table[i].ep!=ep || 
        strcmp(grainsize_table[i].type, type)))
    i++;
  if(i>=number_entries)
    return -1;
  return i;
}


/*************************************************************************/
/** Update the grainsize for an entry.                  **/
/*************************************************************************/
update_grainsize_table(index, pe, t1, t2)
int index, pe, t1, t2;
{
  int s;
  GS_PAIR *pair;

  s = INTERVAL(t2);
  pair = &(grainsize_table[index].list[pe][s]);
  pair->sum = t2-t1;
  pair->no++;
}

/*************************************************************************/
/** We compute the busy period in this function.      **/
/*************************************************************************/
compute_percent(ep_index, pe, begin, end, last_interval, current_interval)
int ep_index, pe;
unsigned int begin, end;
int last_interval, current_interval;
{
  int i;
  int *my_display;
  unsigned int border;

  if((begin == -1) && (last_interval == -1))
    return;

  if(ep_index >=0)
    my_display = display_table[IDLE_TIME][pe];
  else {
    my_display = display_table[OVERHEAD_TIME][pe];
  }
  if(current_interval > last_interval) {
    for(i=last_interval; i<current_interval; i++) {
      border = timestep*(i+1) + begin_time;
      my_display[i] += border - begin;
      begin = border;
    }
    my_display[current_interval] += end - border;
  } else
    my_display[current_interval] += end - begin;
  if(my_display[current_interval] < 0){
    /* this has to be done because of a bug in tachyon removal */
    my_display[current_interval] = -5;
  }
}



/*************************************************************************/
/** This function is used to process creation message types.    **/
/*************************************************************************/

get_creation_display_index(msg_type)
int msg_type;
{
  int display_index;

  /*****************************************************************/
  /** Get the proper display table.        **/
  /******************************************************************/
  switch (msg_type)
  {
  case NewChareMsg:
    display_index = CREATE_NEWCHARE;
    break;
  case ForChareMsg:
    display_index = CREATE_FORCHARE;
    break;
  case BroadcastBocMsg:
  case BocMsg:
    display_index = CREATE_FORBOC;
    break;
  default:
    display_index = -1;
    break;
  }
  return display_index;
}



/*************************************************************************/
/*************************************************************************/

get_processing_display_index(msg_type)
int msg_type;
{
  /*****************************************************************/
  /** Get the proper display table.        **/
  /******************************************************************/
  switch (msg_type)
  {
  case NewChareMsg:
    return PROCESS_NEWCHARE;
    break;
  case ForChareMsg:
    return PROCESS_FORCHARE;
  case BocMsg:
    return PROCESS_FORBOC;
  case LdbMsg:
    return PROCESS_LDB;
  case QdBocMsg:
  case QdBroadcastBocMsg:
    return PROCESS_QD;
  default:
    return -1;
  }
}




/*************************************************************************/
/** This function is used to read in a log file and generate the display**/
/** information for it.              **/
/*************************************************************************/

read_in_log_file(filename, suffix, pe, stages, timestep)
char *filename, *suffix;
int pe, stages, timestep;
{
  NODE *n;
  int done;
  int temp;
  FILE *fp;
  int replay=0;
  int i, ep_index;
  int display_index;
  char name[MAXFILE];
  char what[MAXFILE];
  unsigned int time1, time2;
  int begin_interrupt = -1, end_interrupt = -1;
  int transaction_type, msg_type, entry, event_id, pe_id, destination;

  /*****************************************************************/
  /** Get the file name and open it.        **/
  /*****************************************************************/
  done = 0;
  queue_size = 0;
  previous_stage = 0;
  sprintf(name, "%s.%d.%s", filename, pe, suffix);
  fp = fopen(name, "r");
  if (fp == NULL) {
    printf("*** ERROR *** Unable to open log file %s\n", name);
    exit(1);
  }

  fscanf(fp, "%s", what);
  if (!strcmp(what, "PROJECTIONS-REPLAY")) replay=1;
    

  /*********************************************************/
  /** Read in the entries and process them.    **/
  /*********************************************************/
  while (read_in_projections_data(fp, replay,
            &transaction_type, &msg_type, &entry,
            &time1, &event_id, &destination, &pe_id) != EOF) {

    /* Convert message types to take into account new types 
       - Sanjeev 9/21/95 */
    if ( transaction_type != END_PROCESSING ) {
         switch ( msg_type ) {
      case NewChareNoBalanceMsg: 
        msg_type = NewChareMsg ;
        break ;
      case ImmBocMsg:
        msg_type = BocMsg ;
        break ;
      case ImmBroadcastBocMsg:
        msg_type = BroadcastBocMsg ;
        break ;
        }
    }

    /*************************************************/
    /** Perform appropriate actions for this entry.  **/
    /*************************************************/
    switch (transaction_type)
    {
    case CREATION:
      if (entry == -1) entry = charminit_id;
      if  ((ep_index = get_ep_index(entry, msg_type)) >=0 )
        ep_c_display_table[ep_index][pe][INTERVAL(time1)]++;

      AddTransaction(pe, pe_id, event_id, entry, msg_type,
                transaction_type, time1);

      display_index = get_creation_display_index(msg_type);
      if (display_index >=0)
        display_table[display_index][pe][INTERVAL(time1)]++;

      break;

    case BEGIN_PROCESSING:
      if (entry == -1) {
        InsideCharmInit=1;
        current_node = charminit_node =
          AddTransaction(pe, pe_id, event_id,
              charminit_id, msg_type, transaction_type, time1);
      }
      else {
        if (InsideCharmInit) InsideCharmInit=0;
        current_node = AddTransaction(pe, pe_id, event_id,
              entry, msg_type, transaction_type, time1);
      }
      break;

    case END_PROCESSING:
      if (InsideCharmInit) {
        InsideCharmInit=0;    
        current_node = charminit_node = NULL;
      }
      else if (charminit_node) {
        InsideCharmInit=1;
        current_node=charminit_node;
      }
      else current_node = NULL;

      if (entry == -1) 
        n = AddTransaction(pe, pe_id, event_id, charminit_id, msg_type,
              transaction_type, time1);
      else
        n = AddTransaction(pe, pe_id, event_id, entry, msg_type,
              transaction_type, time1);

                        /* For END_PROCESSING the chare-magic is stored in
                           msg_type, so we get the real msg_type from n */
                        msg_type = n->msg_type ;


      time2=time1;
      time1=n->timep1;
      if (entry == -1) { 
        entry = charminit_id;
        for (i=INTERVAL(time1); i<=INTERVAL(time2); i++)
          stage_status[pe][i] = CHARMINIT;
      }

      ep_index = get_ep_index(entry, msg_type); 
      display_index = get_processing_display_index(msg_type);
      if ((begin_interrupt != -1) && 
          (time1 <= begin_interrupt) &&
          (time2 >= end_interrupt))

      {
        compute_percent(ep_index, pe, time1, begin_interrupt,
                INTERVAL(time1), INTERVAL(begin_interrupt));
        compute_percent(ep_index, pe, end_interrupt, time2,
                  INTERVAL(end_interrupt), INTERVAL(time2));
        if (ep_index>=0)
        {
          update_grainsize_table(ep_index, pe, time1, 
                  begin_interrupt);
          update_grainsize_table(ep_index, pe, end_interrupt,
                  time2);
        }
      }
      else
      {
        compute_percent(ep_index, pe, time1, time2, 
                  INTERVAL(time1), INTERVAL(time2));
        if (ep_index >= 0)
          update_grainsize_table(ep_index, pe, time1, time2);
      }
      begin_interrupt = end_interrupt = -1;
      if (display_index >= 0)
      {
        total_events++;
        display_table[display_index][pe][INTERVAL(time2)]++;
      }
      if (ep_index >= 0)
        ep_p_display_table[ep_index][pe][INTERVAL(time2)]++;
      break;

    case ENQUEUE:
      display_table[QUEUE_SIZE][pe][INTERVAL(time1)] = queue_size++;
      AddTransaction(pe, pe_id, event_id, -1, -1,
              transaction_type, time1);
      break;

    case DEQUEUE:
      display_table[QUEUE_SIZE][pe][INTERVAL(time1)] = queue_size--;
      AddTransaction(pe, pe_id, event_id, -1, -1,
                transaction_type, time1);
      break;

    case INSERT:
    case FIND:
    case DELETE:
      if (charminit_node)
        AddAdditionalTable(transaction_type, charminit_node,
                    msg_type, entry, pe_id);
      else 
        AddAdditionalTable(transaction_type, current_node,
                    msg_type, entry, pe_id);
      break;

    case BEGIN_INTERRUPT:
      begin_interrupt=time1;
      AddTransaction(pe, pe_id, event_id, -1, -1,
                transaction_type, begin_interrupt);
      break;

    case END_INTERRUPT:
      end_interrupt=time1;
      AddTransaction(pe, pe_id, event_id, -1, -1,
                transaction_type, end_interrupt);
      for (i=INTERVAL(begin_interrupt); i<=INTERVAL(end_interrupt); i++)
          stage_status[pe][i] = INTERRUPT;
      break;

    case BEGIN_COMPUTATION:
      break;

    case END_COMPUTATION:
      break;

    default:
      printf("***ERROR*** Non-terminated log file for  processor %d.\n", 
              pe);
      break;
    }
  }

  fclose(fp);
  for (i=0; i<stages; i++)
  {
    temp = display_table[IDLE_TIME][pe][i];
    display_table[IDLE_TIME][pe][i]  = (100*temp)/timestep;

    temp = display_table[OVERHEAD_TIME][pe][i];
    display_table[OVERHEAD_TIME][pe][i]  = (100*temp)/timestep;
  }
}



/*************************************************************************/
/** Read in state file information.                    **/
/*************************************************************************/
read_in_state_file(filename)
char *filename;
{
  FILE *fp;
  int done;
  int id, chareid,msgid;
  char type[1000], name[1000];
  int size, msg_index, pseudo_index, pseudo_type;

  /*****************************************************************/
  /** Get the file name and open it.              **/
  /*****************************************************************/
  fp = fopen(filename, "r");
  if (fp == NULL) {
    printf("*** ERROR *** Unable to open state file %s\n", filename);
    exit(1);
  }
  done = 0;
  number_chares = 0;
  number_entries = 0;
  number_pseudos = 0;
  while (!done)
  {
    fscanf(fp, "%s", type);
    if (!strcmp(type, "ENTRY"))
    {
      ENTRY_LIST *temp;

      fscanf(fp, "%s %d %s %d %d", type, &id, name, &chareid, &msgid);
      strcpy(chare_list[chareid].type, type);
      temp = (ENTRY_LIST *) malloc(sizeof(ENTRY_LIST));
      temp->number = id;
      temp->chareid = chareid;
      strcpy(temp->name, strip_digits(name));
      temp->index = number_entries;
      temp->next = chare_list[chareid].list;
      chare_list[chareid].list = temp;
      chare_list[chareid].number_entries++;
      grainsize_table[number_entries].ep = id;
      grainsize_table[number_entries].chareid = chareid;
      grainsize_table[number_entries].msgid = msgid;
      strcpy(grainsize_table[number_entries].type,
            chare_list[chareid].type);
      strcpy(grainsize_table[number_entries].name, strip_digits(name));
/* printf("entry = %s, strcmp = %d\n", strip_digits(name),
strcmp(strip_digits(name), "CharmInit")); */
      if (!strcmp(strip_digits(name), "CharmInit"))
        charminit_id = id;
      number_entries++;
    }
    else if (!strcmp(type, "CHARE") || (!strcmp(type, "BOC")))
    {
      fscanf(fp, "%d %s", &id, name);
      chare_list[id].chareid = id;
      chare_list[id].number_entries  = 0;
      strcpy(chare_list[id].name, name);
      strcpy(chare_list[id].type, type);
      chare_list[id].list = NULL;
      number_chares++;
    }
    else if (!strcmp(type, "MACHINE"))
      fscanf(fp, "%s", machine_name);
    else if (!strcmp(type, "PROCESSORS"))  
      fscanf(fp, "%d", &number_pe);
    else if (!strcmp(type, "MESSAGE"))  {
      fscanf(fp, "%d %d", &msg_index, &size);
      msg_table[msg_index] = size;
    }
    else if (!strcmp(type, "PSEUDO"))  {
      fscanf(fp, "%d %d %s", &pseudo_index, &pseudo_type, name);
      pseudo_table[number_pseudos].index = pseudo_index;
      pseudo_table[number_pseudos].type = pseudo_type;
      strcpy(pseudo_table[number_pseudos].name, name);
      number_pseudos++;
    }
    else if (!strcmp(type, "TOTAL_CHARES"))  {
      fscanf(fp, "%d", &TotalChares);
      chare_list = (CHARE *) malloc(sizeof(CHARE)*TotalChares);
    }
    else if (!strcmp(type, "TOTAL_EPS"))  {
      fscanf(fp, "%d", &TotalEps);
      grainsize_table = (GS_LIST  *) malloc(sizeof(GS_LIST)*TotalEps);
      ep_c_display_table = (int ***) malloc(sizeof(int **)*TotalEps); 
      ep_p_display_table = (int ***) malloc(sizeof(int **)*TotalEps); 
    }
    else if (!strcmp(type, "TOTAL_MSGS"))  {
      fscanf(fp, "%d", &TotalMsgs);
      msg_table = (int *) malloc(sizeof(int)*(TotalMsgs+1));
    }
    else if (!strcmp(type, "TOTAL_PSEUDOS"))  {
      fscanf(fp, "%d", &TotalPseudos);
      pseudo_table = (PSEUDO_STRUCT *) 
          malloc(sizeof(PSEUDO_STRUCT)*TotalPseudos);
    }
    else if (!strcmp(type, "END"))
      done = 1;
  }
}


/*************************************************************************/
/*************************************************************************/
recalculate(pe)
int pe;
{
  int i, ep_index;
  int display_index;
  unsigned int time1, time2;
  int begin_interrupt = -1, end_interrupt = -1;
  int transaction_type, msg_type, entry, event_id, pe_id;

  NODE * n;
  QUEUE_LIST *temp;
  TRANSACTION *current = transaction_table[pe].head;

  /*****************************************************************/
  /** Get the file name and open it.        **/
  /*****************************************************************/
  queue_size = 0;

  /*********************************************************/
  /** Read in the entries and process them.    **/
  /*********************************************************/
  while (current)
    {
        transaction_type = current->type;
        n = current->info;
        msg_type = n->msg_type;
        entry = n->ep;
        event_id = n->event;
        pe_id = n->pe;

    /*************************************************/
    /** Perform appropriate actions for this entry.  **/
    /*************************************************/
    switch (transaction_type)
    {
    case CREATION:

      time1 = n->timec;
      if  ((ep_index = get_ep_index(entry, msg_type)) >=0 )
        ep_c_display_table[ep_index][pe][INTERVAL(time1)]++;

      display_index = get_creation_display_index(msg_type);
      if (display_index >=0)
        display_table[display_index][pe][INTERVAL(time1)]++;
      break;

    case BEGIN_PROCESSING:
      time1 = n->timep1;
      break;

    case END_PROCESSING:

      time1 = n->timep1;
      time2 = n->timep2;

      if (entry == charminit_id) 
        for (i=INTERVAL(time1); i<=INTERVAL(time2); i++)
          stage_status[pe][i] = CHARMINIT;

      ep_index = get_ep_index(entry, msg_type); 
      display_index = get_processing_display_index(msg_type);
      if ((begin_interrupt != -1) && 
          (time1 <= begin_interrupt) &&
          (time2 >= end_interrupt))

      {
        compute_percent(ep_index, pe, time1, begin_interrupt,
                INTERVAL(time1), INTERVAL(begin_interrupt));
        compute_percent(ep_index, pe, end_interrupt, time2, 
                INTERVAL(end_interrupt), INTERVAL(time2));
        if (ep_index>=0)
        {
          update_grainsize_table(ep_index, pe, time1, 
                  begin_interrupt);
          update_grainsize_table(ep_index, pe, end_interrupt,
                  time2);
        }
      }
      else
      {
        compute_percent(ep_index, pe, time1, time2,
                  INTERVAL(time1), INTERVAL(time2));
        if (ep_index >= 0)
          update_grainsize_table(ep_index, pe, time1, time2);
      }
      begin_interrupt = end_interrupt = -1;
      if (display_index >= 0)
      {
        total_events++;
        display_table[display_index][pe][INTERVAL(time2)]++;
      }
      if (ep_index >= 0)
        ep_p_display_table[ep_index][pe][INTERVAL(time2)]++;
      break;

    case ENQUEUE:
            temp = n->enqueue;
            while (temp!=NULL) {
                if (temp->ptr == current) break;
                temp = temp->next;
            }
      time1 = temp->time;

      display_table[QUEUE_SIZE][pe][INTERVAL(time1)] = queue_size++;
      break;

    case DEQUEUE:
            temp = n->dequeue;
            while (temp!=NULL) {
                if (temp->ptr == current) break;
                temp = temp->next;
            }
      display_table[QUEUE_SIZE][pe][INTERVAL(time1)] = queue_size--;
      break;

    case INSERT:
    case FIND:
    case DELETE:
      break;

    case BEGIN_INTERRUPT:
      begin_interrupt = n->timep1;
      break;

    case END_INTERRUPT:
      end_interrupt = n->timep2;
      for (i=INTERVAL(begin_interrupt); i<=INTERVAL(end_interrupt); i++)
          stage_status[pe][i] = INTERRUPT;
      break;


    default:
      printf("***ERROR*** Wierd Event.\n");
      break;
    }
/* 
printf("%d %d %d %u %u %d %d\n", 
transaction_type, msg_type,  entry, time1, time2, event_id, pe_id);
*/
    AddStagePtr(pe, time1, current);
    current = current->next;
  }

  for (i=0; i<stages; i++)
  {
    int temp;
    temp = display_table[IDLE_TIME][pe][i];
    display_table[IDLE_TIME][pe][i]  = (100*temp)/timestep;

    temp = display_table[OVERHEAD_TIME][pe][i];
    display_table[OVERHEAD_TIME][pe][i]  = (100*temp)/timestep;
  }
}

#include "io.c"
