/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: critical.c,v $
 *	$Author: sanjeev $	$Locker:  $		$State: Exp $
 *	$Revision: 1.3 $	$Date: 1995/11/03 04:37:10 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: critical.c,v $
 * Revision 1.3  1995/11/03 04:37:10  sanjeev
 * *** empty log message ***
 *
 * Revision 1.2  1995/02/24  23:22:35  jyelon
 * *** empty log message ***
 *
 ***************************************************************************/
static char ident[] = "@(#)$Header: /expand1/cvsroot/projections/sources/analyse/critical.c,v 1.3 1995/11/03 04:37:10 sanjeev Exp $";
#include "head.h"
#include "common.h"
#include "analyse.h"
#include "data.h"
#include "shared.h"



AddCriticalList(t)
TRANSACTION *t;	
{
/* Add a transaction to the beginning of critical list */

	TRANSACTION_LIST *temp = 
		(TRANSACTION_LIST *) malloc(sizeof(TRANSACTION_LIST));	
	temp->ptr = t;
	temp->next = critical_list;
	temp->previous = NULL;
	if (critical_list) critical_list->previous = temp;
	critical_list = temp;
}

TRANSACTION *SkipToPreviousProcessing(t)
TRANSACTION *t;
{
/* Return the BEGIN_PROCESSING transaction of t's creator */

	if (t->info->creator) return t->info->creator->info->ptrp1;
	else return NULL;
}

TRANSACTION *ExaminePredecessors(maxt, critical_list, critical_entries)
TRANSACTION *maxt;
TRANSACTION_LIST *critical_list;
int *critical_entries;
{
/* Add as many user-pgm transactions to critical list as possible. 
   This ends either when there is spontaneous creation (eg after Quiescence),
   or when we reach a system transaction. */

	int idx;
	TRANSACTION *t, *previous;

	/* Go back from last event, and check for possibility of non-overlap */
	for (previous=maxt,t=maxt; t!=NULL;
				previous=t,t=SkipToPreviousProcessing(t)) {
		if (t->type != BEGIN_PROCESSING) 
			printf("*** ERROR *** Did not get back processing event.\n");
		idx = get_ep_index(t->info->ep, t->info->msg_type);
		if (idx == -1) break;
		if (t->info->creator == t) break;

		critical_entries[idx] = 1;
		AddCriticalList(t);
	}
	return previous;

}



TRANSACTION *FindLastEventBeforeThis(time)
unsigned int time;
{
/* Find last user-pgm transaction that occurred before "time" */

	unsigned int max;
	TRANSACTION *t, *maxt;
	int i, maxi, idx, interval;

	maxi = -1;
	maxt = NULL;
	max = begin_time;
	interval = INTERVAL(time);

	while (interval>=0 && !maxt) {
		for (i=0; i<number_pe; i++)
		{
			for (t = start_stage[i][interval]; t!=NULL; t=t->next) {
				if (t->type!=BEGIN_PROCESSING) continue;
				idx = get_ep_index(t->info->ep, t->info->msg_type);
				if (idx == -1) continue;
				if (t->info->creator == t) break;
				
				if (t->info->timep2 <= time) {
					if (!maxt ||  (t->info->timep2 > maxt->info->timep2)) {
						maxt = t;
						max = maxt->info->timep2;
						maxi = i;
					}
				}
				else break;
			}
		}
		if (maxt) return maxt;
		interval--;
	}
	return NULL;
}

TRANSACTION * IsThisReallyTheLast(maxt)
TRANSACTION *maxt;
{
	TRANSACTION *t;
	TRANSACTION_LIST *list, *queue, *element;

	if (!maxt) return NULL;
	element = (TRANSACTION_LIST *) malloc(sizeof(TRANSACTION_LIST));
	element->ptr = maxt;
	element->next = queue = NULL;
	queue = element;

	while (queue) {
		/* dequeue first element */
		list = queue;
		queue = queue->next;
		t = list->ptr;
		free(list);

		if (t->info->timep2 > maxt->info->timep2) maxt = t;

		/* insert creation list into queue */
		if (t->info->creation_list) {
			list = t->info->creation_list;
			while (list) {
				element = (TRANSACTION_LIST *) malloc(sizeof(TRANSACTION_LIST));
				element->ptr = t;
				element->next = queue;
				queue = element;
				list = list->next;
			}
		}
	}
	return maxt;
}


CriticalPath()
{
	TRANSACTION *t, *maxt;
	int i, j, k, maxi, idx;
	unsigned int max, *sum;
	int total_ep_string_length=0;


	critical_list = NULL;

	/* Determine last event that was processed */
	maxt = FindLastEventBeforeThis(end_time);
	/* maxt = IsThisReallyTheLast(maxt); */
	if (maxt == NULL) return;
	mysprintf("*******************************\n");
	mysprintf("**** CRITICAL PATH ANALYSIS ***\n");
	mysprintf("*******************************\n");

	while (maxt) {
		max = maxt->info->timep2;
		maxt = ExaminePredecessors(maxt, critical_list, critical_entries);
		if (!maxt) break;
		if (GetTime(maxt) < max) max = GetTime(maxt); 
		if (max) {
			maxt = FindLastEventBeforeThis(max-1);
			/* maxt = IsThisReallyTheLast(maxt); */
		}
		else maxt = NULL;
	}

	mysprintf("The following tasks lie on the critical path:\n\t");
	InitPrintEP(total_ep_string_length, temp_string);
	for (i=0; i<number_entries; i++)
		if (critical_entries[i]) PrintEP(1, i, strlen(temp_string));
	mysprintf("\n");

	max=0;
	sum = (unsigned int *) malloc(sizeof(unsigned int)*number_entries);
	for (i=0; i<number_entries; i++) {
		if (grainsize_table[i].ep == charminit_id) continue;
		sum[i]=0;
		for (j=0; j<number_pe; j++)
			for (k=0; k<stages; k++) 
					sum[i] += grainsize_table[i].list[j][k].sum;	
		if (sum[i]>max) max=sum[i];
	}

	mysprintf("The following tasks contribute the most:\n\t");
	InitPrintEP(total_ep_string_length, temp_string);
	for (i=0; i<number_entries; i++) { 
		if (grainsize_table[i].ep == charminit_id) continue;
		if (within(sum[i],max,20)) PrintEP(1, i, strlen(temp_string));
	}
	mysprintf("\n\n");
	free(sum);
}
	

