/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: analyse.c,v $
 *	$Author: sanjeev $	$Locker:  $		$State: Exp $
 *	$Revision: 1.3 $	$Date: 1995/11/09 21:12:48 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: analyse.c,v $
 * Revision 1.3  1995/11/09 21:12:48  sanjeev
 * *** empty log message ***
 *
 * Revision 1.2  1995/02/24  23:22:35  jyelon
 * *** empty log message ***
 *
 ***************************************************************************/
static char ident[] = "@(#)$Header: /expand1/cvsroot/projections/sources/analyse/analyse.c,v 1.3 1995/11/09 21:12:48 sanjeev Exp $";
#define ANALYSE
#include "analyse.h"
#undef ANALYSE
#include "common.h"
#include "data.h"

check_memory(str,x)
char *str; 
void *x;
{
	if (x==NULL) printf("Cannot allocate memory for %s.\n", str);
}

/*************************************************************************/
/** Insert properties of machines.										**/
/*************************************************************************/
insert_machine_property(id, name, alpha, beta)
int id;
char *name;
float alpha, beta;
{
	strcpy(machine_table[id].name, name);
	machine_table[id].alpha = alpha;
	machine_table[id].beta = beta;
}


which_machine()
{
	if (!strcmp(machine_name, "sim-hp")) return SIMULATOR; 
	if (!strcmp(machine_name, "SEQUENT")) return SEQUENT;
	if (!strcmp(machine_name, "MAX")) return MAX;
	if (!strcmp(machine_name, "IPSC2")) return IPSC2;
	if (!strcmp(machine_name, "I860")) return I860;
	if (!strcmp(machine_name, "ncube2")) return NCUBE3; 
	if (!strcmp(machine_name, "cm5")) return CM5;
	if (!strcmp(machine_name, "PARAGON")) return PARAGON;
	if (!strcmp(machine_name, "net-sol")) return NETWORK;
	if (!strcmp(machine_name, "net-sun")) return NETWORK;
	if (!strcmp(machine_name, "NETWORK-ATM")) return NETWORK_ATM;
}

InitMachineProperty()
{
	insert_machine_property(SIMULATOR, "sim-hp", 20.0, 0.0);
	insert_machine_property(SEQUENT, "SEQUENT", 331.0, 0.003);
	insert_machine_property(MAX, "MAX", 300.0, 0.003);
	insert_machine_property(IPSC2, "IPSC2", 400.0, 0.0);
	insert_machine_property(I860, "I860", 400.0, 0.0);
	insert_machine_property(NCUBE3, "ncube2", 200.0, 0.0);
	insert_machine_property(CM5, "cm5", 323.0, 0.11);
	insert_machine_property(PARAGON, "PARAGON", 100.0, 0.0);
	insert_machine_property(NETWORK, "net-sol", 2000.0, 2.35);
	insert_machine_property(NETWORK_ATM, "NETWORK-ATM", 500.0, 0.4);
}

/*************************************************************************/
/** This function reads the log-file for processor 0 and then determines**/
/** the beginning and the ending times of the computation. We need these**/
/** to determine things like how many stages we want/the time-step for  **/
/** displays.								**/
/*************************************************************************/

compute_interval(filename, btime, etime)
char *filename;
unsigned *btime, *etime;
{
	int i;
	FILE *fp;
	int done;
	int dummy1;
	unsigned int temp;
	char *log_filename;
	char *tmp_filename;
	char grep_string[1000];
	unsigned int begin_time, end_time;

	end_time = 0;
	begin_time = 4294967294;
	tmp_filename = (char *) malloc(strlen(filename) + 1 + strlen(".tmp"));
	sprintf(tmp_filename, "%s.tmp", filename);

	fp = (FILE *) fopen(tmp_filename, "w");
	if (fp == NULL)
		printf("*** ERROR *** Unable to open log file %s\n", tmp_filename);
	fclose(fp);

	for (i=0; i<number_pe; i++) {
		log_filename = (char *) malloc(strlen(filename) + 5 + strlen("..log"));
		sprintf(log_filename, "%s.%d.log", filename, i);
		sprintf(grep_string, "grep \"^%d\"  %s >> %s; grep \"^%d\"  %s >> %s",
		    BEGIN_COMPUTATION, log_filename, tmp_filename,
		    END_COMPUTATION, log_filename, tmp_filename);
		system(grep_string);
	}


	done=0;
	fp = (FILE *) fopen(tmp_filename, "r");
	while (fscanf(fp, "%d", &dummy1) != EOF) {
		fscanf(fp, "%u", &temp);
		switch (dummy1) {
		case BEGIN_COMPUTATION:
			if (temp < begin_time) begin_time = temp;
			break;
		case END_COMPUTATION:
			if (temp > end_time) end_time = temp;
			break;
		default:
			done=1;
		}
	}
	fclose(fp);
	sprintf(grep_string, "rm -f %s", tmp_filename);
	system(grep_string); 
	*btime = begin_time;
	*etime = end_time;
}



/*************************************************************************/
/** This function determines the number of stages/time steps in the 	**/
/** computation. It starts off with either 0 or the user suggested time	**/
/** step, and sees if it is too fine-grained, in which case it modifies **/
/** the number of stages to the maximum allowed, and the time step is 	**/
/** set accordingly.							**/
/*************************************************************************/

compute_partitions(begin_time, end_time, stages, timestep)
unsigned int begin_time, end_time;
int *stages, *timestep;
{
	int computation_time;

	if (*timestep <= 0)
		*timestep = 10000;
	computation_time = end_time - begin_time;
	*stages = (computation_time / (*timestep))+1;
}



/*************************************************************************/
/** This function allocates spaces for the display structures.		**/
/*************************************************************************/

allocate_everytime()
{
	int i, j, k;

	/*****************************************************************/
	/** Then initialize the displays for the six displays -- current**/
	/** displays are for creation of new chares, for chares and for	**/
	/** boc, and for the processing of new chares, for chares and   **/
	/** for boc.							**/
	/*****************************************************************/
	for (i=0; i<NUMBER_DISPLAYS; i++)
	{
		display_table[i] = (int **) malloc(sizeof(int *) *  number_pe);
		check_memory("display_table[i]", display_table[i]);

		for (j=0; j<number_pe; j++)
		{
			display_table[i][j] = (int *) malloc(sizeof(int) * stages);
			check_memory("display_table[i][j]", display_table[i][j]);
			for (k=0; k<stages; k++) display_table[i][j][k] = 0;
		}
	}

	if (number_entries > MAX_ENTRIES)
		printf("***ERROR*** Maximum number of entries %d exceeeded.\n",
		    MAX_ENTRIES);
	for (i=0; i<number_entries; i++)
	{
		ep_c_display_table[i] = (int **) malloc(sizeof(int *) *  number_pe);
		check_memory("ep_c_display_table[i]", ep_c_display_table[i]);

		for (j=0; j<number_pe; j++)
		{
			ep_c_display_table[i][j] = (int *) malloc(sizeof(int) * stages);
			check_memory("ep_c_display_table[i][j]", ep_c_display_table[i][j]);
			for (k=0; k<stages; k++) ep_c_display_table[i][j][k] = 0;
		}
	}

	for (i=0; i<number_entries; i++)
	{
		ep_p_display_table[i] = (int **) malloc(sizeof(int *) *  number_pe);
		check_memory("ep_p_display_table[i]", ep_p_display_table[i]);

		for (j=0; j<number_pe; j++)
		{
			ep_p_display_table[i][j] = (int *) malloc(sizeof(int) * stages);
			check_memory("ep_p_display_table[i][j]", ep_p_display_table[i][j]);
			for (k=0; k<stages; k++) ep_p_display_table[i][j][k] = 0;
		}
	}

    start_stage = (TRANSACTION ***) malloc(sizeof(TRANSACTION **)*number_pe);
    check_memory("InitData", start_stage);
    for (i=0; i<number_pe; i++)
    {
        start_stage[i] = (TRANSACTION **)
            malloc(sizeof(TRANSACTION *) * (stages+1));
        check_memory("InitData", start_stage[i]);
    }
    for (i=0; i<number_pe; i++)
        for (j=0; j<=stages; j++)
            start_stage[i][j] = NULL;

    stage_status = (int **) malloc(sizeof(int *) * number_pe);
    check_memory("InitData", stage_status);
    for (i=0; i<number_pe; i++)
    {
        stage_status[i] = (int *) malloc(sizeof(int) * stages);
        check_memory("InitData", stage_status[i]);
    }
    for (i=0; i<number_pe; i++)
        for (j=0; j<stages; j++)
            stage_status[i][j] = 0;
   	for (i=0; i<number_entries; i++)
    {
        grainsize_table[i].list = (GS_PAIR **)
                malloc(sizeof(GS_PAIR *)*number_pe);
        check_memory("grainsize_table[i].list", grainsize_table[i].list);
        for (j=0; j<number_pe; j++)
        {
            grainsize_table[i].list[j] = (GS_PAIR  *)
                malloc(sizeof(GS_PAIR)*stages);
            for (k=0; k<stages; k++) {
                grainsize_table[i].list[j][k].sum = 0;
                grainsize_table[i].list[j][k].no = 0;
            }
        }
    }
}


allocate_once()
{
    int i, j, k;

    for (i=0; i<HASH_TABLE_SIZE; i++)
        hash_table[i] = NULL;

    transaction_table = (TRANSACTION_QUEUE *)
            malloc(sizeof(TRANSACTION_QUEUE)*number_pe);
    check_memory("transaction_table", transaction_table);
    for (i=0; i<number_pe; i++)
        transaction_table[i].head = transaction_table[i].tail = NULL;
}



free_everytime()
{
	int i, j, k;

	for (i=0; i<NUMBER_DISPLAYS; i++)
	{
		for (j=0; j<number_pe; j++)
			free(display_table[i][j]);
		free(display_table[i]);
	}

	for (i=0; i<number_entries; i++)
	{
		for (j=0; j<number_pe; j++)
			free(ep_c_display_table[i][j]);
		free(ep_c_display_table[i]);

		for (j=0; j<number_pe; j++)
			free(ep_p_display_table[i][j]);
		free(ep_p_display_table[i]);
	}

    for (i=0; i<number_pe; i++)
        free(start_stage[i]);
    free(start_stage);

    for (i=0; i<number_pe; i++)
        free(stage_status[i]);
    for (i=0; i<number_entries; i++)
    {
        for (j=0; j<number_pe; j++)
            free(grainsize_table[i].list[j]);
		free(grainsize_table[i].list);
    }
}


/*************************************************************************/
/** This is the main body of the program.				**/
/*************************************************************************/

analyse()
{
	int i;
	char *filename;
	static finished_writing = 0;


	filename = pgm_filename;
	my_string = (char *) malloc(strlen("")+1);
	strcpy(my_string, "");
	store_string = (char *) malloc(strlen("")+1);
	strcpy(store_string, "");


	/*****************************************************************/
	/** Determine the beginning and the end times of the computation**/
	/** and the time step and number of partitions.			**/
	/*****************************************************************/
	state_filename = (char *) malloc(strlen(pgm_filename) +
	    strlen(".sts") + 1);
	sprintf(state_filename, "%s.sts", pgm_filename);
	read_in_state_file(state_filename);

	compute_interval(filename, &begin_time, &end_time);

	allocate_once();
	InitMachineProperty();
	machine_type = which_machine();

	if (!finished_writing)
	{
		printf("Program execution began at %u, and ended at %u.\n",
		    begin_time, end_time);
		finished_writing = 1;
	}
	printf("The number of processors used for execution were %d.\n",
	    number_pe);
	printf("The timestep has been chosen as %d.\n", timestep);

	compute_partitions(begin_time, end_time, &stages, &timestep);
	printf("The execution of the program has been split into %d stages.\n",
	    stages);

	/*****************************************************************/
	/** Next allocate the display structures, and initialize them.  **/
	/*****************************************************************/

	allocate_everytime(stages, number_pe);

	/*****************************************************************/
	/** Read in the log files now and write output onto the		**/
	/** temporary file.						**/
	/*****************************************************************/
	for (i=0; i<number_pe; i++)
	{
		printf("Processing trace file for processor %d.\n", i);
		read_in_log_file(filename, "log", i, stages, timestep);
	}

	if (i=AreThereTachyons()) {
		printf("\n");
		printf("There are %d tachyons in your log-file.\n", i);
		if (adjust_for_tachyon) {

			printf("Readjusting trace-data to remove tachyons.\n");
			RemoveTachyons();

			if (i=AreThereTachyons())
				printf("Caveat: There are still %d tachyons.\n\n", i);

			RecomputeEndTime(&end_time);
			compute_partitions(begin_time, end_time, &stages, &timestep);
			printf("Updated completion time is %u.\n", end_time);
			printf("The execution of the program is divided into %d stages.\n",
	    			stages);

			free_everytime();
			allocate_everytime();
			for (i=0; i<number_pe; i++)
				recalculate(i);
		}
		else 
			printf("Please use +y option to adjust for tachyons.\n");
	}

	debug_stuff();
}

reanalyse()
{
	int i;

	compute_partitions(begin_time, end_time, &stages, &timestep);
	printf("The execution of the program has been split into %d stages.\n",
	    stages);
	free_everytime();
	allocate_everytime();
	for (i=0; i<number_pe; i++)
		recalculate(i);
	debug_stuff();
}

