// Hey emacs, this is -*- C++ -*-
#ifndef _tam_h_
#define _tam_h_
/************************************************************************/
/*									*/
/*	N'th Fiboncci number, using the naive recursive algorithm,	*/
/*	and explicit grainsize control.				        */
/************************************************************************/


#include "megatest++.h"
#include "messages.h"
#include "generic_class.h"

#define INFINITY  	999999
#define MAX_COUNT 	10

/* ****************************************** */

message class tam_ACC_MSG {
public:     int nodes;
};

message class tam_MONO_MSG {
public:     int least;
};


message class tam_INIT_MSG {
public:     ChareNumType dummy;
};
   
message class tam_VAGUE_MSG {
public:     int id;
     int count;
     int accid;
     int monoid;
};

message class tam_INFO_MSG {
public:     int monoid;
};

/* ****************************************** */

accumulator class tam_ACC1 {

     tam_ACC_MSG *msg;

  public:
     tam_ACC1 (tam_ACC_MSG *data);

      void Accumulate (tam_ACC_MSG *data);

     void Combine (tam_ACC_MSG *y);

};

/* ****************************************** */

monotonic class tam_MONO1  {
	
     tam_MONO_MSG *msg;

  public:
     tam_MONO1 (tam_MONO_MSG *data);

     int Update (tam_MONO_MSG *y);

};

/* ****************************************** */

extern void tam_initfn();

/* ****************************************** */

chare class tam_start : public generic_class {

  private:

     int count;
     ChareIDType chareid;
     int  monoid[4];
     int iteration;
     EntryPointType retEP;
     generic_class handle retID;
     
  entry:

     tam_start(INIT_MSG *imsg);

     void Quiescence (QuiescenceMessage *dmsg);

     void AccEntry (tam_ACC_MSG *msg);

     void INFO (tam_INFO_MSG *msg);

};

/* ****************************************** */

chare class next {

  private:
     int id;
     int accid;
     int monoid;
     next handle chareid;
     tam_start handle main_chareid;
     int acc_recd;
     int mono_recd;
     
  entry:
     next (tam_INIT_MSG *msg);

     void AccEntry (tam_INIT_MSG *msg);

     void MonoEntry (tam_INIT_MSG *msg);

     void  BEGIN (tam_VAGUE_MSG *msg);

};

/* ****************************************** */

#endif
