/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: bigmsg.c,v $
 *	$Author: jyelon $	$Locker:  $		$State: Exp $
 *	$Revision: 1.2 $	$Date: 1996/11/20 06:06:49 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: bigmsg.c,v $
 * Revision 1.2  1996/11/20 06:06:49  jyelon
 * Corrected faulty prototype for 'time'.
 *
 * Revision 1.1  1996/07/09 23:53:57  jyelon
 * Initial revision
 *
 * Revision 1.1  1996/07/02 21:22:49  jyelon
 * Initial revision
 *
 ***************************************************************************/
static char ident[] = "@(#)$Header: /expand1/cvsroot/charm/pgms/megacon/bigmsg.c,v 1.2 1996/11/20 06:06:49 jyelon Exp $";

#include <stdio.h>
#include <time.h>
#include <converse.h>

CpvDeclare(int, bigmsg_index);

#define CmiMsgHeaderSizeInts \
    ((CmiMsgHeaderSizeBytes+sizeof(int)-1)/sizeof(int))

void Cpm_megacon_ack();

void bigmsg_handler(int *msg)
{
  int i, next;
  if (CmiMyPe()==0) {
    for (i=CmiMsgHeaderSizeInts; i<250000; i++) {
      if (msg[i] != i) {
	CmiPrintf("Failure in bigmsg test, data corrupted.\n");
	exit(1);
      }
    }
    Cpm_megacon_ack(CpmSend(0));
  } else {
    next = (CmiMyPe()+1) % CmiNumPes();
    CmiSyncSend(next, 250000*sizeof(int), msg);
  }
}

void bigmsg_init()
{
  int i, *msg;
  if (CmiNumPes()<2) {
    CmiPrintf("note: bigmsg requires at least 2 processors, skipping test.\n");
    Cpm_megacon_ack(CpmSend(0));
  } else {
    msg = CmiAlloc(250000 * sizeof(int));
    for (i=CmiMsgHeaderSizeInts; i<250000; i++) msg[i] = i;
    CmiSetHandler(msg, CpvAccess(bigmsg_index));
    CmiSyncSendAndFree(1, 250000 * sizeof(int), msg);
  }
}

void bigmsg_moduleinit()
{
  CpvInitialize(int, bigmsg_index);
  CpvAccess(bigmsg_index) = CmiRegisterHandler(bigmsg_handler);
}
