// Hey emacs, this is -*- C++ -*-

#ifndef _acc_h_
#define _acc_h_

/************************************************************************/
/*									*/
/*	Nth Fiboncci number, using the naive recursive algorithm,	*/
/*	and explicit grainsize control.				        */
/************************************************************************/

#include "messages.h"
#include "icount.h"
#include "ihist.h"
#include "fcount.h"
#include "fib.h"
#include "megatest++.h"
#include "generic_class.h"

#define N 20

/* Placed in acc.P
readonly int acc_topFib, acc_grainSize;
readonly ICounter handle icount;
readonly IHistogram handle ihist;
readonly FCounter handle fcount;
*/

/************************************************************/

message class acc_MSG1 {
public:     int fibNum;
     int level;
     ChareIDType parentID;
};

message class acc_MSGUP {
public:     int rspData;
};

message class acc_MSG_LEVEL {
public:     int counter[VARSIZE];
     int size;
};

/************************************************************/

extern void acc_initfn();

chare class acc_start : public generic_class {

  public:
     INIT_MSG *store;

  entry:
     acc_start (INIT_MSG *);

     void Quiescence (QuiescenceMessage *);

     void MAINEP1 (acc_MSGUP *);

     void MAINEP2 (ICounter_MSG *);

     void MAINEP3 (IHistogram_MSG *);

     void MAINEP4 (FCounter_MSG *);

};

chare class acc_fib : public generic_class {

  public:
     int	isFinal;
     int	fibNum;
     int	rspNum;
     int	rspData;
     ChareIDType parentID;
     
  entry:

     acc_fib (acc_MSG1 *);
     void RESPONSE (acc_MSGUP *);

};
     
extern void acc_ProcessResult(int, ChareIDType *, int, acc_MSGUP *);

#endif
