#ifndef _acc_P_
#define _acc_P_

/************************************************************************/
/*									*/
/*	Nth Fiboncci number, using the naive recursive algorithm,	*/
/*	and explicit grainsize control.				        */
/************************************************************************/

#include "acc.h"
readonly int acc_topFib, acc_grainSize;
readonly ICounter handle icount;
readonly IHistogram handle ihist;
readonly FCounter handle fcount;

/* ****************************************** */
/* ****************************************** */
/* ****************************************** */

// Function to start everything off
void acc_initfn()
{
	acc_topFib = 10;
	acc_grainSize = 5;

	ICounter_MSG *imsg = new ICounter_MSG ;
	icount = newaccumulator ICounter(imsg);

	IHistogram_MSG *ihmsg = new IHistogram_MSG ;
	ihmsg->size = acc_topFib - acc_grainSize + 1;
	ihist = newaccumulator IHistogram(ihmsg);

	FCounter_MSG *fmsg = new FCounter_MSG ;
	fcount = newaccumulator FCounter(fmsg);
}

/* ****************************************** */
/* ****************************************** */
/* ****************************************** */

acc_start::acc_start (INIT_MSG *imsg) {

     int   	i;
     int 	data;
     acc_MSG1 	*pMsg;
     ChareIDType chareid;
     
     store = imsg;
     
     pMsg  = new acc_MSG1 ;
     pMsg->fibNum = acc_topFib;  
     pMsg->level = 0;
     pMsg->parentID = thishandle;
     newchare acc_fib(pMsg);
     chareid = thishandle;
     CStartQuiescence(&(acc_start::Quiescence), thishandle);
     
}

/* ****************************************** */

void
acc_start::Quiescence (QuiescenceMessage *dmsg) {
     IT_MSG *imsg;
	
     generic_class handle h = store->retID;
     EntryPointType ep = store->retEP;

     imsg = new IT_MSG ;
     imsg->iteration = store->iteration;
     
     CPrintf("ACC:Quiesence: Time = %d\n",CTimer());
     CPrintf("ACC:Quiescence Detected in ACC.\n");
     h=>ep(imsg);
     delete store ;
     delete dmsg ;
}

/* ****************************************** */

void
acc_start::MAINEP1 (acc_MSGUP *m) {

     	CPrintf("ACC:Main ep message received.\n");
     	CPrintf("ACC:Result = %d\n", m->rspData);
     	CPrintf("ACC:************************************************\n");
     	CPrintf("ACC:\t\tTime Elapsed in milliseconds is %d\n",CkTimer());
     	CPrintf("ACC:************************************************\n");
	delete m ;
}

/* ****************************************** */

void
acc_start::MAINEP2 (ICounter_MSG *msg) {
	CPrintf("ACC:MAINEP2: Total number of nodes = %d\n", msg->data);
	delete msg ;
}

/* ****************************************** */

void
acc_start::MAINEP3 (IHistogram_MSG *msg) {
     	int 	i;

     	for (i=0; i<msg->size;i++)
     		if (msg->data[i] >0)
			CPrintf("ACC:Number of nodes at level %d = %d\n", i,
					msg->data[i]);
	CPrintf("ACC:MAINEP3: Time = %d\n", CTimer());
	delete msg ;
}

/* ****************************************** */

void
acc_start::MAINEP4 (FCounter_MSG *msg) {
	CPrintf("ACC:MAINEP4: Total number of nodes = %f\n", msg->data);
	delete msg ;
}

/* ****************************************** */
/* ****************************************** */
/* ****************************************** */


acc_fib::acc_fib (acc_MSG1 *msg1P) {
     int 	n,i, fibVal;
     acc_MSG1	*ptr1;
     acc_MSGUP	*ptr2;
     int 	temp;


     n = msg1P->fibNum;
     fibNum = n;

     icount->Accumulate(1);
     fcount->Accumulate(1.0);
     ihist->Accumulate(msg1P->level, 1);
     
     isFinal = ( msg1P->fibNum == acc_topFib ) ? TRUE : FALSE;
     parentID = msg1P->parentID;
     if (msg1P->fibNum <= acc_grainSize)
     { 
	  ptr2 = new acc_MSGUP ;
	  fibVal = Fib(n);
	  delete msg1P ;
	  acc_ProcessResult(isFinal, &parentID, fibVal, ptr2);
     }
     else 
     {
	  rspNum= 2;
	  rspData= 0;
	  ptr1 = new acc_MSG1 ;
	  ptr1->fibNum = n-1;
	  ptr1->level = msg1P->level + 1;
	  ptr1->parentID = thishandle;
	  msg1P->fibNum = n-2;
	  msg1P->level++;
	  msg1P->parentID = thishandle;
	  newchare acc_fib(ptr1);
	  newchare acc_fib(msg1P);
     }
}

/* ****************************************** */

void
acc_fib::RESPONSE (acc_MSGUP *msg2P) {
     rspNum--;
     rspData += msg2P->rspData;
     if (rspNum == 0) 
	  acc_ProcessResult(isFinal, &parentID,  rspData, msg2P);
     else
	  delete msg2P ;
}

/* ****************************************** */
/* ****************************************** */
/* ****************************************** */

void
acc_ProcessResult(int top, ChareIDType *CID, int value, acc_MSGUP *msg) {

     if (top)  
     {
	  acc_start handle h = *CID;

	  msg->rspData = value;
	  h=>MAINEP1(msg);
	  icount->CollectValue(&(acc_start::MAINEP2), *CID);
	  ihist->CollectValue(&(acc_start::MAINEP3), *CID);
	  fcount->CollectValue(&(acc_start::MAINEP4), *CID);
     }
     else
     {
	  acc_fib handle h = *CID;

	  msg->rspData = value;
	  h=>RESPONSE(msg);
     }
}

#endif
