/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: xp-lexer.h,v $
 *	$Author: jyelon $	$Locker:  $		$State: Exp $
 *	$Revision: 1.1 $	$Date: 1996/08/01 21:07:30 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: xp-lexer.h,v $
 * Revision 1.1  1996/08/01 21:07:30  jyelon
 * Initial revision
 *
 * Revision 2.2  1996/04/18 19:28:36  knauff
 * Added MAX_TOKEN_SIZE
 *
 * Revision 2.1  1995/09/14 21:25:39  knauff
 * *** empty log message ***
 *
 * Revision 2.0  1995/06/05  19:01:24  brunner
 * Reorganized directory structure
 *
 * Revision 1.4  1995/03/23  05:11:45  sanjeev
 * changes for printing call graph
 *
 * Revision 1.3  1994/11/11  21:16:12  brunner
 * Put back the lines containing "ident" that I accidentally removed
 *
 * Revision 1.2  1994/11/11  05:32:38  brunner
 * Removed ident added by accident with RCS header
 *
 * Revision 1.1  1994/11/07  15:41:05  brunner
 * Initial revision
 *
 ***************************************************************************/

#include <stdio.h>
#include <string.h>
#include <ctype.h>

#define TRUE 1
#define FALSE 0

#define MAXAGGS 1024
#define MAXCHARES 256
#define MAXMSGS 256
#define MAXACCS 256
#define MAXDTABLES 256
#define MAXREADS 512
#define MAXSYMBOLS 1024
#define MAX_NAME_LENGTH 256
#define MAX_OUTBUF_SIZE 1024
#define MAX_PARENTS 128
#define MAXIDENTS 256
#define MAX_MODULES 256
#define MAX_VARSIZE 64
#define MAX_FUNCTIONS 256
#define MAX_TOKEN_SIZE 1024

/* Types of Sends */
#define BROADCAST 123
#define SIMPLE 124
#define BRANCH 125

#define READMSG 1091

#define DTABLE 54321

#define BASE_PERM_INDEX 0x00008001

#define FLUSHBUF() fprintf(outfile,"%s",OutBuf) ; strcpy(OutBuf,"") ; \
                        fflush(outfile);

struct chareinfo ;

typedef struct ep {
        char epname[MAX_NAME_LENGTH] ;
        char msgname[MAX_NAME_LENGTH] ;
        int inherited ;
        int isvirtual ;
	int defined ;  /* defined (code present) in this module or not */
	struct ep * parentep ;
	struct chareinfo * chare ;	/* chare in which this ep is */

        struct ep *next ;
} EP ;

typedef struct fn {
	char fnname[MAX_NAME_LENGTH] ;
	struct fn *next ;
} FN ;

struct charelist ;

typedef struct chareinfo {
        char name[256] ;
        EP *eps ;
	FN *fns ;
        struct charelist *parents ;
} ChareInfo ;

typedef struct charelist {
        ChareInfo *chare ;
        struct charelist *next ;
} ChareList ;

typedef struct accstruct {
	char *name ;
	char *initmsgtype ;
	char *msgtype ;
	char *msg ;
	int defined ;
} AccStruct ;

typedef struct varsizestruct {
	char *name ;
	char *type ;
} VarSizeStruct ;

typedef struct msgstruct {
        char *name ;    /* name of a msg */
	int pack ; /* TRUE if this msg has a pack/unpack */
	int numvarsize ; /* number of varsize fields in this message */
	VarSizeStruct *varsizearray ; /* array of varSize fields' info */
} MsgStruct ;

typedef struct handle_entry {
        char *name ;    /* name of a handle identifier */
/*      int nameindex ;  its type : index into Chare/BOC/Acc/... table */
	char *typestr ;
} HandleEntry ;

typedef struct sym_entry {
        char *name ;    /* name of a typedef */
        int permanentindex ; /* its index into PermanentAggTable, if agg */
} SymEntry ;

typedef struct functionstruct {	/* global functions */
	char *name ;
	int defined ;
} FunctionStruct ;

typedef struct stackstruct { 
/* This structure is the nested scope stack element. It
   holds a record of the all tables, and is used to
   modify these tables when entering or leaving scoping constructs.  */
	int charecount ;
	int boccount ;
	int TotalMsgs ;
	int TotalAccs ;
	int TotalMonos ;
	int TotalReads ;
	int TotalReadMsgs ;
	int TotalSyms ;
	int ChareHandleTableSize ;
	int BOCHandleTableSize ;
	int AccHandleTableSize ;
	int MonoHandleTableSize ;

	struct stackstruct *next ;
} StackStruct ;


typedef struct aggstate {
/* This structure holds the state of all tables :
   the objects defined INSIDE an aggregate type.
   It is used to modify the tables when say, entering the
   body of a Agg::function defined outside the aggregate.	*/

	char name[MAX_NAME_LENGTH] ;

	ChareInfo ** ChareTable ;
	ChareInfo ** BOCTable ;
	MsgStruct * MessageTable ;
	AccStruct ** AccTable ;
	AccStruct ** MonoTable ;
	char ** ReadTable ;
	char ** ReadMsgTable ;
	SymEntry *SymTable ;
	HandleEntry *ChareHandleTable ;
	HandleEntry *BOCHandleTable ;
	HandleEntry *AccHandleTable ;
	HandleEntry *MonoHandleTable ;

	int charecount ;
	int boccount ;
	int TotalMsgs ;
	int TotalAccs ;
	int TotalMonos ;
	int TotalReads ;
	int TotalReadMsgs ;
	int TotalSyms ;
	int ChareHandleTableSize ;
	int BOCHandleTableSize ;
	int AccHandleTableSize ;
	int MonoHandleTableSize ;
} AggState ;

