/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: tam.p,v $
 *	$Author: jyelon $	$Locker:  $		$State: Exp $
 *	$Revision: 2.1 $	$Date: 1995/11/15 21:04:20 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: tam.p,v $
 * Revision 2.1  1995/11/15 21:04:20  jyelon
 * changed 'MyChareID' to 'ThisChareID'
 *
 * Revision 2.0  1995/07/05  20:13:28  brunner
 * Separated out multi stuff, and including in charm_pgms tree
 *
 * Revision 1.1  1995/02/25  01:27:08  jyelon
 * Initial revision
 *
 ***************************************************************************/
#include "testpgm.interface"
#include "tam.interface"
module tam {

#include "qd.h"

/************************************************************************/
/*									*/
/*	N'th Fiboncci number, using the naive recursive algorithm,	*/
/*	and explicit grainsize control.				        */
/************************************************************************/

#define TRUE 		1
#define FALSE 		0
#define INFINITY  	999999
#define MAX		1000000
#define MAX_COUNT 	10

message {
	int nodes;
} ACC_MSG;

message {
	int least;
} MONO_MSG;


message {
	ChareNumType dummy;
} INIT_MSG;

message {
	int id;
	int count;
	int accid;
	int monoid;
} VAGUE_MSG;

message {
	int monoid;
} INFO_MSG;

accumulator {

	ACC_MSG *msg;

	ACC_MSG * initfn (data)
	ACC_MSG *data;
	{
		msg = (ACC_MSG *) CkAllocMsg(ACC_MSG);
		msg->nodes = data->nodes;
		return(msg);
	}

	addfn (data)
	ACC_MSG *data;
	{
		msg->nodes += data->nodes;
	}

	combinefn (y)
	ACC_MSG *y;
	{
		msg->nodes += y->nodes;
	}
}  ACC1;

monotonic  {
	
	MONO_MSG *msg;

	MONO_MSG * initfn (data)
	MONO_MSG *data;
	{
		msg = (MONO_MSG *) CkAllocMsg(MONO_MSG);
		msg->least = INFINITY;
		return(msg);
	}
	
	updatefn (y)
	MONO_MSG *y;
	{
		if (msg->least > y->least)
		{
			msg->least = y->least;
			return(1);
		}
		return(0);	
	}
} MONO1;


void initfn()
{
}

/* ****************************************** */
chare start {

	int count;
	int  monoid[4];
    	int iteration;
    	EntryPointType retEP;
    	ChareIDType retID;

entry begin:(message main_test::INIT_MSG *imsg)
{    
	INIT_MSG *msg1, *msg2, *msg3;

     	iteration = imsg->iteration;
     	retEP = imsg->retEP;
     	retID = imsg->retID;
	count = 0;


	msg1 = (INIT_MSG *) CkAllocMsg(INIT_MSG);
	msg1->dummy = 1;
	msg2 = (INIT_MSG *) CkAllocMsg(INIT_MSG);
	msg2->dummy = 2;
	msg3 = (INIT_MSG *) CkAllocMsg(INIT_MSG);
	msg3->dummy = 3;
        CreateChare(next, next@INIT, msg1, NULL_VID, 1);
        CreateChare(next, next@INIT, msg2, NULL_VID, 2);
        CreateChare(next, next@INIT, msg3, NULL_VID, 3);
	StartQuiescence(Quiescence, &ThisChareID);
		CkFreeMsg(imsg);
}

entry Quiescence: (message QUIESCENCE_MSG *dmsg) 
{
	main_test::IT_MSG *imsg;

     	CkPrintf("TAM:Value of first bound is %d\n", 
		((MONO_MSG *) MonoValue(monoid[0]))->least);
     	CkPrintf("TAM:Value of second bound is %d\n", 
		((MONO_MSG *) MonoValue(monoid[1]))->least);
     	CkPrintf("TAM:Value of third bound is %d\n", 
		((MONO_MSG *) MonoValue(monoid[2]))->least);
     	CkPrintf("TAM:Quiescence Detected. \n");
	CkPrintf("TAM:\n\n");
	CkPrintf("TAM:-----------------------------------------------------------------------------\n");
	imsg = (main_test::IT_MSG *) CkAllocMsg (main_test::IT_MSG);
	imsg->iteration = iteration;

	SendMsg(retEP, imsg, &retID);
	CkFreeMsg(dmsg);
}

entry AccEntry:   (message ACC_MSG *msg)
{
	CkPrintf("TAM:main@AccEntry::  msg->nodes = %d\n", msg->nodes);
	CkFreeMsg(msg);
}

entry INFO: (message INFO_MSG *msg)
{
	monoid[count] = msg->monoid;
	count++;
	CkFreeMsg(msg);
}

} 

chare next {

	int id;
	int accid;
	int monoid;
	ChareIDType main_chareid;
	int acc_recd;
	int mono_recd;

entry INIT: (message INIT_MSG *msg) 
{

	ACC_MSG *acc_msg;
	MONO_MSG *mono_msg;

	acc_recd = mono_recd = 0;
	acc_msg = (ACC_MSG *) CkAllocMsg(ACC_MSG);
	mono_msg = (MONO_MSG *) CkAllocMsg(MONO_MSG);
	acc_msg->nodes = 0;
	mono_msg->least = INFINITY;
	id = msg->dummy;
	CreateAcc(ACC1, acc_msg, AccEntry, &ThisChareID);
	CreateMono(MONO1, mono_msg, MonoEntry, &ThisChareID);
	CkFreeMsg(msg);
}

entry AccEntry: (message INIT_MSG *msg) 
{
	VAGUE_MSG *tmsg;

	accid = msg->dummy;
	if (mono_recd)
	{
		tmsg = (VAGUE_MSG *) CkAllocMsg(VAGUE_MSG);
		tmsg->count = 0;
		tmsg->accid = accid;
		tmsg->monoid = monoid;
		tmsg->id = id;
		CreateChare(next, next@BEGIN, tmsg); 
	}
	else
		acc_recd = TRUE;
	CkFreeMsg(msg);
}

entry MonoEntry: (message INIT_MSG *msg) 
{
	VAGUE_MSG *tmsg;

	monoid = msg->dummy;
	if (acc_recd)
	{
		tmsg = (VAGUE_MSG *) CkAllocMsg(VAGUE_MSG);
		tmsg->count = 0;
		tmsg->accid = accid;
		tmsg->monoid = monoid;
		tmsg->id = id;
		CreateChare(next, next@BEGIN, tmsg); 
	}
	else
		mono_recd = TRUE;
	CkFreeMsg(msg);
}

entry BEGIN: (message VAGUE_MSG *msg)
{
	ACC_MSG *tmsg1;
	MONO_MSG *tmsg2;
	INFO_MSG *tmsg3;

	if (msg->count < MAX_COUNT)
	{
		msg->count += 1;

		tmsg1 = (ACC_MSG *) CkAllocMsg(ACC_MSG);
		tmsg1->nodes = msg->id;
		Accumulate(msg->accid, addfn(tmsg1));

		tmsg2 = (MONO_MSG *) CkAllocMsg(MONO_MSG);
		tmsg2->least  = MAX_COUNT * msg->id - msg->count; 
		NewValue(msg->monoid, updatefn(tmsg2));

		CreateChare(next, next@BEGIN, msg);
		ChareExit();
	}
	else
	{
		tmsg3 = (INFO_MSG *) CkAllocMsg(INFO_MSG);
		tmsg3->monoid = msg->monoid;
		MainChareID(&main_chareid);
		SendMsg(start@INFO, tmsg3, &main_chareid);
		CollectValue(msg->accid, start@AccEntry, &main_chareid);
	}
	CkFreeMsg(msg);
}
}
}
