#ifndef _tpk_P_
#define _tpk_P_

#include "tpk.h"
#include <stdlib.h>

extern "C" long lrand48();
extern "C" void srand48(long);
#define rand() lrand48()

tpk_start::tpk_start (INIT_MSG *imsg) {

     int i;
     tpk_MSG2 *msg;

     iteration = imsg->iteration;
     retEP = imsg->retEP;
     retID = imsg->retID;

     msg = new tpk_MSG2 ;
     msg->x = (int *) new int[2];
     for (i=0; i<2; i++)
	  msg->x[i] = i;
     msg->size = 2;
     msg->count = 0;
     newchare (NULL_VID, 1) tpk_fib(msg); 
     chareid = thishandle;
     CStartQuiescence(&(tpk_start::Quiescence), chareid);
     delete imsg ;
}

void
tpk_start::Quiescence (QuiescenceMessage *dmsg) {

     IT_MSG *imsg;
     CPrintf("TPK:Quiescence Detected.\n");
     imsg = new IT_MSG ;
     imsg->iteration = iteration;
     
     generic_class handle id = retID;
     id=>retEP(imsg);
//     SendMsg(retEP, imsg, &retID);
     delete dmsg ;
}

/************************************************************/


tpk_fib::tpk_fib (tpk_MSG2 *msg) {

     int i; 
     int nextpe;
     tpk_MSG2 *tmsg;

     if (msg->count < 20)
     {
/*		CPrintf("[%d] GOAL:: ", McMyPeNum());
		for (i=0; i<msg->size; i++)
			CPrintf("%2d ", msg->x[i]);
		CPrintf("\n");
*/
	  if (msg->count == 0)
	       top = 1;
	  else {
	       top = 0;
	       chareid = msg->chareid;
	  }	

	  if(!(msg->count % 25))
	       CPrintf("%d, ", msg->count);

	  nextpe = rand() % CMaxPeNum();
	  tmsg = new tpk_MSG2 ;
	  tmsg->size = msg->size + 1;
	  tmsg->count = msg->count + 1;
	  tmsg->chareid = thishandle;
	  tmsg->x = (int *) new int[tmsg->size];
	  for (i=0; i<tmsg->size; i++)
	       tmsg->x[i] = i;	
	  newchare (&NULL_HANDLE, nextpe) tpk_fib(tmsg) ;
//	  CreateChare(fib, fib@GOAL, tmsg, NULL_VID, nextpe); 
	  delete msg ;
     }

     else {

	  chareid = msg->chareid;
	  CPrintf("Starting backwards \n");
	  SendResponseBack(msg);

     }

}

void
tpk_fib::RESPONSE (tpk_MSG2 *msg) {

     int i; 

     if (!top) {

/*		CPrintf("[%d] GOAL:: ", McMyPeNum());
		for (i=0; i<msg->size; i++)
			CPrintf("%2d ", msg->x[i]);
		CPrintf("\n");
*/
	  SendResponseBack(msg);
     }
     else {

	  CPrintf("Awaiting Quiescence \n");
	  delete msg ;
     }
}

void
tpk_fib::SendResponseBack(tpk_MSG2 *msg) {

     int i;
     tpk_MSG2 *tmsg;

     tmsg = new tpk_MSG2 ;
     tmsg->size = msg->size - 1;
     if(!(tmsg->size%25))
	  CPrintf("%d, ", tmsg->size);
     tmsg->x = (int *) new int[tmsg->size];
     for (i=0; i<tmsg->size; i++)
	  tmsg->x[i] = i;	

     tpk_fib handle h = chareid;
     h=>RESPONSE(tmsg);
//     SendMsg(fib@RESPONSE, tmsg, &chareid);
     delete msg ;
}

void tpk_initfn() {
}

#endif
