/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: priotest.c,v $
 *	$Author: milind $	$Locker:  $		$State: Exp $
 *	$Revision: 1.2 $	$Date: 1996/11/23 02:25:32 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: priotest.c,v $
 * Revision 1.2  1996/11/23 02:25:32  milind
 * Fixed several subtle bugs in the converse runtime for convex
 * exemplar.
 *
 * Revision 1.1  1996/07/02 21:22:49  jyelon
 * Initial revision
 *
 * Revision 1.1  1996/06/24 18:26:46  jyelon
 * Initial revision
 *
 ***************************************************************************/
static char ident[] = "@(#)$Header: /expand1/cvsroot/charm/pgms/megacon/priotest.c,v 1.2 1996/11/23 02:25:32 milind Exp $";

#include <stdio.h>
#include <converse.h>

void Cpm_megacon_ack();

typedef struct priotest_chare
{
  int numreceived;
  int totalexpected;
}
*priotest_chare;
CpmDeclareSimple(priotest_chare);
#define CpmPack_priotest_chare(p) (0)
#define CpmUnpack_priotest_chare(p) (0)

#include "priotest.cpm.h"

CpmInvokable priotest_bink(priotest_chare c, int n)
{
  if (n != c->numreceived) {
    CmiError("priotest: message received in wrong order.\n");
    exit(1);
  }
  c->numreceived++;
  if (c->numreceived == c->totalexpected) {
    CmiFree(c);
    Cpm_megacon_ack(CpmSend(0));
  }
}

CpmInvokable priotest_send()
{
  int me = CmiMyPe();
  priotest_chare c = (priotest_chare)CmiAlloc(sizeof(struct priotest_chare));
  c->numreceived = 0;
  c->totalexpected = 8;
  Cpm_priotest_bink(CpmEnqueueIFIFO(me, 1), c, 1);
  Cpm_priotest_bink(CpmEnqueueIFIFO(me, 5), c, 5);
  Cpm_priotest_bink(CpmEnqueueIFIFO(me, 2), c, 2);
  Cpm_priotest_bink(CpmEnqueueIFIFO(me, 4), c, 4);
  Cpm_priotest_bink(CpmEnqueueIFIFO(me, 3), c, 3);
  Cpm_priotest_bink(CpmEnqueueIFIFO(me, 6), c, 6);
  Cpm_priotest_bink(CpmEnqueueIFIFO(me, 0), c, 0);
  Cpm_priotest_bink(CpmEnqueueIFIFO(me, 7), c, 7);
}

void priotest_init()
{
  Cpm_priotest_send(CpmSend(CpmALL));
}

void priotest_moduleinit()
{
  CpmInitializeThisModule();
}
