/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: posixth.c,v $
 *	$Author: jyelon $	$Locker:  $		$State: Exp $
 *	$Revision: 1.4 $	$Date: 1997/07/25 22:47:22 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: posixth.c,v $
 * Revision 1.4  1997/07/25 22:47:22  jyelon
 * Added the posix threads test.
 *
 * Revision 1.3  1997/07/25 21:43:37  jyelon
 * Still working on posix.
 *
 * Revision 1.2  1997/07/22 20:17:35  milind
 * Fixed makefile bugs regarding posixth.c linking.
 *
 * Revision 1.1  1997/07/22 18:19:21  jyelon
 * This isn't really a test yet, it's a copy of ring.
 *
 *
 ***************************************************************************/
static char ident[] = "@(#)$Header: /expand1/cvsroot/charm/pgms/megacon/posixth.c,v 1.4 1997/07/25 22:47:22 jyelon Exp $";

#include <stdio.h>
#include <converse.h>
#include <cpthreads.h>
#include "posixth.cpm.h"

void Cpm_megacon_ack();

CpvStaticDeclare(Cpthread_attr_t,  joinable);
CpvStaticDeclare(Cpthread_attr_t,  detached);

CpvStaticDeclare(Cpthread_mutexattr_t, mutexattrs);
CpvStaticDeclare(Cpthread_condattr_t,  condattrs);

CpvStaticDeclare(Cpthread_mutex_t, total_mutex);
CpvStaticDeclare(int,              total);
CpvStaticDeclare(Cpthread_mutex_t, leaves_mutex);
CpvStaticDeclare(int,              leaves);
CpvStaticDeclare(Cpthread_mutex_t, fibs_mutex);
CpvStaticDeclare(int,              fibs);

CpvStaticDeclare(Cpthread_cond_t,  donecond);

static void posixth_fail()
{
  CmiError("error detected in posix threads.\n");
  exit(1);
}

static void errck(int code)
{
  if (code != 0) posixth_fail();
}

void posixth_add(Cpthread_mutex_t *mutex, int *var, int val)
{
  int n;
  Cpthread_mutex_lock(mutex);
  n = *var;
  if (rand()&1) CthYield();
  *var = n + val;
  Cpthread_mutex_unlock(mutex);
}

void *posixth_fib(void *np)
{
  Cpthread_t t1, t2; void *r1, *r2; int total;
  int n = (int)np;
  if (n<2) {
    if (rand()&1) CthYield();
    posixth_add(&CpvAccess(leaves_mutex), &CpvAccess(leaves), 1);
    return (void*)n;
  }
  if (rand()&1) CthYield();
  errck(Cpthread_create(&t1, &CpvAccess(joinable), posixth_fib, (void*)(n-1)));
  if (rand()&1) CthYield();
  errck(Cpthread_create(&t2, &CpvAccess(joinable), posixth_fib, (void*)(n-2)));
  if (rand()&1) CthYield();
  errck(Cpthread_join(t1, &r1));
  if (rand()&1) CthYield();
  errck(Cpthread_join(t2, &r2));
  if (rand()&1) CthYield();
  total = ((int)r1) + ((int)r2);
  return (void*)total;
}

void *posixth_top(void *x)
{
  Cpthread_t t; void *result; int n;
  if (rand()&1) CthYield();
  errck(Cpthread_create(&t, &CpvAccess(joinable), posixth_fib, (void*)6));
  if (rand()&1) CthYield();
  errck(Cpthread_join(t, &result));
  if (rand()&1) CthYield();
  if ((int)result != 8) posixth_fail();
  if (rand()&1) CthYield();
  posixth_add(&CpvAccess(total_mutex), &CpvAccess(total), (int)result);
  if (rand()&1) CthYield();
  posixth_add(&CpvAccess(fibs_mutex), &CpvAccess(fibs), -1);
  if (rand()&1) CthYield();
  if (CpvAccess(fibs)==0)
    errck(Cpthread_cond_signal(&CpvAccess(donecond)));
  if (rand()&1) CthYield();
}

void posixth_main(int argc, char **argv)
{
  Cpthread_mutex_t dummymutex; int i; Cpthread_t t;

  if (rand()&1) CthYield();
  errck(Cpthread_attr_init(&CpvAccess(joinable)));
  if (rand()&1) CthYield();
  errck(Cpthread_attr_setdetachstate(&CpvAccess(joinable),CPTHREAD_CREATE_JOINABLE));
  if (rand()&1) CthYield();
  errck(Cpthread_attr_init(&CpvAccess(detached)));
  if (rand()&1) CthYield();
  errck(Cpthread_attr_setdetachstate(&CpvAccess(detached),CPTHREAD_CREATE_DETACHED));
  if (rand()&1) CthYield();
  errck(Cpthread_mutexattr_init(&CpvAccess(mutexattrs)));
  if (rand()&1) CthYield();
  errck(Cpthread_condattr_init(&CpvAccess(condattrs)));
  if (rand()&1) CthYield();
  errck(Cpthread_mutex_init(&CpvAccess(total_mutex), &CpvAccess(mutexattrs)));
  if (rand()&1) CthYield();
  errck(Cpthread_mutex_init(&CpvAccess(leaves_mutex), &CpvAccess(mutexattrs)));
  if (rand()&1) CthYield();
  errck(Cpthread_mutex_init(&CpvAccess(fibs_mutex), &CpvAccess(mutexattrs)));
  if (rand()&1) CthYield();
  errck(Cpthread_cond_init(&CpvAccess(donecond), &CpvAccess(condattrs)));
  if (rand()&1) CthYield();
  CpvAccess(total) = 0;
  CpvAccess(fibs) = 20;
  CpvAccess(leaves) = 0;

  for (i=0; i<20; i++) {
    if (rand()&1) CthYield();
    Cpthread_create(&t, &CpvAccess(detached), posixth_top, 0);
  }

  if (rand()&1) CthYield();
  errck(Cpthread_mutex_init(&dummymutex, &CpvAccess(mutexattrs)));
  if (rand()&1) CthYield();
  errck(Cpthread_mutex_lock(&dummymutex));
  if (rand()&1) CthYield();
  errck(Cpthread_cond_wait(&CpvAccess(donecond), &dummymutex));
  if (rand()&1) CthYield();
  errck(Cpthread_mutex_unlock(&dummymutex));
  if (rand()&1) CthYield();
  errck(Cpthread_mutex_destroy(&dummymutex));
  if (rand()&1) CthYield();
  
  if (CpvAccess(total)!=160) posixth_fail();
  if (CpvAccess(leaves)!=260) posixth_fail();
  
  if (rand()&1) CthYield();
  errck(Cpthread_mutex_destroy(&CpvAccess(total_mutex)));
  if (rand()&1) CthYield();
  errck(Cpthread_mutex_destroy(&CpvAccess(leaves_mutex)));
  if (rand()&1) CthYield();
  errck(Cpthread_mutex_destroy(&CpvAccess(fibs_mutex)));
  if (rand()&1) CthYield();
  errck(Cpthread_cond_destroy(&CpvAccess(donecond)));
  if (rand()&1) CthYield();
  
  Cpm_megacon_ack(CpmSend(0));
}

void posixth_init(void)
{
  Cpthread_start_main(posixth_main, 0, 0);
}

void posixth_moduleinit()
{
  CpmInitializeThisModule();

  CpvInitialize(Cpthread_attr_t, joinable);
  CpvInitialize(Cpthread_attr_t, detached);
  CpvInitialize(Cpthread_mutexattr_t, mutexattrs);
  CpvInitialize(Cpthread_condattr_t,  condattrs);
  CpvInitialize(Cpthread_mutex_t, total_mutex);
  CpvInitialize(int,              total);
  CpvInitialize(Cpthread_mutex_t, leaves_mutex);
  CpvInitialize(int,              leaves);
  CpvInitialize(Cpthread_mutex_t, fibs_mutex);
  CpvInitialize(int,              fibs);
  CpvInitialize(Cpthread_cond_t,  donecond);
  
}
