/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: deadlock.c,v $
 *	$Author: milind $	$Locker:  $		$State: Exp $
 *	$Revision: 1.2 $	$Date: 1996/08/08 17:17:29 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * In this test, two processors try to force a zillion messages down each
 * other's throats, and we see whether the system can handle it.
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: deadlock.c,v $
 * Revision 1.2  1996/08/08 17:17:29  milind
 * small typo fixed
 *
 * Revision 1.1  1996/07/02 21:22:49  jyelon
 * Initial revision
 *
 * Revision 1.1  1996/06/24 18:26:46  jyelon
 * Initial revision
 *
 ***************************************************************************/
static char ident[] = "@(#)$Header: /expand1/cvsroot/charm/pgms/megacon/deadlock.c,v 1.2 1996/08/08 17:17:29 milind Exp $";

#include <stdio.h>
#include <converse.h>

typedef struct incmsg
{
  char head[CmiMsgHeaderSizeBytes];
  int n;
}
*incmsg;

CpvDeclare(int, deadlock_inc_idx);
CpvDeclare(int, deadlock_cram_idx);
CpvDeclare(int, deadlock_count);

void Cpm_megacon_ack();

void deadlock_inc(incmsg m)
{
  CpvAccess(deadlock_count) += m->n;
  if (CpvAccess(deadlock_count)==0) {
    Cpm_megacon_ack(CpmSend(0));
  }
}

void deadlock_cram(char *msg)
{
  struct incmsg m;
  int count = 0;
  CmiSetHandler(&m, CpvAccess(deadlock_inc_idx));
  m.n = 1;
  while (count<50000) {
    CmiSyncSend(1-CmiMyPe(), sizeof(m), &m);
    count++;
  } 
  m.n = -count;
  CmiSyncSend(1-CmiMyPe(), sizeof(m), &m);
}

void deadlock_init()
{
  char msg[CmiMsgHeaderSizeBytes];
  if (CmiNumPes()<2) {
    CmiPrintf("warning: need 2 processors for deadlock-test, skipping.\n");
    Cpm_megacon_ack(CpmSend(0));
    Cpm_megacon_ack(CpmSend(0));
  } else {
    CmiSetHandler(msg, CpvAccess(deadlock_cram_idx));
    CmiSyncSend(0, sizeof(msg), msg);
    CmiSyncSend(1, sizeof(msg), msg);
  }
}

void deadlock_moduleinit()
{
  CpvInitialize(int, deadlock_inc_idx);
  CpvInitialize(int, deadlock_cram_idx);
  CpvInitialize(int, deadlock_count);
  CpvAccess(deadlock_inc_idx) = CmiRegisterHandler(deadlock_inc);
  CpvAccess(deadlock_cram_idx) = CmiRegisterHandler(deadlock_cram);
  CpvAccess(deadlock_count) = 0;
}
