/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: latencyBWtest.c,v $
 *	$Author: jyelon $	$Locker:  $		$State: Exp $
 *	$Revision: 1.3 $	$Date: 1997/03/19 04:28:24 $
 *
 ***************************************************************************
 * DESCRIPTION:
 * Send a message around a ring, to measure message latency and bandwidth
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: latencyBWtest.c,v $
 * Revision 1.3  1997/03/19 04:28:24  jyelon
 * Restructured main
 *
 * Revision 1.2  1996/11/23 02:25:30  milind
 * Fixed several subtle bugs in the converse runtime for convex
 * exemplar.
 *
 * Revision 1.1  1996/02/05 15:05:49  brunner
 * Initial revision
 *
 ***************************************************************************/
static char ident[] = "@(#)$Header: /expand1/cvsroot/charm/pgms/latencyBWtest/latencyBWtest.c,v 1.3 1997/03/19 04:28:24 jyelon Exp $";

#include "converse.h"
#include <stdio.h>

static int counter;
extern int NumIntr;


int failCount;

void lbw_main(argc, argv)
    int argc; char **argv;
{
  double CmiTimer();
  int myPE;
  int i;
  int j,k;
  double t0,t1,t2;
  int waitForAck;

  counter = 6;

  CmiPrintf("Starting ConverseRing()\n");
  ConverseRing(1000000,20);
  CsdScheduler(-1); 
  CmiPrintf("Exited scheduler.\n");

  CmiPrintf("Starting ConverseRing()\n");
  ConverseRing(100,1000);
}

void main(int argc, char **argv)
{
  ConverseInit(argc,argv,lbw_main,0,0);
}

#define TSCOUNT 5

int hndl_id, hndl_id2,  sendPE; 
int  *my_msg;
int MSG_SIZ;
int total_messages, num_messages;
double start_time, msg_time;
double per_ping;
FILE *fptr;
char filename[50];

void hndlr2(msg)
void *msg;
{
      if(CmiMyPe() != 0)
	CmiSyncSend(sendPE, 16, msg);
      CmiPrintf("[%d] last round with a short msg. num_messages=%d\n", CmiMyPe(), num_messages);
      CsdExitScheduler();
      
}

void hndlr(msg)
int *msg;
{
  int i;
  double CmiTimer();

  num_messages ++;
/*   CmiPrintf("[%d] converse ring hopping. num_messages=%d\n",CmiMyPe(),num_messages);*/
/*  CkFree(msg); /* May go away as Cmi takes over this responsibility */
/* CmiPrintf("[%d] hopping. num_messages=%d\n", CmiMyPe(), num_messages);*/


      for (i=0; i<(MSG_SIZ/4-20); i++)
	if (msg[i+10] != i) { 
	  CmiPrintf("[%d]Error in msg content.i=%d, i+10=%d, msg[i+10]=%d\n",
		    CmiMyPe(), i, i+10, msg[i+10]);
	  break;
	}

  if(num_messages < total_messages)
    {
      if(num_messages == TSCOUNT)
	start_time = CmiTimer();
      CmiSyncSend(sendPE, MSG_SIZ, msg);
    }
  else
    {
      if(CmiMyPe() != 0)
	CmiSyncSend(sendPE, MSG_SIZ, msg);
      else {   CmiSetHandler(msg, hndl_id2);
	       CmiSyncSend(sendPE, 16, msg);}
      msg_time =  CmiTimer() - start_time;
      per_ping =  msg_time/(2.0*(total_messages -TSCOUNT) );
      CmiPrintf("[%d] converse ring done %d %f %f\n", CmiMyPe(), MSG_SIZ, msg_time, per_ping);
      
    }
}

ConverseRing(size, repetitions)
int size, repetitions;
{
  int i;
  
  total_messages = TSCOUNT + repetitions;
  
  MSG_SIZ = size;
  my_msg = (int *)malloc(MSG_SIZ);
  num_messages = 0;
  hndl_id = CmiRegisterHandler(hndlr);
  hndl_id2 = CmiRegisterHandler(hndlr2);
  sendPE = (CmiMyPe() + 1) % CmiNumPes();
  CmiSetHandler(my_msg, hndl_id);

  if(CmiMyPe() == 0)
    { 
      for (i=0; i<(MSG_SIZ/4-20); i++)
	my_msg[i+10] = i;
      CmiSyncSend(sendPE, MSG_SIZ, my_msg);
    }
}





