/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: pgm.C,v $
 *	$Author: milind $	$Locker:  $		$State: Exp $
 *	$Revision: 1.2 $	$Date: 1997/01/15 16:17:45 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: pgm.C,v $
 * Revision 1.2  1997/01/15 16:17:45  milind
 * Changed CmiAlloc interrupt-safe for HP machines.
 *
 * Revision 1.1  1996/07/02 21:32:11  brunner
 * Initial revision
 *
 * Revision 2.2  1995/11/08 21:38:43  jyelon
 * *** empty log message ***
 *
 * Revision 2.1  1995/07/09  18:19:07  narain
 * McTimer -> CkTimer
 *
 * Revision 2.0  1995/06/01  21:11:14  brunner
 * Reorganized directory structure
 *
 * Revision 1.1  1994/10/14  21:56:25  brunner
 * Initial revision
 *
 ***************************************************************************/

#include <stdio.h>
#include <string.h>

#include "ckdefs.h"
#include "chare.h"
#include "c++interface.h"

#include "pgm.top.h"
#include "pgm.h"
#include "pgm.bot.h"

main::main(int argc, char *argv[])
{ 
  PartialBoard *pMsg ;
  DUMMYMSG *m, *m1;

  num_found = 0;

  CPrintf("Enter n: ");
  CScanf("%d", &N);
  ReadInit(N);

  CPrintf("Enter grain-size: ");
  CScanf("%d", &grain);
  ReadInit(grain); 

  m = new (MsgIndex(DUMMYMSG)) DUMMYMSG;
  m1 = new (MsgIndex(DUMMYMSG)) DUMMYMSG;
  bocId = new_group(recordProgress, m1);
  ReadInit(bocId);

  pMsg = new (MsgIndex(PartialBoard)) PartialBoard;
  pMsg->nextRow = 0;
  
  new_chare(queens, pMsg);  
  t0 = CmiTimer();
  
  CStartQuiescence(GetEntryPtr(main,Quiescence1), mainhandle);
}

main::solutionFound(DUMMYMSG *msg)
{
  num_found++;
  delete msg;
  return 0;
}

main::Quiescence1(DUMMYMSG *msg) 
{ 
  CPrintf("The total number of solutions to %d queens is: %d, at time=%f\n", 
	  ReadValue(N), num_found, CmiTimer()-t0);
  CkExit();
  return 0;
}

recordProgress::recordProgress(DUMMYMSG *m)
{ 
  count = 0; 
}

void recordProgress::processedOne(void)
{ 
  count++;
}

queens::queens(PartialBoard *m)
{ 
  int col,i, row;
  PartialBoard *newMsg;
  
  row = m->nextRow;  

  CLocalBranch(recordProgress, ReadValue(bocId))->processedOne();

  if (row == ReadValue(N)) 
  {
    printSolution(m->Queens);
    DUMMYMSG *solution_msg = new (MsgIndex(DUMMYMSG)) DUMMYMSG;

    CSendMsg(main,solutionFound,solution_msg,&mainhandle);
  }
  else if ( (ReadValue(N)-row) < ReadValue(grain)) 
    seqQueens(m->Queens, row); 
  else
  {
    for (col = 0; col<ReadValue(N); col++) 
      if (consistent(m->Queens, row, col))
      {
	newMsg = new (MsgIndex(PartialBoard)) PartialBoard;
	newMsg->nextRow = row + 1;
	for (i=0; i<ReadValue(N); i++)
	  newMsg->Queens[i] = m->Queens[i];
	newMsg->Queens[row] = col;
	new_chare(queens, newMsg);  
      }
  }
  delete m;
  ChareExit(); 
}

void queens::seqQueens(int queens[], int nextRow)
{ 
  int col;
  
  if (nextRow == ReadValue(N)) 
  { 
    printSolution(queens);
    DUMMYMSG *solution_msg = new (MsgIndex(DUMMYMSG)) DUMMYMSG;

    CSendMsg(main,solutionFound,solution_msg,&mainhandle);
    return; 
  }

  for (col = 0; col<ReadValue(N); col++) 
    if (consistent(queens, nextRow, col))
    {
      queens[nextRow] = col;
      seqQueens(queens, nextRow+1);
    }
}

int queens::consistent(int queens[], int lastRow, int col)
{ 
  /* check if the new queen is safe from each of the */
  /* previously placed queens */
  int x,y;

  for (x=0; x<lastRow; x++)
  { 
    y = queens[x];
    if ((y==col)  || ((lastRow-x) == (col-y)) || ((lastRow-x) == (y-col)) )
      return(0);
  }

  return(1);
}

void queens::printSolution(int queens [])
{ 
  int row;
  char buf[80], tmp[80];

  buf[0] = '\0';
  for (row=0; row<N; row++)
  { 
    sprintf(tmp, "(%d,%d) ", row, queens[row]);
    strcat(buf, tmp);
  }
  CPrintf("%s\n", buf);
}



