/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: pgm.P,v $
 *	$Author: sanjeev $	$Locker:  $		$State: Exp $
 *	$Revision: 2.6 $	$Date: 1995/11/02 21:13:35 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: pgm.P,v $
 * Revision 2.6  1995/11/02 21:13:35  sanjeev
 * cd ..
 *
 * Revision 2.5  1995/11/01  16:54:44  sanjeev
 * *** empty log message ***
 *
 * Revision 2.4  1995/10/30  21:02:48  sanjeev
 * *** empty log message ***
 *
 * Revision 2.3  1995/10/27  14:50:56  sanjeev
 * *** empty log message ***
 *
 * Revision 2.2  1995/09/28  17:31:25  sanjeev
 * *** empty log message ***
 *
 * Revision 2.1  1995/09/06  04:11:18  sanjeev
 * added some new Charm++ syntax
 *
 * Revision 2.0  1995/06/01  20:23:15  brunner
 * Reorganized directory structure
 *
 * Revision 1.2  1995/04/16  20:46:11  sanjeev
 * moved SolutionMsg's pack and unpack fns outside the msg decl
 *
 * Revision 1.1  1994/10/14  21:10:46  brunner
 * Initial revision
 *
 ***************************************************************************/

#include <stdio.h>
#include <string.h>

/************************************************************************/
/* Finding the Nth fibonacci number				        */
/* Using dynamic tables to avoid duplication			        */
/************************************************************************/

typedef void (*FNPTR)(float) ;

void func(float f)
{	
/*	CPrintf("[%d] In func, f=%f\n",CMyPeNum(),f) ;	*/
}

int Fib(int) ;

extern readonly int grainSize, topFib;
#include "dtable.h"
table fibtbl, table2;

chare class basechare {
} ;

message  class ProblemMsg {
public:	int n;
	basechare handle parentID;
	EntryPointType sendToEp;
	int vartest1[VARSIZE] ;
	int vartest2[VARSIZE] ;
	FunctionRefType afn ;
} ;

message class PackedMsg {
public:	int mfib ;
	float f[5] ;
} ;

message class SolutionMsg {
public:        int mfib;
        float *f ;
 
        void *pack(int *length) ;  // Pack and unpack functions, used to send
        void unpack(void *in) ;    // arbitrary data structures across PEs.
} ;


void *SolutionMsg::pack(int *length)
{	// Pack the array pointed to by f into a contiguous buffer
	// inside a PackedMsg. Return the length and the new buffer

	PackedMsg *p = (PackedMsg *)new_packbuffer((void *)this, sizeof(PackedMsg) ) ;
	for ( int i=0; i<5; i++ ) 
		p->f[i] = f[i] ;	
	p->mfib = mfib ;
	*length = sizeof(PackedMsg) ;
	
	delete f ;

	return((void *)p) ;
}

void SolutionMsg::unpack(void *in)
{	// Unpack the buffer inside "in" and put it in f

	f = new float[5] ;
	for ( int i=0; i<5; i++ ) 
		f[i] = ((PackedMsg *)in)->f[i] ;	
	mfib = ((PackedMsg *)in)->mfib ;
}


chare class fib :public basechare  
{
	basechare handle parent;
	EntryPointType parentEP;
	int total, count;
	int n,k;
	int store;
	int key;

entry:

void Response (SolutionMsg * msg)
{ 
	total += msg->mfib;
/*	CPrintf("[%d] Pack data = %f %f %f %f %f\n",CMyPeNum(),msg->f[0],msg->f[1],msg->f[2],msg->f[3],msg->f[4]) ;	*/
	delete msg ;

	if (--count == 0)	// if all children chares have responded
		sendResponse(total);
}

fib(ProblemMsg *msg) ;

void TblChecked (TableMessage *msg)
{ 
	ProblemMsg *msg1, *msg2;
	int temp;
	int sizes[2] ;
	sizes[0] = 2 ;
	sizes[1] = 1 ;

	if (msg->data != NULL)
	{
		temp = *((int *) msg->data);
		store = 0;
		sendResponse(temp);
	}
	else 
	{
		if (n  < grainSize) 
			sendResponse( Fib(n)) ;
		else       /* Otherwise, start parallel subcomputations. */
		{
			total = 0; 
			count = 2;
			msg1 =  new (sizes) ProblemMsg;
			msg2 =  new (sizes) ProblemMsg;
			msg1->n = n-1;      
			msg1->vartest1[0] = 12 ;
			msg1->vartest1[1] = 0xffff0000 ;
			msg1->vartest2[0] = 108 ;
			msg1->sendToEp = &(fib::Response) ;
			msg1->parentID = thishandle ;
			msg1->afn = (FunctionRefType)CFunctionNameToRef(func) ;
			// create a child chare 
			newchare fib(msg1);   /* fib(n-1,k-1) */
			msg2->n = n-2; 
			msg2->vartest1[0] = 12 ;
			msg2->vartest1[1] = 0xffff0000 ;
			msg2->vartest2[0] = 108 ;
			msg2->parentID = thishandle ;
			msg2->sendToEp = &(fib::Response) ;
			msg2->afn = (FunctionRefType)CFunctionNameToRef(func) ;
			// create a child chare 
			newchare fib(msg2);    /* fib(n-k,k) */
		}
	}
	delete msg ;
}

private :
void sendResponse(int value)
{ 
	SolutionMsg * resp;

	resp = new SolutionMsg ;
	resp->mfib = value;
	resp->f = new float[5] ;
	resp->f[0] = 0.1 ;
	resp->f[1] = 1.0 ;
	resp->f[2] = 10.0 ;
	resp->f[3] = 100.0 ;
	resp->f[4] = 10000000000.0 ;

	// send response to the parent
	parent=>parentEP(resp) ;

	// insert current value into the distributed table
	if (store) 
		fibtbl.Insert(key, &value, sizeof(value), NULL_EP, 
				NULL_HANDLE, TBL_NOWAITFORDATA);
}

} ;

fib::fib(ProblemMsg *msg)
{ 
	// This entry point is executed when a chare is created 

	// This is an example of how to get the function pointer back
	FNPTR funcptr = (FNPTR)CFunctionRefToName(msg->afn) ;

	(*funcptr)((float)CMyPeNum()) ;

/*	CPrintf("[%d] vartest1[0]=%d, vartest1[1]=%x, vartest2[0]=%d\n",
		CMyPeNum(),msg->vartest1[0],msg->vartest1[1],msg->vartest2[0]);
*/

	parent = msg->parentID;     
	parentEP = msg->sendToEp;
	n = msg->n; 
	store = 1;
	key = n ;

	// Check if this fib number has already been computed
	fibtbl.Find(key, &(fib::TblChecked), thishandle, TBL_WAIT_AFTER_FIRST);

	delete msg ;
}


Fib(int n)
{ 
	// the sequential fib

	if (n<2)
		return(n);
	else
		return(Fib(n-1)+Fib(n-2));
}
